/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.matrix.SymMatrix;
import com.spss.math.statistics.CCBitSet;
import java.util.Arrays;

public class DiagMatrix
implements SymMatrix {
    int fNRows;
    double[] fDiag;

    public DiagMatrix() {
        this.fNRows = 0;
    }

    public DiagMatrix(int nRows) {
        this.fNRows = nRows >= 0 ? nRows : 0;
        this.fDiag = new double[this.fNRows];
    }

    public DiagMatrix(double[] diagV) {
        this.fNRows = diagV.length;
        this.fDiag = diagV;
    }

    public DiagMatrix(DiagMatrix sm) {
        this.fNRows = sm.fNRows;
        this.fDiag = Arrays.copyOf(sm.fDiag, sm.fDiag.length);
    }

    @Override
    public boolean computeSV(double[] inpVec, double[] outVec) {
        boolean result = false;
        if (inpVec.length == this.fNRows && outVec.length == this.fNRows) {
            for (int i = 0; i < this.fNRows; ++i) {
                outVec[i] = this.fDiag[i] * inpVec[i];
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean computeSV(int nRows, double[] inpVec, double[] outVec) {
        boolean result;
        boolean bl = result = inpVec.length >= nRows && nRows >= 0 && nRows <= this.fNRows;
        if (result) {
            if (outVec.length < nRows) {
                outVec = new double[nRows];
            }
            for (int i = 0; i < nRows; ++i) {
                outVec[i] = this.fDiag[i] * inpVec[i];
            }
        }
        return result;
    }

    @Override
    public void clear() {
        Arrays.fill(this.fDiag, 0.0);
    }

    @Override
    public void changeSign() {
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi) {
        return 0;
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi, CCBitSet nonRed) {
        return 0;
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi, double[] minDg) {
        return 0;
    }

    @Override
    public boolean computeAXpY(double alpha, DenseSymMatrix x) {
        return false;
    }

    @Override
    public boolean computeGMG(double[] mVec, DenseSymMatrix gmg) {
        int mSize = this.fNRows * (this.fNRows + 1) / 2;
        if (mVec.length != mSize) {
            return false;
        }
        if (gmg.getNRows() != this.fNRows) {
            boolean bAllocOK = gmg.setNRows(this.fNRows);
            if (!bAllocOK) {
                return false;
            }
        } else {
            gmg.clear();
        }
        for (int iRow = 0; iRow < this.fNRows; ++iRow) {
            for (int iCol = 0; iCol <= iRow; ++iCol) {
                double dotP = this.computeRowDotProductS(iCol, mVec, iRow);
                gmg.setElem(iRow, iCol, dotP * this.fDiag[iRow]);
            }
        }
        return true;
    }

    @Override
    public double computeRowDotProductS(int iRow, DenseSymMatrix mInpS, int iRowS) {
        double result = MissingValue.getMissing();
        if (iRow >= 0 && iRow < this.fNRows && iRowS >= 0 && iRowS < this.fNRows && mInpS.getNRows() == this.fNRows) {
            result = this.fDiag[iRow] * mInpS.getElem(iRowS, iRow);
        }
        return result;
    }

    @Override
    public double computeRowDotProductS(int iRow, double[] vInpS, int iRowS) {
        double result = MissingValue.getMissing();
        if (iRow >= 0 && iRow < this.fNRows && iRowS >= 0 && iRowS < this.fNRows && this.fNRows * (this.fNRows + 1) / 2 == vInpS.length) {
            result = this.fDiag[iRow] * vInpS[this.VecIndex(iRowS, iRow)];
        }
        return result;
    }

    @Override
    public boolean computeSV(int[] vInds, double[] vVals, double[] outVec) {
        return false;
    }

    @Override
    public double computeVSV(double[] inpVec) {
        return 0.0;
    }

    @Override
    public double computeVSV(DenseRectMatrix matR, int iRow) {
        return 0.0;
    }

    @Override
    public double computeVSV(int[] vInds, double[] vVals) {
        return 0.0;
    }

    @Override
    public double computeVSW(double[] vecV, double[] vecW) {
        return 0.0;
    }

    @Override
    public double computeVSW(double[] vecV, int incV, double[] vecW, int incW) {
        return 0.0;
    }

    @Override
    public double computeVSW(double[] matS, int nRows, int iRowV, int iRowW) {
        return 0.0;
    }

    @Override
    public DenseSymMatrix extractFirstNRows() {
        return null;
    }

    @Override
    public double[] getDiagonal() {
        return this.fDiag;
    }

    public double getElem(int row) {
        return this.fDiag[row];
    }

    @Override
    public double getElem(int row, int col) {
        return row == col ? this.fDiag[row] : 0.0;
    }

    @Override
    public double[] getMatrix() {
        return this.fDiag;
    }

    @Override
    public boolean getNCheckDiagonal(double[] diag, double tol) {
        return false;
    }

    @Override
    public int getNRows() {
        return this.fNRows;
    }

    @Override
    public boolean getRegCoeffs(double[] coeffs, CCBitSet swept) {
        return false;
    }

    @Override
    public boolean getRow(int iRow, double[] vRow) {
        boolean result = false;
        if (iRow >= 0 && iRow < this.fNRows) {
            if (vRow.length != this.fNRows) {
                vRow = new double[this.fNRows];
            }
            Arrays.fill(vRow, 0.0);
            vRow[iRow] = this.fDiag[iRow];
            result = true;
        }
        return result;
    }

    @Override
    public boolean incrVecByRow(int iRow, double[] vec, int iPos, int nUpd, double coeff, boolean chkPar) {
        return false;
    }

    @Override
    public int lTChol(double[] diag, double tol, boolean chkArg) {
        return 0;
    }

    @Override
    public int lTChol(double[] diag, double tol, CCBitSet nonRed, boolean chkArg) {
        return 0;
    }

    @Override
    public int lTChol(double tol, double diagTol, double[] minDg, boolean chkArg) {
        return 0;
    }

    @Override
    public int lTDetInverse(double[] det, int job) {
        return 0;
    }

    @Override
    public boolean lTInverse() {
        return false;
    }

    @Override
    public void lTLTransL() {
    }

    @Override
    public int lTSubstitute(double[] vRHS, double[] vSol) {
        return 0;
    }

    @Override
    public void multiplyByNumber(double coeff) {
    }

    @Override
    public boolean resize(int nRows) {
        this.fNRows = nRows >= 0 ? nRows : 0;
        this.fDiag = new double[this.fNRows];
        return true;
    }

    @Override
    public void setElem(int row, int col, double val) {
        if (row == col) {
            this.fDiag[row] = val;
        }
    }

    public void setElem(int iRow, double val) {
        this.fDiag[iRow] = val;
    }

    @Override
    public boolean setNRows(int nRows) {
        boolean result = this.resize(nRows);
        return result;
    }

    @Override
    public boolean sweep(int p, double tol, double[] vOrigDiag, CCBitSet swept, boolean bCheckArg) {
        return false;
    }

    @Override
    public boolean updateXX(double[] oCase, double weight) {
        return false;
    }

    @Override
    public boolean zeroOut(int iRow) {
        return false;
    }

    @Override
    public boolean zeroOutRedundant(CCBitSet inModel) {
        return false;
    }

    @Override
    public void zeroOutNonDiag(double tol) {
    }

    private int VecIndex(int iRow, int iCol) {
        return iRow >= iCol ? iRow * (iRow + 1) / 2 + iCol : iCol * (iCol + 1) / 2 + iRow;
    }

    @Override
    public int getNCols() {
        return this.fNRows;
    }
}

