/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.matrix.BaseMatrix;
import com.spss.math.matrix.DenseSymMatrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SymBlockMatrix
implements BaseMatrix {
    private int nBlockRows = -1;
    private int nRowsInBlock = -1;
    private DenseSymMatrix[] vSymMatrices = null;

    public SymBlockMatrix() {
    }

    public SymBlockMatrix(int nBlockRows, int nRowsInBlock) {
        this.nBlockRows = nBlockRows;
        this.nRowsInBlock = nRowsInBlock;
        this.setNRows(nBlockRows, nRowsInBlock);
    }

    public void clear() {
        for (int i = 0; i < this.vSymMatrices.length; ++i) {
            this.vSymMatrices[i].clear();
        }
    }

    public int copyToSymMatrix(DenseSymMatrix sym) {
        int result = this.nBlockRows * this.nRowsInBlock;
        if (sym.getNRows() != result && !sym.setNRows(result)) {
            result = -1;
        }
        if (result >= 0) {
            if (this.nBlockRows == 1) {
                DenseSymMatrix block0 = this.vSymMatrices[0];
                double[] oldEntries = block0.getMatrix();
                double[] dest = sym.getMatrix();
                System.arraycopy(oldEntries, 0, dest, 0, oldEntries.length);
            } else {
                for (int iRowSS = 0; iRowSS < this.nBlockRows; ++iRowSS) {
                    for (int iColSS = 0; iColSS <= iRowSS; ++iColSS) {
                        int iMatSS = this.VecIndex(iRowSS, iColSS);
                        DenseSymMatrix theBlock = this.vSymMatrices[iMatSS];
                        for (int iRowSM = 0; iRowSM < this.nRowsInBlock; ++iRowSM) {
                            int maxColSM = this.nRowsInBlock;
                            if (iColSS == iRowSS) {
                                maxColSM = iRowSM + 1;
                            }
                            for (int iColSM = 0; iColSM < maxColSM; ++iColSM) {
                                double value = theBlock.getElem(iRowSM, iColSM);
                                int iRow = iRowSS * this.nRowsInBlock + iRowSM;
                                int iCol = iColSS * this.nRowsInBlock + iColSM;
                                sym.setElem(iRow, iCol, value);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public double getElem(int row, int col) {
        double result = 0.0;
        int blockRow = row / this.nRowsInBlock;
        int blockCol = col / this.nRowsInBlock;
        int rowInBlock = row % this.nRowsInBlock;
        int colInBlock = col % this.nRowsInBlock;
        result = this.vSymMatrices[this.VecIndex(blockRow, blockCol)].getElem(rowInBlock, colInBlock);
        return result;
    }

    public DenseSymMatrix getElemSSRef(int iRowSS, int iColSS) {
        return this.vSymMatrices[this.VecIndex(iRowSS, iColSS)];
    }

    public int getNBlockRows() {
        return this.nBlockRows;
    }

    @Override
    public int getNCols() {
        return this.nBlockRows * this.nRowsInBlock;
    }

    @Override
    public int getNRows() {
        return this.nBlockRows * this.nRowsInBlock;
    }

    public int getNRowsInBlock() {
        return this.nRowsInBlock;
    }

    @Override
    public void setElem(int row, int col, double val) {
        int blockRow = row / this.nRowsInBlock;
        int blockCol = col / this.nRowsInBlock;
        int rowInBlock = row % this.nRowsInBlock;
        int colInBlock = col % this.nRowsInBlock;
        this.vSymMatrices[this.VecIndex(blockRow, blockCol)].setElem(rowInBlock, colInBlock, val);
    }

    public boolean setNRows(int nRowsSB, int nRowsSM) {
        if (nRowsSB >= 0) {
            this.nBlockRows = nRowsSB;
        } else {
            this.nBlockRows = 0;
            nRowsSB = 0;
        }
        if (nRowsSM >= 0) {
            this.nRowsInBlock = nRowsSM;
        } else {
            this.nRowsInBlock = 0;
            nRowsSM = 0;
        }
        int nElemsSB = nRowsSB * (nRowsSB + 1) / 2;
        boolean result = true;
        try {
            this.vSymMatrices = new DenseSymMatrix[nElemsSB];
            for (int i = 0; i < nElemsSB; ++i) {
                this.vSymMatrices[i] = new DenseSymMatrix();
            }
        }
        catch (OutOfMemoryError e) {
            this.vSymMatrices = null;
            this.nBlockRows = -1;
            this.nRowsInBlock = -1;
            result = false;
        }
        if (result) {
            for (int iElemSB = 0; iElemSB < nElemsSB; ++iElemSB) {
                if (this.vSymMatrices[iElemSB].setNRows(nRowsSM)) continue;
                this.vSymMatrices = null;
                this.nBlockRows = -1;
                this.nRowsInBlock = -1;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isValid() {
        return this.nBlockRows >= 0 && this.nRowsInBlock >= 0;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nBlockRows);
        dataOutput.writeInt(this.nRowsInBlock);
        if (this.vSymMatrices != null) {
            dataOutput.writeInt(this.vSymMatrices.length);
            for (int i = 0; i < this.vSymMatrices.length; ++i) {
                this.vSymMatrices[i].writeObject(dataOutput);
            }
        } else {
            dataOutput.writeInt(0);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nBlockRows = dataInput.readInt();
        this.nRowsInBlock = dataInput.readInt();
        int matLen = dataInput.readInt();
        if (matLen > 0) {
            this.vSymMatrices = new DenseSymMatrix[matLen];
            for (int i = 0; i < matLen; ++i) {
                this.vSymMatrices[i] = new DenseSymMatrix();
                this.vSymMatrices[i].readObject(dataInput);
            }
        }
        return this;
    }

    private int VecIndex(int iRow, int iCol) {
        return iRow >= iCol ? iRow * (iRow + 1) / 2 + iCol : iCol * (iCol + 1) / 2 + iRow;
    }
}

