/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.random;

public class MCRandomTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final long MATRIX_A = MCRandomTwister.getUnsignedLong(-1727483681L);
    private static final long UPPER_MASK = MCRandomTwister.getUnsignedLong(Integer.MIN_VALUE);
    private static final long LOWER_MASK = MCRandomTwister.getUnsignedLong(Integer.MAX_VALUE);
    private static final long MULTIPLIER_1 = MCRandomTwister.getUnsignedLong(1812433253L);
    private static final long MULTIPLIER_2 = MCRandomTwister.getUnsignedLong(1664525L);
    private static final long MULTIPLIER_3 = MCRandomTwister.getUnsignedLong(1566083941L);
    private static final long MAGIC_SEED = MCRandomTwister.getUnsignedLong(19650218L);
    private static final long MASK_1 = MCRandomTwister.getUnsignedLong(-1658038656L);
    private static final long MASK_2 = MCRandomTwister.getUnsignedLong(-272236544L);
    private static final long DEFAULT_SEED = MCRandomTwister.getUnsignedLong(5489L);
    private long[] mt;
    private int mti = 625;

    public MCRandomTwister(double seed) {
        this.setSeed(seed);
    }

    private void setSeed(double x) {
        if (0.0 <= x && x <= 2.147483647E9 && x == (double)((int)x)) {
            this.init_genrand((int)x);
        } else {
            int a = x == 0.0 ? 1 : 0;
            int b = x < 0.0 ? 1 : 0;
            double z = b == 1 ? -x : x;
            int c = z >= 1.0 ? 1 : 0;
            double mult = c == 1 ? 0.5 : 2.0;
            int d = 0;
            if (a == 0) {
                while (!(0.5 <= z) || !(z < 1.0)) {
                    z *= mult;
                    ++d;
                }
            }
            int[] seed = new int[3];
            seed[0] = a + 2 * (b + 2 * (c + 2 * d));
            seed[1] = (int)(z *= (double)MCRandomTwister.getUnsignedLong(0x4000000L));
            z -= (double)seed[1];
            seed[2] = (int)(z *= (double)MCRandomTwister.getUnsignedLong(0x8000000L));
            assert ((z -= (double)seed[2]) == 0.0);
            this.init_by_array(seed);
        }
    }

    public synchronized double getRealClosed() {
        return (double)this.genrand_int() / 4.294967295E9;
    }

    private void init_genrand(long s) {
        if (this.mt == null) {
            this.mt = new long[624];
        }
        this.mt[0] = MCRandomTwister.getUnsignedLong(s & MCRandomTwister.getUnsignedLong(-1L));
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = MCRandomTwister.getUnsignedLong(MULTIPLIER_1 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + (long)this.mti);
            ++this.mti;
        }
    }

    private void init_by_array(int[] init_key) {
        int k;
        this.init_genrand(MAGIC_SEED);
        int i = 1;
        int j = 0;
        int n = k = 624 > init_key.length ? 624 : init_key.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * MULTIPLIER_2) + (long)init_key[j] + (long)j;
            ++j;
            if (++i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= init_key.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * MULTIPLIER_3) - (long)i;
            if (++i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = MCRandomTwister.getUnsignedLong(Integer.MIN_VALUE);
    }

    private long genrand_int() {
        long y = 0L;
        if (this.mt == null) {
            this.init_genrand(DEFAULT_SEED);
        }
        if (this.mti >= 624) {
            int kk;
            long[] mag01 = new long[]{MCRandomTwister.getUnsignedLong(0L), MATRIX_A};
            for (kk = 0; kk < 227; ++kk) {
                y = MCRandomTwister.getUnsignedLong(this.mt[kk] & UPPER_MASK | this.mt[kk + 1] & LOWER_MASK);
                this.mt[kk] = MCRandomTwister.getUnsignedLong(this.mt[kk + 397] ^ y >>> 1 ^ mag01[(int)(y & MCRandomTwister.getUnsignedLong(1L))]);
            }
            while (kk < 623) {
                y = MCRandomTwister.getUnsignedLong(this.mt[kk] & UPPER_MASK | this.mt[kk + 1] & LOWER_MASK);
                this.mt[kk] = MCRandomTwister.getUnsignedLong(this.mt[kk + -227] ^ y >>> 1 ^ mag01[(int)(y & MCRandomTwister.getUnsignedLong(1L))]);
                ++kk;
            }
            y = MCRandomTwister.getUnsignedLong(this.mt[623] & UPPER_MASK | this.mt[0] & LOWER_MASK);
            this.mt[623] = MCRandomTwister.getUnsignedLong(this.mt[396] ^ y >>> 1 ^ mag01[(int)(y & MCRandomTwister.getUnsignedLong(1L))]);
            this.mti = 0;
        }
        y = MCRandomTwister.getUnsignedLong(this.mt[this.mti++]);
        y ^= MCRandomTwister.getUnsignedLong(y >>> 11);
        y ^= MCRandomTwister.getUnsignedLong(y << 7 & MASK_1);
        y ^= MCRandomTwister.getUnsignedLong(y << 15 & MASK_2);
        y ^= MCRandomTwister.getUnsignedLong(y >>> 18);
        return y;
    }

    private static long getUnsignedLong(long data) {
        return 0xFFFFFFFFL & data;
    }
}

