/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import com.spss.math.MissingValue;
import com.spss.math.statistics.Power;

public class DistributionFunctions {
    private static final int NCPAR_COEF = 8;
    private static final int NCPAR_MAX_K = 10000;
    private static final double[] DNLGAM_A = new double[]{9.967270908702825E-5, -1.9831672170162227E-4, -0.0011708531534962581, 0.007220128109483195, -0.00962213009367803, -0.04219772092994235, 0.1665386106524361, -0.04200263501129018, -0.6558780715206193, 0.5772156649015352, 1.0, 4.67209725901142E-5, -6.812300803992063E-5, -0.0013253115907661008, 0.007335211781072028, -0.00968095666383936, -0.042176428118735405, 0.16653313644244427, -0.04200165481709275, -0.6558781879278274, 0.5772156731520919, 0.9999999997356523};
    private static final double[] DNLGAM_B = new double[]{-4.587497028E-11, 1.902363396E-10, 8.6377323367E-10, 1.15513678861E-8, -2.556403058605E-8, -1.5236723372486E-7, -3.1680510638574E-6, 1.22903704923381E-6, 2.334372474572637E-5, 0.0011154403808879769, 0.00344717051723469, 0.031982870451487885, -0.327053336529554, 0.4012044244095393, -5.184290387E-11, -8.3355121068E-10, -2.56167239813E-9, 1.455875381397E-8, 1.3512178394703E-7, 2.9898826810905E-7, -3.58107254612779E-6, -2.445260816156224E-5, -4.417127762011821E-5, 0.0011285945518941657, 0.008046944543467282, 0.049197757471266916, -0.24818372840948855, 0.11071780856646862, 3.0279161576E-10, 1.60742167357E-9, -4.05596009522E-9, -5.089259920266E-8, -2.029496209743E-8, 1.35130272477793E-6, 3.91430041115376E-6, -2.871505678061895E-5, -2.3052137536922035E-4, 4.5534656385400746E-4, 0.0115344458559304, 0.07924014651650477, -0.12152192626936503, -0.07916438300260539, -5.091914958E-10, -1.15274986907E-9, 1.237873512188E-8, 2.937383549209E-8, -3.0621450667958E-7, -7.7409414949954E-7, 8.16753874325579E-6, 2.412433382517375E-5, -2.60612176060637E-4, -9.100008765865923E-4, 0.010680938505983808, 0.11395654404408483, 0.07209569059984075, -0.10971041451764267, 4.0119897187E-10, -1.3224526679E-10, -1.002723190355E-8, 2.569249716518E-8, 2.0336011868466E-7, -1.1809768272606E-6, -3.00660303810663E-6, 4.402212897757763E-5, -1.462405876235375E-5, -0.0016487379559600127, 0.005139275208664437, 0.13843580753590579, 0.3273019097825406, 0.08588339725978625, -1.5413428348E-10, 6.4905779353E-10, 1.60702811151E-9, -2.655645793815E-8, 7.619544277956E-8, 4.7604380765353E-7, -4.90748870866195E-6, 8.21513040821212E-6, 1.4804944070262948E-4, -0.0012215225576216323, -8.742528920549853E-4, 0.14438703699657968, 0.6131588973359554, 0.5551370815997648, 1.049740243E-11, -2.5832017855E-10, 1.39591845075E-9, -2.1177278325E-10, -5.082950464905E-8, 3.7801785193343E-7, -7.3982266659145E-7, -1.088918441519888E-5, 1.2491810452478904E-4, -4.91717907051399E-4, -0.004257070894482665, 0.13595080378472757, 0.8951835600314951, 1.3107391253519625};
    private static final double[] DNLGAM_C = new double[]{1.16333640008E-8, -8.33156123568E-8, 3.832869977018E-7, -1.5814047847688E-6, 6.50106723241E-6, -2.74514060128677E-5, 1.209015360925566E-4, -5.666333178228163E-4, 0.0029294103665559734, -0.018034008606918582, 0.16517887805011663, 1.103156640645243, 1.2009736023470743, 1.3842760642E-9, -6.9417501176E-9, 3.42976459827E-8, -1.785317236779E-7, 9.525947257118E-7, -5.2483007560905E-6, 3.02364659535708E-5, -1.858396115473822E-4, 0.0012634378559425383, -0.010259470220195433, 0.12436255151950502, 1.3888709263595291, 2.4537365708424423, 1.298977078E-10, -8.02957489E-10, 4.945484615E-9, -3.17563534834E-8, 2.092136698089E-7, -1.4252023958462E-6, 1.01652510114008E-5, -7.74550502862323E-5, 6.537746948291077E-4, -0.006601491253552183, 0.09967119349481382, 1.6110931485817512, 3.9578139676187165, 1.83995642E-11, -1.353537034E-10, 9.984676809E-10, -7.6346363974E-9, 5.99311464148E-8, -4.868554120177E-7, 4.1441957716669E-6, -3.77160856623282E-5, 3.805693126824884E-4, -0.0045979851178130195, 0.08314226787497912, 1.792911330399933, 5.662562059857142, 3.4858778E-12, -2.97587783E-11, 2.557677575E-10, -2.2705728282E-9, 2.0702499245E-8, -1.954426390917E-7, 1.9343161886722E-6, -2.0479024910257E-5, 2.405181940241215E-4, -0.00338420875610748, 0.0713079483483519, 1.9467574842460869, 7.534364236758733};
    private static final double[] DNLGAM_D = new double[]{-0.0016331235920050082, 8.364453370338596E-4, -5.951894757572819E-4, 7.936505750541542E-4, -0.0027777777773546303, 0.08333333333333309, 0.9189385332046728};
    private static final double[] DERF_A = new double[]{5.958930743E-11, -1.13739022964E-9, 1.466005199839E-8, -1.635035446196E-7, 1.6461004480962E-6, -1.492559551950604E-5, 1.2055331122299264E-4, -8.548326981129666E-4, 0.005223977624823223, -0.026866170645077334, 0.11283791670954882, -0.3761263890318375, 1.1283791670955126, 2.372510631E-11, -4.5493253732E-10, 5.90362766598E-9, -6.642090827576E-8, 6.7595634268133E-7, -6.21188515924E-6, 5.10388300970969E-5, -3.7015410692956176E-4, 0.00233307631218881, -0.012549884771821921, 0.05657061146827042, -0.21379664776456006, 0.8427007929497149, 9.49905026E-12, -1.8310229805E-10, 2.39463074E-9, -2.721444369609E-8, 2.8045522331686E-7, -2.61830022482897E-6, 2.195455056768781E-5, -1.6358986921372656E-4, 0.0010705215356411031, -0.006082847181135901, 0.029869784652462584, -0.13055593046562267, 0.674933236039655, 3.82722073E-12, -7.421598602E-11, 9.793057408E-10, -1.126008898854E-8, 1.1775134830784E-7, -1.1199275838265E-6, 9.62023443095201E-6, -7.404402135070773E-5, 5.068999365414488E-4, -0.003075530514392729, 0.016689778925531657, -0.08548534594781312, 0.5690907664239364, 1.55296588E-12, -3.032205868E-11, 4.0424830707E-10, -4.71135111493E-9, 5.011915876293E-8, -4.8722516178974E-7, 4.30683284629395E-6, -3.445026145385764E-5, 2.4879276133931664E-4, -0.0016294094174807928, 0.009887863739323505, -0.05962426839442304, 0.49766113250947636};
    private static final double[] DERF_B = new double[]{-2.9734388465E-10, 2.69776334046E-9, -6.40788827665E-9, -1.6678201321E-8, -2.1854388148686E-7, 2.66246030457984E-6, 1.612722157047886E-5, -2.5616361025506627E-4, 1.5380842432375364E-4, 0.00815533022524928, -0.014022836638963193, -0.19746892495383023, 0.7151172032884284, -1.951073787E-11, -3.2302692214E-10, 5.22461866919E-9, 3.42940918551E-9, -3.5772874310272E-7, 1.9999935792654E-7, 2.687044575042908E-5, -1.1843240273775776E-4, -8.099172895603227E-4, 0.006610629705022412, 0.009095309223548273, -0.20160072778491014, 0.5116969671872764, 3.147682272E-11, -4.8465972408E-10, 6.3675740242E-10, 3.377623323271E-8, -1.5451139637086E-7, -2.03340624738438E-6, 1.947204525295057E-5, 2.854147231653228E-5, -0.0010156506315220028, 0.0027118700352009566, 0.023280950354228107, -0.16725021123116876, 0.32490054966649434, 2.31936337E-11, -6.303206648E-11, -2.64888267434E-9, 2.050708040581E-8, 1.1371857327578E-7, -2.11211337219663E-6, 3.68797328322935E-6, 9.823686253424796E-5, -6.586024399045536E-4, -7.528581489523087E-4, 0.025854344242029606, -0.11637092784486193, 0.1826733677529661, -3.67789363E-12, 2.0876046746E-10, -1.93319027226E-9, -4.35953392472E-9, 1.8006992266137E-7, -7.8441223763969E-7, -6.75407647949153E-6, 8.428418334440096E-5, -1.7604388937031816E-4, -0.002397296114350716, 0.02064129023876023, -0.06905562880005864, 0.09084526782065479};
    private static final double DERFC_P0 = 0.2753747415973768;
    private static final double DERFC_P1 = 0.49016508058531844;
    private static final double DERFC_P2 = 0.7743681991195386;
    private static final double DERFC_P3 = 1.0792551515585667;
    private static final double DERFC_P4 = 1.313146538310231;
    private static final double DERFC_P5 = 1.3704021768233816;
    private static final double DERFC_P6 = 1.1890298290927332;
    private static final double DERFC_P7 = 0.8052764087529106;
    private static final double DERFC_P8 = 0.35752427444953105;
    private static final double DERFC_P9 = 0.016620792496936737;
    private static final double DERFC_P10 = -0.11946395996432542;
    private static final double DERFC_P11 = -0.0838864557023002;
    private static final double DERFC_P12 = 0.002493672000535033;
    private static final double DERFC_P13 = 0.039097684558848406;
    private static final double DERFC_P14 = 0.016131532973325226;
    private static final double DERFC_P15 = -0.013382364453346007;
    private static final double DERFC_P16 = -0.012722381378212275;
    private static final double DERFC_P17 = 0.003833351262648873;
    private static final double DERFC_P18 = 0.007736725283135267;
    private static final double DERFC_P19 = -8.707796353172959E-4;
    private static final double DERFC_P20 = -0.003963850973605135;
    private static final double DERFC_P21 = 1.1931402283834095E-4;
    private static final double DERFC_P22 = 0.0012710976495261409;
    private static final float IDFCHI_C1 = 0.01f;
    private static final float IDFCHI_C2 = 0.222222f;
    private static final float IDFCHI_C3 = 0.32f;
    private static final float IDFCHI_C4 = 0.4f;
    private static final float IDFCHI_C5 = 1.24f;
    private static final float IDFCHI_C6 = 2.2f;
    private static final float IDFCHI_C7 = 4.67f;
    private static final float IDFCHI_C8 = 6.66f;
    private static final float IDFCHI_C9 = 6.73f;
    private static final float IDFCHI_C10 = 13.32f;
    private static final float IDFCHI_C11 = 60.0f;
    private static final float IDFCHI_C12 = 70.0f;
    private static final float IDFCHI_C13 = 84.0f;
    private static final float IDFCHI_C14 = 105.0f;
    private static final float IDFCHI_C15 = 120.0f;
    private static final float IDFCHI_C16 = 127.0f;
    private static final float IDFCHI_C17 = 140.0f;
    private static final float IDFCHI_C18 = 1175.0f;
    private static final float IDFCHI_C19 = 210.0f;
    private static final float IDFCHI_C20 = 252.0f;
    private static final float IDFCHI_C21 = 2264.0f;
    private static final float IDFCHI_C22 = 294.0f;
    private static final float IDFCHI_C23 = 346.0f;
    private static final float IDFCHI_C24 = 420.0f;
    private static final float IDFCHI_C25 = 462.0f;
    private static final float IDFCHI_C26 = 606.0f;
    private static final float IDFCHI_C27 = 672.0f;
    private static final float IDFCHI_C28 = 707.0f;
    private static final float IDFCHI_C29 = 735.0f;
    private static final float IDFCHI_C30 = 889.0f;
    private static final float IDFCHI_C31 = 932.0f;
    private static final float IDFCHI_C32 = 966.0f;
    private static final float IDFCHI_C33 = 1141.0f;
    private static final float IDFCHI_C34 = 1182.0f;
    private static final float IDFCHI_C35 = 1278.0f;
    private static final float IDFCHI_C36 = 1740.0f;
    private static final float IDFCHI_C37 = 2520.0f;
    private static final float IDFCHI_C38 = 5040.0f;
    private static final double IDFCHI_EXPUPP = 141.956;
    private static final double IDFCHI_EPS = 5.0E-7;
    private static final int IDFCHI_MAXIT = 20;
    private static final double PROBIT_A0 = 3.3871328727963665;
    private static final double PROBIT_A1 = 133.14166789178438;
    private static final double PROBIT_A2 = 1971.5909503065513;
    private static final double PROBIT_A3 = 13731.69376550946;
    private static final double PROBIT_A4 = 45921.95393154987;
    private static final double PROBIT_A5 = 67265.7709270087;
    private static final double PROBIT_A6 = 33430.57558358813;
    private static final double PROBIT_A7 = 2509.0809287301227;
    private static final double PROBIT_B1 = 42.31333070160091;
    private static final double PROBIT_B2 = 687.1870074920579;
    private static final double PROBIT_B3 = 5394.196021424751;
    private static final double PROBIT_B4 = 21213.794301586597;
    private static final double PROBIT_B5 = 39307.89580009271;
    private static final double PROBIT_B6 = 28729.085735721943;
    private static final double PROBIT_B7 = 5226.495278852854;
    private static final double PROBIT_C0 = 1.4234371107496835;
    private static final double PROBIT_C1 = 4.630337846156546;
    private static final double PROBIT_C2 = 5.769497221460691;
    private static final double PROBIT_C3 = 3.6478483247632045;
    private static final double PROBIT_C4 = 1.2704582524523684;
    private static final double PROBIT_C5 = 0.2417807251774506;
    private static final double PROBIT_C6 = 0.022723844989269184;
    private static final double PROBIT_C7 = 7.745450142783414E-4;
    private static final double PROBIT_D1 = 2.053191626637759;
    private static final double PROBIT_D2 = 1.6763848301838038;
    private static final double PROBIT_D3 = 0.6897673349851;
    private static final double PROBIT_D4 = 0.14810397642748008;
    private static final double PROBIT_D5 = 0.015198666563616457;
    private static final double PROBIT_D6 = 5.475938084995345E-4;
    private static final double PROBIT_D7 = 1.0507500716444169E-9;
    private static final double PROBIT_E0 = 6.657904643501103;
    private static final double PROBIT_E1 = 5.463784911164114;
    private static final double PROBIT_E2 = 1.7848265399172913;
    private static final double PROBIT_E3 = 0.29656057182850487;
    private static final double PROBIT_E4 = 0.026532189526576124;
    private static final double PROBIT_E5 = 0.0012426609473880784;
    private static final double PROBIT_E6 = 2.7115555687434876E-5;
    private static final double PROBIT_E7 = 2.0103343992922881E-7;
    private static final double PROBIT_F1 = 0.599832206555888;
    private static final double PROBIT_F2 = 0.1369298809227358;
    private static final double PROBIT_F3 = 0.014875361290850615;
    private static final double PROBIT_F4 = 7.868691311456133E-4;
    private static final double PROBIT_F5 = 1.8463183175100548E-5;
    private static final double PROBIT_F6 = 1.421511758316446E-7;
    private static final double PROBIT_F7 = 2.0442631033899397E-15;
    private static final double PROBIT_CONST1 = 0.180625;
    private static final double PROBIT_CONST2 = 1.6;
    private static final double PROBIT_SPL1 = 0.425;
    private static final double PROBIT_SPL2 = 5.0;
    private static final double LN2 = 0.6931471805599453;
    private static final double MAX_SQRT = Math.sqrt(Double.MAX_VALUE);
    private static final double GAMMAD_MAX_SQRT = Math.sqrt(Double.MAX_VALUE);
    private static final double GAMMAD_TOL = 1.0E-14;
    private static final double DINTMAX = 2.147483647E9;
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final double BETINV_BMIN = 1.0E-20;
    private static final double BETINV_EPSZ = 1.0E-20;
    private static final double BETINV_MAXITR = 50.0;
    private static final double BETINV_XIHIGH = 0.9999999;
    private static final double BETINV_XILOW = 1.0E-8;

    private DistributionFunctions() {
    }

    static double cdfBeta(double funArg, double a, double b) {
        return DistributionFunctions.cdfbet(funArg, a, b);
    }

    public static double cdfChi(double x, double df) {
        double result = MissingValue.getMissing();
        if (df > 0.0) {
            result = x <= 0.0 ? 0.0 : DistributionFunctions.gammad(x / 2.0, df / 2.0, true);
        }
        return result;
    }

    public static double cdfF(double funArg, double df1, double df2) {
        return DistributionFunctions.spsscdff(funArg, df1, df2);
    }

    public static double cdfT(double funArg, double df) {
        return DistributionFunctions.spsscdft(funArg, df);
    }

    public static double cdfNorm(double x, double mean, double stddev) {
        double result = MissingValue.getMissing();
        if (stddev > 0.0) {
            result = DistributionFunctions.prbnrm((x - mean) / stddev);
        }
        return result;
    }

    public static double cdfStdNorm(double x) {
        return DistributionFunctions.prbnrm(x);
    }

    public static double cdfLaplace(double x, double a, double b) {
        double exparg;
        double result = MissingValue.getMissing();
        if (b <= 0.0) {
            return result;
        }
        result = x == a ? 0.5 : (x < a ? ((exparg = (x - a) / b) < -744.44 ? 0.0 : 0.5 * Math.exp(exparg)) : ((exparg = (a - x) / b) < -744.44 ? 1.0 : 1.0 - 0.5 * Math.exp(exparg)));
        return result;
    }

    public static double idfChi(double funArg, double df) {
        return DistributionFunctions.spssidfchi(funArg, df);
    }

    public static double idfF(double funArg, double df1, double df2) {
        return DistributionFunctions.spssidff(funArg, df1, df2);
    }

    public static double idfNorm(double p, double mean, double stddev) {
        double result = MissingValue.getMissing();
        if (p > 0.0 && p < 1.0 && stddev > 0.0) {
            if (p == 0.5) {
                result = mean;
            } else {
                result = DistributionFunctions.probit(p);
                if (!MissingValue.isMissing(result)) {
                    result = result * stddev + mean;
                }
            }
        }
        return result;
    }

    public static double idfStdNorm(double p) {
        double result = MissingValue.getMissing();
        if (p > 0.0 && p < 1.0) {
            result = p == 0.5 ? 0.0 : DistributionFunctions.probit(p);
        }
        return result;
    }

    public static double idfT(double funArg, double df) {
        return DistributionFunctions.spssidft(funArg, df);
    }

    public static double nonCentralCdfChi(double funArg, double df, double ncPar) {
        double adiff;
        double acorr;
        double chicur;
        double result = MissingValue.getMissing();
        if (df <= 0.0 || ncPar < 0.0) {
            return result;
        }
        if (funArg <= 0.0) {
            result = 0.0;
            return result;
        }
        double xhalf = funArg * 0.5;
        double ahalf = df * 0.5;
        if (funArg == 0.0) {
            result = DistributionFunctions.gammad(xhalf, ahalf, true);
            return result;
        }
        double errmax = 1.0E-12;
        double tbound = 7.0344838253011;
        int itrmax = 60000;
        double chalf = ncPar * 0.5;
        double arg1 = chalf - 7.0344838253011 * Math.sqrt(chalf);
        if (arg1 < 0.0) {
            arg1 = 0.0;
        }
        if (MissingValue.isMissing(chicur = DistributionFunctions.gammad(xhalf, acorr = ahalf + (adiff = Math.floor(arg1)), true))) {
            result = chicur;
            return result;
        }
        double chinxt = 0.0;
        double chiinc = 0.0;
        if (chicur == 0.0) {
            result = 0.0;
            return result;
        }
        double exparg = acorr * Math.log(xhalf) - DistributionFunctions.dnlgam(acorr + 1.0) - xhalf;
        if (exparg > 709.78) {
            result = MissingValue.getMissing();
            return result;
        }
        chiinc = exparg < -744.44 ? 0.0 : Math.exp(exparg);
        chinxt = chicur - chiinc;
        exparg = -chalf;
        double psnpbt = 0.0;
        if (adiff > 0.0) {
            exparg += adiff * Math.log(chalf) - DistributionFunctions.dnlgam(adiff + 1.0);
        }
        if (exparg > 709.78) {
            result = MissingValue.getMissing();
            return result;
        }
        if (exparg < -744.44) {
            result = 0.0;
            return result;
        }
        psnpbt = Math.exp(exparg);
        double pstail = 1.0 - psnpbt;
        result = psnpbt * chicur;
        double icorr = adiff;
        int itrcur = 0;
        double errcur = 1.0;
        while (itrcur < 60000 && errcur > 1.0E-12) {
            ++itrcur;
            chicur = chinxt;
            chinxt = chicur - (chiinc *= xhalf / (ahalf + (icorr += 1.0)));
            result += psnpbt * chicur;
            errcur = chinxt * (pstail -= (psnpbt *= chalf / icorr));
        }
        if (errcur > 1.0E-12) {
            result = MissingValue.getMissing();
            return result;
        }
        if (result > 1.0) {
            result = 1.0;
        } else if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public static double nonCentralCdfF(double funArg, double df1, double df2, double ncPar) {
        return DistributionFunctions.nonCentralCdfF(funArg, df1, df2, ncPar, 1.0E-12);
    }

    public static double nonCentralCdfF(double funArg, double df1, double df2, double ncPar, double tol) {
        double result = MissingValue.getMissing();
        if (df1 <= 0.0 || df2 <= 0.0 || ncPar < 0.0) {
            return result;
        }
        if (funArg <= 0.0) {
            result = 0.0;
            return result;
        }
        result = DistributionFunctions.ncdbet(df1 * funArg / (df2 + df1 * funArg), df1 * 0.5, df2 * 0.5, ncPar, tol);
        return result;
    }

    public static double nonCentralCdfT(double funArg, double df, double ncPar) {
        double coefq;
        double xcalc;
        double result = MissingValue.getMissing();
        if (df <= 0.0) {
            return result;
        }
        if (ncPar == 0.0) {
            result = DistributionFunctions.cdfT(funArg, df);
            return result;
        }
        if (funArg == 0.0) {
            result = DistributionFunctions.prbnrm(-ncPar);
            return result;
        }
        double d = xcalc = ncPar >= 0.0 ? funArg : -funArg;
        if (Math.abs(funArg) >= MAX_SQRT) {
            result = funArg >= ncPar ? 1.0 : 0.0;
            return result;
        }
        double betax = funArg * funArg;
        if ((betax /= betax + df) <= 0.0) {
            return result;
        }
        double csqr = ncPar * ncPar;
        double csqrh = csqr * 0.5;
        double errmax = 1.0E-12;
        double tbound = 7.0344838253011;
        int itrmax = 60000;
        double arg1 = csqrh - 7.0344838253011 * Math.sqrt(csqrh);
        if (arg1 < 0.0) {
            arg1 = 0.0;
        }
        double itrcor = Math.floor(arg1);
        double work1 = -0.6931471805599453 - csqrh + itrcor * Math.log(csqrh);
        double exparg = work1 - DistributionFunctions.dnlgam(itrcor + 1.0);
        double coefp = Math.exp(exparg);
        exparg = work1 - 0.34657359027997264 + Math.log(Math.abs(ncPar)) - DistributionFunctions.dnlgam(itrcor + 1.0 + 0.5);
        if (exparg < -744.44) {
            coefq = 0.0;
        } else {
            coefq = Math.exp(exparg);
            if (xcalc < 0.0) {
                coefq = -coefq;
            }
        }
        double sump = 0.5 - coefp;
        double betab = 0.5 * df;
        double betaa = 0.5 + itrcor;
        double ibetap = DistributionFunctions.cdfbet(betax, betaa, betab);
        if (MissingValue.isMissing(ibetap)) {
            result = ibetap;
            return result;
        }
        work1 = -DistributionFunctions.dnlgam(betab) + betab * Math.log(1.0 - betax);
        exparg = work1 + DistributionFunctions.dnlgam(betaa + betab) - DistributionFunctions.dnlgam(betaa + 1.0) + betaa * Math.log(betax);
        if (exparg > 709.78) {
            return result;
        }
        double ibincp = exparg < -744.44 ? 0.0 : Math.exp(exparg);
        double ibetaq = DistributionFunctions.cdfbet(betax, betaa + 0.5, betab);
        if (MissingValue.isMissing(ibetaq)) {
            result = ibetaq;
            return result;
        }
        exparg = work1 + DistributionFunctions.dnlgam(betaa + 0.5 + betab) - DistributionFunctions.dnlgam(betaa + 1.5) + (betaa + 0.5) * Math.log(betax);
        if (exparg > 709.78) {
            return result;
        }
        double ibincq = exparg < -744.44 ? 0.0 : Math.exp(exparg);
        result = coefp * ibetap + coefq * ibetaq;
        ibetap -= ibincp;
        ibetaq -= ibincq;
        double icorr = itrcor;
        double errcur = 1.0;
        int itrcur = 0;
        while (itrcur < 60000 && errcur > 1.0E-12) {
            ++itrcur;
            result += coefp * ibetap + (coefq *= csqrh / (icorr + 0.5)) * ibetaq;
            ibetaq -= (ibincq *= betax * (betaa + betab - 0.5) / (betaa + 0.5));
            errcur = 2.0 * (sump -= (coefp *= csqrh / (icorr += 1.0))) * (ibetap -= (ibincp *= betax * ((betaa += 1.0) + betab - 1.0) / betaa));
        }
        if (errcur > 1.0E-12) {
            result = MissingValue.getMissing();
            return result;
        }
        double prbout = DistributionFunctions.prbnrm(-Math.abs(ncPar));
        result = xcalc < 0.0 ? prbout - result : prbout + result;
        if (ncPar < 0.0) {
            result = 1.0 - result;
        }
        if (result > 1.0) {
            result = 1.0;
        } else if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public static double findNCParamChi(double funArg, double df, double prob, double tol) {
        double miss = MissingValue.getMissing();
        double cdf = 0.0;
        double cdfmp = 0.0;
        if (df <= 0.0 || prob < 0.0 || prob > 1.0 || tol < 0.0) {
            return miss;
        }
        cdf = DistributionFunctions.nonCentralCdfChi(funArg, df, 0.0);
        if (MissingValue.isMissing(cdf)) {
            return miss;
        }
        if (cdf <= prob) {
            return 0.0;
        }
        double x = funArg;
        cdf = DistributionFunctions.nonCentralCdfChi(funArg, df, x);
        if (MissingValue.isMissing(cdf)) {
            return miss;
        }
        cdfmp = cdf - prob;
        if (cdfmp == 0.0) {
            return x;
        }
        double x1 = 0.0;
        double cdf1 = 0.0;
        double cdfmp1 = 0.0;
        double x2 = 0.0;
        double cdf2 = 0.0;
        double cdfmp2 = 0.0;
        if (cdfmp > 0.0) {
            x1 = x;
            cdf1 = cdf;
            cdfmp1 = cdfmp;
            x2 = 2.0 * x;
            cdf2 = DistributionFunctions.nonCentralCdfChi(funArg, df, x2);
            if (MissingValue.isMissing(cdf2)) {
                return miss;
            }
            cdfmp2 = cdf2 - prob;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x1 = x2;
                cdf1 = cdf2;
                cdfmp1 = cdfmp2;
                cdf2 = DistributionFunctions.nonCentralCdfChi(funArg, df, x2 *= 2.0);
                if (MissingValue.isMissing(cdf2)) {
                    return miss;
                }
                cdfmp2 = cdf2 - prob;
            }
        } else {
            x2 = x;
            cdf2 = cdf;
            cdfmp2 = cdfmp;
            x1 = x * 0.5;
            cdf1 = DistributionFunctions.nonCentralCdfChi(funArg, df, x1);
            if (MissingValue.isMissing(cdf1)) {
                return miss;
            }
            cdfmp1 = cdf1 - prob;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x2 = x1;
                cdf2 = cdf1;
                cdfmp2 = cdfmp1;
                cdf1 = DistributionFunctions.nonCentralCdfChi(funArg, df, x1 *= 0.5);
                if (MissingValue.isMissing(cdf1)) {
                    return miss;
                }
                cdfmp1 = cdf1 - prob;
            }
        }
        if (cdfmp1 == 0.0) {
            return x1;
        }
        if (cdfmp2 == 0.0) {
            return x2;
        }
        x = (x1 + x2) * 0.5;
        boolean bLoop = true;
        double result = miss;
        while (bLoop) {
            cdf = DistributionFunctions.nonCentralCdfChi(funArg, df, x);
            if (MissingValue.isMissing(cdf)) {
                bLoop = false;
            } else {
                cdfmp = cdf - prob;
                if (Math.abs(cdfmp) <= tol && Math.abs(x2 - x1) <= tol || Power.almostEqual(x1, x2, 8.0)) {
                    result = x;
                    bLoop = false;
                }
            }
            if (!bLoop) continue;
            if (cdfmp > 0.0) {
                x1 = x;
            } else {
                x2 = x;
            }
            x = (x1 + x2) * 0.5;
        }
        return result;
    }

    public static double findNCParamChi(double funArg, double df, double prob, double tol, boolean[] solved) {
        solved[0] = false;
        double result = DistributionFunctions.findNCParamChi(funArg, df, prob, tol);
        if (!MissingValue.isMissing(result)) {
            double cdf = DistributionFunctions.nonCentralCdfChi(funArg, df, result);
            solved[0] = Math.abs(cdf - prob) <= tol;
        }
        return result;
    }

    public static double findNCParamChi(double funArg, double df, double prob) {
        return DistributionFunctions.findNCParamChi(funArg, df, prob, 1.0E-6);
    }

    public static double findNCParamT(double funArg, double df, double prob, double tol) {
        int k;
        double cdfmp2;
        double cdf2;
        double x2;
        double cdfmp1;
        double cdf1;
        double x1;
        double cdf0;
        double miss = MissingValue.getMissing();
        boolean bChangeSign = false;
        if (prob < 0.0 || prob > 1.0 || df <= 0.0 || tol < 0.0) {
            return miss;
        }
        if (funArg < 0.0) {
            funArg = -funArg;
            prob = 1.0 - prob;
            bChangeSign = true;
        }
        if (MissingValue.isMissing(cdf0 = DistributionFunctions.nonCentralCdfT(funArg, df, 0.0))) {
            return miss;
        }
        if (cdf0 == prob) {
            return 0.0;
        }
        double cdf0mp = cdf0 - prob;
        double x = funArg > 1.0 ? funArg : 1.0;
        double cdf = DistributionFunctions.nonCentralCdfT(funArg, df, x);
        if (MissingValue.isMissing(cdf)) {
            return miss;
        }
        double cdfmp = cdf - prob;
        if (cdfmp == 0.0) {
            if (bChangeSign) {
                x = -x;
            }
            return x;
        }
        if (cdf0mp > 0.0) {
            x1 = 0.0;
            cdf1 = cdf0;
            cdfmp1 = cdf1 - prob;
            x2 = x;
            cdf2 = cdf;
            cdfmp2 = cdf2 - prob;
            k = 0;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x1 = x2;
                cdf1 = cdf2;
                cdfmp1 = cdfmp2;
                x2 = k < 10000 ? (x2 += x) : (x2 *= x2);
                ++k;
                cdf2 = DistributionFunctions.nonCentralCdfT(funArg, df, x2);
                if (MissingValue.isMissing(cdf2)) {
                    return miss;
                }
                cdfmp2 = cdf2 - prob;
            }
        } else {
            x2 = 0.0;
            cdf2 = cdf0;
            cdfmp2 = cdf2 - prob;
            x1 = -x;
            cdf1 = DistributionFunctions.nonCentralCdfT(funArg, df, x1);
            if (MissingValue.isMissing(cdf1)) {
                return miss;
            }
            cdfmp1 = cdf1 - prob;
            k = 0;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x2 = x1;
                cdf2 = cdf1;
                cdfmp2 = cdfmp1;
                x1 = k < 10000 ? (x1 -= x) : -x1 * x1;
                ++k;
                cdf1 = DistributionFunctions.nonCentralCdfT(funArg, df, x1);
                if (MissingValue.isMissing(cdf1)) {
                    return miss;
                }
                cdfmp1 = cdf1 - prob;
            }
        }
        if (cdfmp1 == 0.0) {
            if (bChangeSign) {
                x1 = -x1;
            }
            return x1;
        }
        if (cdfmp2 == 0.0) {
            if (bChangeSign) {
                x2 = -x2;
            }
            return x2;
        }
        x = (x1 + x2) * 0.5;
        boolean bLoop = true;
        double result = miss;
        while (bLoop) {
            cdf = DistributionFunctions.nonCentralCdfT(funArg, df, x);
            if (MissingValue.isMissing(cdf)) {
                bLoop = false;
            } else {
                cdfmp = cdf - prob;
                if (Math.abs(cdfmp) <= tol && Math.abs(x2 - x1) <= tol || Power.almostEqual(x1, x2, 8.0)) {
                    if (bChangeSign) {
                        x = -x;
                    }
                    result = x;
                    bLoop = false;
                }
            }
            if (!bLoop) continue;
            if (cdfmp > 0.0) {
                x1 = x;
            } else {
                x2 = x;
            }
            x = (x1 + x2) * 0.5;
        }
        return result;
    }

    public static double findNCParamT(double funArg, double df, double prob, double tol, boolean[] solved) {
        solved[0] = false;
        double result = DistributionFunctions.findNCParamT(funArg, df, prob, tol);
        if (!MissingValue.isMissing(result)) {
            double cdf = DistributionFunctions.nonCentralCdfT(funArg, df, result);
            solved[0] = Math.abs(cdf - prob) <= tol;
        }
        return result;
    }

    public static double findNCParamT(double funArg, double df, double prob) {
        return DistributionFunctions.findNCParamT(funArg, df, prob, 1.0E-6);
    }

    public static double findNCParamF(double funArg, double df1, double df2, double prob, double tol) {
        double cdfmp2;
        double cdfmp1;
        double cdf2;
        double x2;
        double cdf1;
        double x1;
        double miss = MissingValue.getMissing();
        if (df1 <= 0.0 || df2 <= 0.0 || prob < 0.0 || prob > 1.0 || tol < 0.0) {
            return miss;
        }
        double cdf = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, 0.0, tol);
        if (MissingValue.isMissing(cdf)) {
            return miss;
        }
        if (cdf <= prob) {
            return 0.0;
        }
        double x = funArg * df1;
        cdf = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x, tol);
        if (MissingValue.isMissing(cdf)) {
            return miss;
        }
        double cdfmp = cdf - prob;
        if (cdfmp == 0.0) {
            return x;
        }
        if (cdfmp > 0.0) {
            x1 = x;
            cdf1 = cdf;
            x2 = 2.0 * x;
            cdf2 = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x2, tol);
            if (MissingValue.isMissing(cdf2)) {
                return miss;
            }
            cdfmp1 = cdf1 - prob;
            cdfmp2 = cdf2 - prob;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x1 = x2;
                cdf1 = cdf2;
                cdfmp1 = cdfmp2;
                cdf2 = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x2 *= 2.0, tol);
                if (MissingValue.isMissing(cdf2)) {
                    return miss;
                }
                cdfmp2 = cdf2 - prob;
            }
        } else {
            x1 = x * 0.5;
            cdf1 = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x1, tol);
            if (MissingValue.isMissing(cdf1)) {
                return miss;
            }
            x2 = x;
            cdf2 = cdf;
            cdfmp1 = cdf1 - prob;
            cdfmp2 = cdf2 - prob;
            while (cdfmp1 * cdfmp2 > 0.0) {
                x2 = x1;
                cdf2 = cdf1;
                cdfmp2 = cdfmp1;
                cdf1 = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x1 *= 0.5, tol);
                if (MissingValue.isMissing(cdf1)) {
                    return miss;
                }
                cdfmp1 = cdf1 - prob;
            }
        }
        if (cdfmp1 == 0.0) {
            return x1;
        }
        if (cdfmp2 == 0.0) {
            return x2;
        }
        x = (x1 + x2) * 0.5;
        boolean bLoop = true;
        double result = miss;
        while (bLoop) {
            cdf = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, x, tol);
            if (MissingValue.isMissing(cdf)) {
                bLoop = false;
            } else {
                cdfmp = cdf - prob;
                double xMax = Math.max(Math.abs(x1), Math.abs(x2));
                double xDen = Math.max(xMax, 1.0);
                if (Math.abs(cdfmp) <= tol && Math.abs(x1 - x2) / xDen < tol || Power.almostEqual(x1, x2, 8.0)) {
                    result = x;
                    bLoop = false;
                }
            }
            if (!bLoop) continue;
            if (cdfmp > 0.0) {
                x1 = x;
            } else {
                x2 = x;
            }
            x = (x1 + x2) * 0.5;
        }
        return result;
    }

    public static double findNCParamF(double funArg, double df1, double df2, double prob) {
        return DistributionFunctions.findNCParamF(funArg, df1, df2, prob, 1.0E-6);
    }

    public static double findNCParamF(double funArg, double df1, double df2, double prob, double tol, boolean[] solved) {
        solved[0] = false;
        double result = DistributionFunctions.findNCParamF(funArg, df1, df2, prob, tol);
        if (!MissingValue.isMissing(result)) {
            double cdf = DistributionFunctions.nonCentralCdfF(funArg, df1, df2, result, tol);
            solved[0] = Math.abs(cdf - prob) <= tol;
        }
        return result;
    }

    public static double spssdnlgam(double x) {
        return DistributionFunctions.dnlgam(x);
    }

    static double ncdbet(double x, double a, double b, double c, double tol) {
        double adiff;
        double acorr;
        double betcur;
        double result = MissingValue.getMissing();
        if (a <= 0.0 || b <= 0.0 || c < 0.0) {
            return result;
        }
        if (x <= 0.0) {
            result = 0.0;
            return result;
        }
        if (x >= 1.0) {
            result = 1.0;
            return result;
        }
        if (c == 0.0) {
            result = DistributionFunctions.cdfbet(x, a, b);
            return result;
        }
        double errmax = tol;
        double tbound = 7.0344838253011;
        double chalf = c * 0.5;
        double arg1 = chalf - 7.0344838253011 * Math.sqrt(chalf);
        if (arg1 < 0.0) {
            arg1 = 0.0;
        }
        if (MissingValue.isMissing(betcur = DistributionFunctions.cdfbet(x, acorr = a + (adiff = Math.floor(arg1)), b))) {
            result = betcur;
            return result;
        }
        double exparg = acorr * Math.log(x) + b * Math.log(1.0 - x) - DistributionFunctions.dnlgam(acorr) - DistributionFunctions.dnlgam(b) + DistributionFunctions.dnlgam(acorr + b) - Math.log(acorr);
        boolean bZero = false;
        double betinc = 0.0;
        if (exparg > 709.78) {
            bZero = true;
        } else if (exparg < -744.44) {
            betinc = 0.0;
            bZero = betcur == 0.0;
        } else {
            betinc = Math.exp(exparg);
        }
        double betnxt = 0.0;
        double psnpbt = MissingValue.getMissing();
        if (!bZero) {
            betnxt = betcur - betinc;
            exparg = -chalf;
            if (acorr > a) {
                exparg += adiff * Math.log(chalf) - DistributionFunctions.dnlgam(adiff + 1.0);
            }
            if (exparg > 709.78) {
                bZero = true;
            } else if (exparg < -744.44) {
                bZero = true;
            } else {
                psnpbt = Math.exp(exparg);
            }
        }
        if (bZero) {
            result = 0.0;
            return result;
        }
        double pstail = 1.0 - psnpbt;
        result = psnpbt * betcur;
        double icorr = adiff;
        int itrcur = 0;
        int itrmax = 60000;
        double errcur = 1.0;
        while (errcur > errmax && itrcur < 60000) {
            ++itrcur;
            betcur = betnxt;
            betnxt = betcur - (betinc *= x * (a + b + (icorr += 1.0) - 1.0) / (a + icorr));
            result += psnpbt * betcur;
            errcur = betnxt * (pstail -= (psnpbt *= chalf / icorr));
        }
        if (errcur > errmax) {
            result = MissingValue.getMissing();
            return result;
        }
        if (result > 1.0) {
            result = 1.0;
        } else if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    static double ncdbet(double x, double a, double b, double c) {
        return DistributionFunctions.ncdbet(x, a, b, c, 1.0E-12);
    }

    static double spsscdff(double x, double a, double b) {
        double result = MissingValue.getMissing();
        int retcod = 0;
        if (a > 0.0 && b > 0.0) {
            if (x <= 0.0) {
                result = 0.0;
            } else if (a == 1.0) {
                double xt = Math.sqrt(x);
                result = DistributionFunctions.spsscdft(xt, b);
                if (!MissingValue.isMissing(result)) {
                    result = 2.0 * result - 1.0;
                }
            } else if (x >= 1.0) {
                double betav = b / a;
                betav /= x + betav;
                result = 1.0 - DistributionFunctions.cdfbet(betav, 0.5 * b, 0.5 * a);
            } else {
                double betav = x / (x + b / a);
                result = DistributionFunctions.cdfbet(betav, 0.5 * a, 0.5 * b);
            }
            if (MissingValue.isMissing(result)) {
                retcod = 2;
            }
        } else {
            retcod = 1;
        }
        if (retcod > 0) {
            result = MissingValue.getMissing();
        }
        return result;
    }

    static double spsscdft(double x, double a) {
        double result;
        double biga = 1.0E8;
        if (a > 0.0) {
            if (a > 1.0E8) {
                result = DistributionFunctions.cdfNorm(x, 0.0, 1.0);
            } else if (x != 0.0) {
                if (a != 1.0) {
                    double absx = Math.abs(x);
                    if (absx > 1.0) {
                        double betav = a / absx;
                        if (!MissingValue.isMissing(result = DistributionFunctions.cdfbet(betav /= betav + absx, 0.5 * a, 0.5))) {
                            result = 0.5 * result;
                            if (x > 1.0) {
                                result = 1.0 - result;
                            }
                        }
                    } else {
                        double betav = absx / (absx + a / absx);
                        result = DistributionFunctions.cdfbet(betav, 0.5, 0.5 * a);
                        if (!MissingValue.isMissing(result)) {
                            if (x < 0.0) {
                                result = -result;
                            }
                            result = 0.5 + 0.5 * result;
                        }
                    }
                } else {
                    result = 0.5 + Math.atan(x) / Math.PI;
                }
            } else {
                result = 0.5;
            }
        } else {
            result = MissingValue.getMissing();
        }
        return result;
    }

    static double cdfbet(double x, double a, double b) {
        double work1;
        double exparg;
        double eps = 1.0E-15;
        int ntmax = 10000;
        double sum = 0.0;
        int retcod = 0;
        double result = 0.0;
        boolean qcont = true;
        boolean qcnvrg = false;
        int method = 3;
        boolean qcdf = true;
        double xx = x;
        double yy = 1.0 - x;
        double aa = a;
        double bb = b;
        double apb = aa + bb;
        if (aa > 0.0 && bb > 0.0) {
            qcont = false;
            if (xx <= 0.0) {
                result = 0.0;
            } else if (yy <= 0.0) {
                result = 1.0;
            } else {
                qcont = true;
            }
        } else {
            retcod = 1;
            qcont = false;
        }
        if (qcont) {
            qcont = false;
            if (aa == 1.0) {
                if (bb == 1.0) {
                    result = xx;
                } else {
                    exparg = bb * Math.log(yy);
                    result = 1.0 - Math.exp(exparg);
                }
            } else if (bb == 1.0) {
                exparg = aa * Math.log(xx);
                result = Math.exp(exparg);
            } else {
                qcont = true;
            }
        }
        if (qcont && aa == bb) {
            if (xx == 0.5) {
                result = 0.5;
            } else if (aa == 0.5) {
                result = 2.0 * (Math.asin(Math.sqrt(xx)) / Math.PI);
            } else {
                qcont = true;
            }
        }
        if (qcont) {
            double t;
            int it;
            double work2;
            double term;
            method = aa <= 1.0 || bb <= 1.0 ? 1 : 2;
            if (method == 1) {
                if (aa <= 1.0) {
                    qcdf = !qcdf;
                    work1 = xx;
                    xx = yy;
                    yy = work1;
                    work1 = aa;
                    aa = bb;
                    bb = work1;
                }
                qcnvrg = false;
                sum = 1.0;
                term = 1.0;
                work1 = apb;
                work2 = aa + 1.0;
                for (it = 0; it <= 10000; ++it) {
                    t = it;
                    term = (work1 + t) / (work2 + t) * xx * term;
                    sum = term + sum;
                    if (!(Math.abs(term) < 1.0E-15)) continue;
                    qcnvrg = true;
                    break;
                }
                if (!qcnvrg) {
                    method = 2;
                }
            }
            if (method == 2) {
                double coeff2 = a + b;
                if (coeff2 < 1.0) {
                    coeff2 = 1.0;
                }
                coeff2 *= 10.0;
                work1 = (aa + 1.0) / (apb + 2.0);
                if (xx >= work1) {
                    qcdf = !qcdf;
                    work1 = xx;
                    xx = yy;
                    yy = work1;
                    work1 = aa;
                    aa = bb;
                    bb = work1;
                }
                qcnvrg = false;
                term = -xx * (apb / (aa + 1.0));
                double cj2 = 1.0;
                double cj1 = 1.0;
                double dj2 = 1.0;
                double dj1 = 1.0 + term;
                sum = cj1 / dj1;
                for (it = 1; it <= 10000; ++it) {
                    t = it;
                    work1 = aa + t;
                    work2 = work1 + t;
                    term = xx * (t / work2) * ((bb - t) / (work2 - 1.0));
                    double cj = cj1 + term * cj2;
                    double dj = dj1 + term * dj2;
                    cj2 = cj1;
                    dj2 = dj1;
                    cj1 = cj;
                    dj1 = dj;
                    term = -xx * (work1 / work2) * ((work1 + bb) / (work2 + 1.0));
                    cj = cj1 + term * cj2;
                    dj = dj1 + term * dj2;
                    if (dj == 0.0) {
                        cj2 = cj1;
                        dj2 = dj1;
                        cj1 = cj;
                        dj1 = dj;
                        continue;
                    }
                    cj2 = cj1 / dj;
                    dj2 = dj1 / dj;
                    cj1 = cj / dj;
                    dj1 = 1.0;
                    sum = cj1;
                    double sumold = sum;
                    if (!Power.almostEqual(sum, sumold, coeff2)) continue;
                    qcnvrg = true;
                    break;
                }
                if (!qcnvrg) {
                    method = 3;
                }
            }
        }
        if (qcont && method != 3) {
            if (sum > 0.0) {
                exparg = aa * Math.log(xx) + bb * Math.log(yy) + Math.log(sum) + (DistributionFunctions.dnlgam(apb) - DistributionFunctions.dnlgam(aa + 1.0) - DistributionFunctions.dnlgam(bb));
                result = Math.exp(exparg);
            } else {
                result = 0.0;
            }
            if (!qcdf) {
                result = 1.0 - result;
            }
        }
        if (qcont && method == 3) {
            double zval = 0.0;
            double apbm1 = apb - 1.0;
            zval = xx * DistributionFunctions.cbtaux((aa - 0.5) / apbm1) + yy * DistributionFunctions.cbtaux((bb - 0.5) / apbm1) + 1.0;
            if ((zval /= (apbm1 + 0.16666666666666666) * xx * yy) > 0.0) {
                work1 = (1.0 + xx) / 3.0 + apbm1 * (xx - aa / apbm1) + (xx / bb - yy / aa + (xx - 0.5) / apb) / 50.0;
                zval = work1 * Math.sqrt(zval);
            } else {
                zval = 0.0;
            }
            if (!qcdf) {
                zval = -zval;
            }
            result = DistributionFunctions.prbnrm(zval);
        }
        if (retcod > 0) {
            result = MissingValue.getMissing();
        }
        return result;
    }

    static double cbtaux(double x) {
        double omx;
        double result = x > 0.0 ? (x <= MAX_SQRT ? ((omx = 1.0 - x) == 0.0 ? 0.0 : (1.0 - x * x + 2.0 * x * Math.log(x)) / (omx * omx)) : -1.0) : (x == 0.0 ? 1.0 : MissingValue.getMissing());
        return result;
    }

    static double gammad(double x, double a, boolean qcdf) {
        double aa = 0.0;
        double an = 0.0;
        double bb = 0.0;
        double cc = 0.0;
        double pn1 = 0.0;
        double pn2 = 0.0;
        double pn3 = 0.0;
        double pn4 = 0.0;
        double pn5 = 0.0;
        double pn6 = 0.0;
        double exparg = 0.0;
        int method = 0;
        double nterm = 0.0;
        double result = 0.0;
        double rn = 0.0;
        int retcod = 0;
        result = 0.0;
        exparg = 0.0;
        method = 0;
        if (a > 0.0) {
            if (x <= 0.0) {
                method = 4;
                if (!qcdf) {
                    result = 1.0;
                }
            } else if (a == 1.0) {
                method = 4;
                exparg = -x;
                result = Math.exp(exparg);
                if (qcdf) {
                    result = 1.0 - result;
                }
            } else if (x <= 1.0 || x <= a) {
                method = 1;
                nterm = Math.log10(x / (a + 1.0));
                if (nterm != 0.0) {
                    nterm = Math.log10(1.0E-14) / nterm;
                    if (nterm > 0.0 && (nterm = 10.0 + 2.0 * Math.sqrt(nterm)) * nterm >= (pn1 = 2.147483647E9)) {
                        method = 3;
                    }
                } else {
                    method = 3;
                }
                if (method == 1 && MissingValue.isMissing(exparg = DistributionFunctions.dnlgam(a + 1.0))) {
                    method = 3;
                }
            } else {
                method = 2;
                exparg = DistributionFunctions.dnlgam(a);
                if (MissingValue.isMissing(exparg) || 4.0 * Math.log(x) >= 709.78) {
                    method = 3;
                }
            }
            if (method == 1 || method == 2) {
                exparg = a * Math.log(x) - (exparg + x);
            }
        } else {
            retcod = 1;
        }
        if (method == 1) {
            aa = a;
            cc = 1.0;
            result = 1.0;
            do {
                cc = cc * x / (aa += 1.0);
                result += cc;
            } while (!(cc < 1.0E-14));
            if ((exparg += Math.log(result)) > 0.0) {
                method = 3;
            } else {
                result = Math.exp(exparg);
                if (!qcdf) {
                    result = 1.0 - result;
                }
            }
        }
        if (method == 2) {
            aa = 1.0 - a;
            bb = aa + x + 1.0;
            cc = 0.0;
            pn1 = 1.0;
            pn2 = x;
            pn3 = x + 1.0;
            pn4 = x * bb;
            result = pn3 / pn4;
            while (true) {
                an = (aa += 1.0) * (cc += 1.0);
                pn5 = (bb += 2.0) * pn3 - an * pn1;
                pn6 = bb * pn4 - an * pn2;
                if (Math.abs(pn6) > 0.0) {
                    rn = pn5 / pn6;
                    double tolMin = 1.0E-14 * rn;
                    if (1.0E-14 < tolMin) {
                        tolMin = 1.0E-14;
                    }
                    if (Math.abs(result - rn) <= tolMin) break;
                    result = rn;
                }
                pn1 = pn3;
                pn2 = pn4;
                pn3 = pn5;
                pn4 = pn6;
                if (!(Math.abs(pn5) >= GAMMAD_MAX_SQRT)) continue;
                pn1 /= GAMMAD_MAX_SQRT;
                pn2 /= GAMMAD_MAX_SQRT;
                pn3 /= GAMMAD_MAX_SQRT;
                pn4 /= GAMMAD_MAX_SQRT;
            }
            exparg += Math.log(result);
            if (exparg > 0.0) {
                method = 3;
            } else {
                result = Math.exp(exparg);
                if (qcdf) {
                    result = 1.0 - result;
                }
            }
        }
        if (method == 3) {
            if (qcdf || a < 0.5) {
                pn1 = 3.0 * Math.sqrt(a);
                if (x != a) {
                    exparg = Math.log(x / a) / 3.0;
                    pn2 = Math.exp(exparg);
                    pn1 *= pn2 + 1.0 / (9.0 * a) - 1.0;
                } else {
                    pn1 = 1.0 / pn1;
                }
                if (!qcdf) {
                    pn1 = -pn1;
                }
                result = DistributionFunctions.prbnrm(pn1);
            } else {
                pn1 = (a - 0.5) / x;
                if (pn1 == 0.0) {
                    pn2 = Math.sqrt(2.0 / x);
                } else if (pn1 == 1.0) {
                    pn2 = Math.sqrt(1.0 / x);
                } else {
                    pn2 = 2.0 * (1.0 + pn1 * Math.log(pn1) - pn1);
                    pn2 = Math.sqrt(pn2 / x) / Math.abs(1.0 - pn1);
                }
                pn1 = (a + 0.022 / a - x - 0.3333333333333333) * pn2;
                result = DistributionFunctions.prbnrm(pn1);
            }
        }
        if (retcod > 0) {
            result = MissingValue.getMissing();
        }
        return result;
    }

    static double prbnrm(double z) {
        double result = z > 0.0 ? 0.5 * (DistributionFunctions.derf(z / SQRT_2) + 1.0) : (z < 0.0 ? 0.5 * DistributionFunctions.derfc(-z / SQRT_2) : 0.5);
        return result;
    }

    static double dnlgam(double x) {
        int k = 0;
        double t = 0.0;
        double v = 0.0;
        double w = 0.0;
        double y = 0.0;
        w = x;
        if (w >= 8.0) {
            v = 1.0 / w;
            t = v * v;
            y = (((((DNLGAM_D[0] * t + DNLGAM_D[1]) * t + DNLGAM_D[2]) * t + DNLGAM_D[3]) * t + DNLGAM_D[4]) * t + DNLGAM_D[5]) * v + DNLGAM_D[6];
            y += (w - 0.5) * Math.log(w) - w;
        } else if (w >= 3.5) {
            k = (int)(Math.floor(w) - 3.0);
            t = w - ((double)k + 3.5);
            y = (((((((((((DNLGAM_C[k *= 13] * t + DNLGAM_C[k + 1]) * t + DNLGAM_C[k + 2]) * t + DNLGAM_C[k + 3]) * t + DNLGAM_C[k + 4]) * t + DNLGAM_C[k + 5]) * t + DNLGAM_C[k + 6]) * t + DNLGAM_C[k + 7]) * t + DNLGAM_C[k + 8]) * t + DNLGAM_C[k + 9]) * t + DNLGAM_C[k + 10]) * t + DNLGAM_C[k + 11]) * t + DNLGAM_C[k + 12];
        } else if (w == 1.0 || w == 2.0) {
            y = 0.0;
        } else if (w > 0.5) {
            t = w - 4.5 / (w + 0.5);
            k = (int)Math.floor(t + 4.0);
            t -= (double)k - 3.5;
            y = ((((((((((((DNLGAM_B[k *= 14] * t + DNLGAM_B[k + 1]) * t + DNLGAM_B[k + 2]) * t + DNLGAM_B[k + 3]) * t + DNLGAM_B[k + 4]) * t + DNLGAM_B[k + 5]) * t + DNLGAM_B[k + 6]) * t + DNLGAM_B[k + 7]) * t + DNLGAM_B[k + 8]) * t + DNLGAM_B[k + 9]) * t + DNLGAM_B[k + 10]) * t + DNLGAM_B[k + 11]) * t + DNLGAM_B[k + 12]) * t + DNLGAM_B[k + 13];
        } else if (w == 0.5) {
            y = Math.log(Math.PI) / 2.0;
        } else {
            k = w < 0.25 ? 0 : 11;
            y = ((((((((((DNLGAM_A[k] * w + DNLGAM_A[k + 1]) * w + DNLGAM_A[k + 2]) * w + DNLGAM_A[k + 3]) * w + DNLGAM_A[k + 4]) * w + DNLGAM_A[k + 5]) * w + DNLGAM_A[k + 6]) * w + DNLGAM_A[k + 7]) * w + DNLGAM_A[k + 8]) * w + DNLGAM_A[k + 9]) * w + DNLGAM_A[k + 10]) * w;
            y = y > 0.0 ? -Math.log(y) : MissingValue.getMissing();
        }
        return y;
    }

    static double derf(double x) {
        double y;
        double w = Math.abs(x);
        if (w <= 0.0) {
            y = 0.0;
        } else if (w < 2.2) {
            double t = w * w;
            int k = (int)Math.floor(t);
            t -= (double)k;
            k = 13 * k;
            y = ((((((((((((DERF_A[k] * t + DERF_A[k + 1]) * t + DERF_A[k + 2]) * t + DERF_A[k + 3]) * t + DERF_A[k + 4]) * t + DERF_A[k + 5]) * t + DERF_A[k + 6]) * t + DERF_A[k + 7]) * t + DERF_A[k + 8]) * t + DERF_A[k + 9]) * t + DERF_A[k + 10]) * t + DERF_A[k + 11]) * t + DERF_A[k + 12]) * w;
        } else if (w < 6.9) {
            int k = (int)Math.floor(w);
            double t = w - (double)k;
            k = 13 * (k - 2);
            y = (((((((((((DERF_B[k] * t + DERF_B[k + 1]) * t + DERF_B[k + 2]) * t + DERF_B[k + 3]) * t + DERF_B[k + 4]) * t + DERF_B[k + 5]) * t + DERF_B[k + 6]) * t + DERF_B[k + 7]) * t + DERF_B[k + 8]) * t + DERF_B[k + 9]) * t + DERF_B[k + 10]) * t + DERF_B[k + 11]) * t + DERF_B[k + 12];
            y *= y;
            y *= y;
            y *= y;
            y = 1.0 - y * y;
        } else {
            y = 1.0;
        }
        if (x < 0.0) {
            y = -y;
        }
        return y;
    }

    static double derfc(double x) {
        double y;
        double pa = 3.97886080735226;
        double w = Math.abs(x);
        if (w <= 0.0) {
            y = 1.0;
        } else {
            double t = 3.97886080735226 / (3.97886080735226 + w);
            double u = t - 0.5;
            y = (((((((((0.0012710976495261409 * u + 1.1931402283834095E-4) * u + -0.003963850973605135) * u + -8.707796353172959E-4) * u + 0.007736725283135267) * u + 0.003833351262648873) * u + -0.012722381378212275) * u + -0.013382364453346007) * u + 0.016131532973325226) * u + 0.039097684558848406) * u + 0.002493672000535033;
            y = (y = ((((((((((((y * u + -0.0838864557023002) * u + -0.11946395996432542) * u + 0.016620792496936737) * u + 0.35752427444953105) * u + 0.8052764087529106) * u + 1.1890298290927332) * u + 1.3704021768233816) * u + 1.313146538310231) * u + 1.0792551515585667) * u + 0.7743681991195386) * u + 0.49016508058531844) * u + 0.2753747415973768) * t) > 0.0 ? (y *= Math.exp(-w * w)) : 0.0;
            if (x < 0.0) {
                y = 2.0 - y;
            }
        }
        return y;
    }

    static double spssidfchi(double p, double df) {
        double s1;
        double t;
        double p2;
        double p1;
        double q;
        double a;
        double exparg;
        double result = MissingValue.getMissing();
        double xx = 0.0;
        double start = 0.0;
        double c = 0.0;
        double ch = 0.0;
        double g = 0.0;
        int i = 0;
        boolean qcont = false;
        if (!(p >= 0.0 && p < 1.0 && df > 0.0)) {
            result = MissingValue.getMissing();
        } else if (p == 0.0) {
            result = 0.0;
        } else {
            qcont = true;
        }
        if (qcont) {
            xx = 0.5 * df;
            g = DistributionFunctions.dnlgam(xx);
            c = xx - 1.0;
            if (df < (double)-1.24f * Math.log(p)) {
                exparg = (Math.log(p) + Math.log(xx) + g + xx * 0.6931471805599453) / xx;
                if (exparg < -744.44) {
                    ch = 0.0;
                } else if (exparg > 141.956) {
                    qcont = false;
                } else {
                    ch = Math.exp(exparg);
                }
                if (ch < 5.0E-7) {
                    result = ch;
                    qcont = false;
                }
            } else if (df <= (double)0.32f) {
                ch = 0.4f;
                a = Math.log(1.0 - p);
                boolean bLoop = true;
                while (bLoop) {
                    q = ch;
                    p1 = 1.0 + ch * ((double)4.67f + ch);
                    p2 = ch * ((double)6.73f + ch * ((double)6.66f + ch));
                    t = -0.5 + ((double)4.67f + 2.0 * ch) / p1 - ((double)6.73f + ch * ((double)13.32f + 3.0 * ch)) / p2;
                    exparg = a + g + 0.5 * ch + c * 0.6931471805599453 + Math.log(p2) - Math.log(p1);
                    if (exparg < -744.44) {
                        ch += -1.0 / t;
                    } else if (exparg > 141.956) {
                        qcont = false;
                    } else {
                        ch += -(1.0 - Math.exp(exparg)) / t;
                    }
                    if (Math.abs(q / ch - 1.0) > (double)0.01f && qcont) continue;
                    bLoop = false;
                }
            } else {
                double x = DistributionFunctions.probit(p);
                if (MissingValue.isMissing(x)) {
                    qcont = false;
                }
                if (qcont) {
                    p1 = (double)0.222222f / df;
                    s1 = x * Math.sqrt(p1) + 1.0 - p1;
                    if (s1 == 0.0) {
                        ch = 0.0;
                    } else {
                        exparg = Math.log(df) + 3.0 * Math.log(Math.abs(s1));
                        if (exparg < -744.44) {
                            ch = 0.0;
                        } else if (exparg > 141.956) {
                            qcont = false;
                        } else {
                            ch = Math.exp(exparg);
                            if (s1 < 0.0) {
                                ch = -ch;
                            }
                        }
                    }
                    if (ch > (double)2.2f * df + 6.0 && qcont) {
                        ch = -2.0 * (Math.log(1.0 - p) - c * Math.log(0.5 * ch) + g);
                    }
                }
            }
        }
        if (qcont) {
            start = ch;
            for (i = 1; i <= 20; ++i) {
                if (ch <= 0.0) {
                    qcont = false;
                    break;
                }
                q = ch;
                p1 = 0.5 * ch;
                double gamout = DistributionFunctions.gammad(p1, xx, true);
                if (MissingValue.isMissing(gamout)) {
                    qcont = false;
                    break;
                }
                p2 = p - gamout;
                exparg = xx * 0.6931471805599453 + g + p1 - c * Math.log(ch);
                if (exparg < -744.44) {
                    t = 0.0;
                } else {
                    if (exparg > 141.956) {
                        qcont = false;
                        break;
                    }
                    t = p2 * Math.exp(exparg);
                }
                double b = t / ch;
                a = 0.5 * t - b * c;
                s1 = (210.0 + a * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0;
                double s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0;
                double s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0;
                double s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0;
                double s5 = (84.0 + 2264.0 * a + c * (1175.0 + 606.0 * a)) / 2520.0;
                double s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0;
                ch += t * (1.0 + 0.5 * t * s1 - b * c * (s1 - b * (s2 - b * (s3 - b * (s4 - b * (s5 - b * s6))))));
                if (!(Math.abs(q - ch) <= 5.0E-7 * ch)) continue;
                result = ch;
                qcont = false;
                break;
            }
        }
        if (qcont) {
            result = DistributionFunctions.idfchb(p, df, start);
        }
        return result;
    }

    static double idfchb(double p, double df, double start) {
        double eps = 1.0E-8;
        int maxIt = 40;
        int retcod = 0;
        double gl = 0.0;
        double gm = 0.0;
        double gr = 0.0;
        double pl = 0.0;
        double pr = 0.0;
        double gdf = df * 0.5;
        if (!(start > 0.0)) {
            retcod = 1;
        }
        if (retcod == 0) {
            gl = start * 0.25;
            pl = DistributionFunctions.gammad(gl, gdf, true);
            if (!MissingValue.isMissing(pl)) {
                gr = start;
                pr = DistributionFunctions.gammad(gr, gdf, true);
                if (MissingValue.isMissing(pr)) {
                    retcod = 2;
                }
            } else {
                retcod = 2;
            }
        }
        if (retcod == 0 && !(pl <= p)) {
            retcod = 2;
        }
        if (retcod == 0 && !(pr >= p)) {
            pr = DistributionFunctions.gammad(gr *= 2.0, gdf, true);
            if (MissingValue.isMissing(pr)) {
                retcod = 2;
            } else if (!(pr >= p)) {
                retcod = 2;
            }
        }
        if (retcod == 0) {
            int iter = 1;
            double gdiff = gr - gl;
            gm = (gr + gl) * 0.5;
            while (iter <= 40 && gdiff > 1.0E-8 * gm && retcod == 0) {
                double pm = DistributionFunctions.gammad(gm, gdf, true);
                if (!MissingValue.isMissing(pm)) {
                    if (pm > p) {
                        gr = gm;
                    } else {
                        gl = gm;
                    }
                    ++iter;
                    gdiff = gr - gl;
                    gm = (gr + gl) * 0.5;
                    continue;
                }
                retcod = 2;
            }
        }
        double result = retcod > 0 ? MissingValue.getMissing() : gm * 2.0;
        return result;
    }

    static double spssidff(double p, double a, double b) {
        double result = MissingValue.getMissing();
        if (p >= 0.0 && p < 1.0 && a > 0.0 && b > 0.0) {
            if (p > 0.0) {
                if (a == 1.0) {
                    result = DistributionFunctions.spssidft(0.5 * p + 0.5, b);
                    if (!MissingValue.isMissing(result)) {
                        result *= result;
                    }
                } else {
                    result = DistributionFunctions.betinv(p, a / 2.0, b / 2.0);
                    if (!MissingValue.isMissing(result)) {
                        result = result >= 0.0 && result < 1.0 ? b / a * (result / (1.0 - result)) : MissingValue.getMissing();
                    }
                }
            } else {
                result = 0.0;
            }
        }
        return result;
    }

    static double betinv(double p, double a, double b) {
        double exparg;
        double fi = 0.0;
        double aa = 0.0;
        double bb = 0.0;
        double pp = 0.0;
        double cmplbt = 0.0;
        double xi = 0.0;
        double xip1 = 0.0;
        double result = -1.0;
        boolean qcont = true;
        if (a <= 0.0 || b <= 0.0 || p > 1.0 || p < 0.0) {
            qcont = false;
        }
        if (p == 0.0) {
            result = 0.0;
            qcont = false;
        } else if (p == 1.0) {
            result = 1.0;
            qcont = false;
        }
        if (qcont) {
            qcont = false;
            if (a == b) {
                if (p == 0.5) {
                    result = 0.5;
                } else if (a == 0.5) {
                    result = Math.sin(0.5 * p * Math.PI);
                    result *= result;
                } else {
                    qcont = true;
                }
            } else if (a == 1.0) {
                exparg = 1.0 - p;
                if (exparg > 0.0) {
                    exparg = Math.log(exparg) / b;
                    result = 1.0 - Math.exp(exparg);
                } else {
                    result = 1.0;
                }
            } else if (b == 1.0) {
                exparg = Math.log(p) / a;
                result = Math.exp(exparg);
            } else {
                qcont = true;
            }
        }
        if (qcont && b <= 1.0E-20 * a) {
            result = 1.0;
            qcont = false;
        }
        if (qcont) {
            fi = DistributionFunctions.probit(p);
            if (MissingValue.isMissing(fi)) {
                qcont = false;
            } else if (p <= 0.5) {
                aa = a;
                bb = b;
                pp = p;
                fi = -fi;
            } else {
                aa = b;
                bb = a;
                pp = 1.0 - p;
            }
        }
        if (qcont) {
            double t;
            double r;
            cmplbt = DistributionFunctions.dnlgam(aa) + DistributionFunctions.dnlgam(bb) - DistributionFunctions.dnlgam(aa + bb);
            if (aa > 1.0 && bb > 1.0) {
                r = (fi * fi - 3.0) / 6.0;
                double s = 1.0 / (aa + aa - 1.0);
                t = 1.0 / (bb + bb - 1.0);
                double h = 2.0 / (s + t);
                double w = fi * Math.sqrt(h + r) / h - (t - s) * (r + 0.8333333333333334 - 2.0 / (3.0 * h));
                xi = aa / (aa + bb * Math.exp(w + w));
            } else {
                r = bb + bb;
                t = 1.0 / (9.0 * bb);
                double temp1 = 1.0 - t + fi * Math.sqrt(t);
                double temp2 = temp1 * temp1 * temp1;
                if ((t = r * temp2) > 0.0) {
                    if ((t = (4.0 * aa + r - 2.0) / t) <= 1.0) {
                        exparg = (Math.log(pp * aa) + cmplbt) / pp;
                        if (exparg > 709.78) {
                            result = a / (a + b);
                            qcont = false;
                        } else {
                            xi = Math.exp(exparg);
                        }
                    } else {
                        xi = 1.0 - 2.0 / (t + 1.0);
                    }
                } else {
                    exparg = (Math.log((1.0 - pp) * bb) + cmplbt) / bb;
                    if (exparg > 709.78) {
                        result = a / (a + b);
                        qcont = false;
                    } else {
                        xi = 1.0 - Math.exp(exparg);
                    }
                }
            }
        }
        if (qcont) {
            double a1 = 1.0 - aa;
            double b1 = 1.0 - bb;
            double fim1 = 0.0;
            double sq = 1.0;
            double xim1 = 1.0;
            if (xi < 1.0E-8) {
                xi = 1.0E-8;
            }
            if (xi > 0.9999999) {
                xi = 0.9999999;
            }
            int iter = 1;
            while ((double)iter <= 50.0) {
                fi = DistributionFunctions.cdfbet(xi, aa, bb);
                if (MissingValue.isMissing(fi)) {
                    qcont = false;
                    break;
                }
                exparg = cmplbt + a1 * Math.log(xi) + b1 * Math.log(1.0 - xi);
                if (exparg > 709.78) {
                    result = a / (a + b);
                    qcont = false;
                    break;
                }
                fi = exparg < -744.44 ? 0.0 : (fi - pp) * Math.exp(exparg);
                if (fi * fim1 <= 0.0) {
                    xim1 = sq;
                }
                double g = 1.0;
                boolean bLoop = true;
                while (bLoop) {
                    double adj = g * fi;
                    sq = adj * adj;
                    if (sq < xim1 && (xip1 = xi - adj) > 0.0 && xip1 < 1.0) {
                        bLoop = false;
                    }
                    if (!bLoop) continue;
                    g /= 3.0;
                }
                if (xim1 <= 1.0E-20 || fi * fi <= 1.0E-20 || xip1 == xi) break;
                xi = xip1;
                fim1 = fi;
                ++iter;
            }
        }
        if (qcont) {
            result = xi;
            if (p > 0.5) {
                result = 1.0 - result;
            }
        }
        return result;
    }

    static double probit(double p) {
        double result;
        if (p <= 0.0 || p >= 1.0) {
            result = MissingValue.getMissing();
        } else {
            double q = p - 0.5;
            if (q == 0.0) {
                result = 0.0;
            } else if (Math.abs(q) <= 0.425) {
                double r = 0.180625 - q * q;
                result = q * (((((((2509.0809287301227 * r + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((5226.495278852854 * r + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
            } else {
                double r = q < 0.0 ? p : 1.0 - p;
                r = Math.sqrt(-Math.log(r));
                result = r <= 5.0 ? (((((((7.745450142783414E-4 * (r -= 1.6) + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((1.0507500716444169E-9 * r + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : (((((((2.0103343992922881E-7 * (r -= 5.0) + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((2.0442631033899397E-15 * r + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
                if (q < 0.0) {
                    result = -result;
                }
            }
        }
        return result;
    }

    static double spssidft(double p, double a) {
        double biga = 1.0E8;
        double result = MissingValue.getMissing();
        int retcod = 0;
        if (!(p > 0.0 && p < 1.0 && a > 0.0)) {
            retcod = 1;
        }
        if (retcod == 0) {
            if (p == 0.5) {
                result = 0.0;
            } else if (a >= 1.0E8) {
                result = DistributionFunctions.idfStdNorm(p);
            } else {
                double betarg = p < 0.5 ? p + p : 2.0 - p - p;
                double betout = DistributionFunctions.betinv(betarg, a * 0.5, 0.5);
                if (betout == -1.0) {
                    retcod = 2;
                } else {
                    result = a * (1.0 / betout - 1.0);
                    if (result >= 0.0) {
                        result = Math.sqrt(result);
                        if (p < 0.5) {
                            result = -result;
                        }
                    } else {
                        retcod = 2;
                    }
                }
            }
        }
        if (retcod > 0) {
            result = MissingValue.getMissing();
        }
        return result;
    }

    public static double sigF(double funArg, double df1, double df2) {
        int retcod = 0;
        double result = MissingValue.getMissing();
        if (df1 > 0.0 && df2 > 0.0) {
            if (funArg >= 1.0) {
                double betav = df2 / df1;
                betav /= funArg + betav;
                result = DistributionFunctions.cdfbet(betav, df2 * 0.5, df1 * 0.5);
            } else if (funArg > 0.0) {
                double betav = funArg / (funArg + df2 / df1);
                result = 1.0 - DistributionFunctions.cdfbet(betav, df1 * 0.5, df2 * 0.5);
            } else if (funArg <= 0.0) {
                result = 1.0;
            } else {
                retcod = 2;
            }
        } else {
            retcod = 1;
        }
        if (retcod > 0) {
            result = MissingValue.getMissing();
        }
        return result;
    }

    public static double idfBeta(double p, double a, double b) {
        return DistributionFunctions.betinv(p, a, b);
    }

    public static double idfLaplace(double p, double a, double b) {
        double result = MissingValue.getMissing();
        if (b <= 0.0) {
            return result;
        }
        if (p <= 0.0 || p >= 1.0) {
            return result;
        }
        result = p == 0.5 ? a : (p < 0.5 ? a + b * Math.log(2.0 * p) : a - b * Math.log(2.0 - 2.0 * p));
        return result;
    }
}

