/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import com.spss.math.MissingValue;
import com.spss.math.statistics.DistributionFunctions;
import com.spss.math.statistics.Power;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MathFun {
    public static final double DOUBLE_EPSILON = 2.220446049250313E-16;
    public static final double DIGAMMA_A1 = 0.021092796092796094;
    public static final double DIGAMMA_A2 = -0.007575757575757576;
    public static final double DIGAMMA_A3 = 0.004166666666666667;
    public static final double DIGAMMA_A4 = -0.003968253968253968;
    public static final double DIGAMMA_A5 = 0.008333333333333333;
    public static final double DIGAMMA_A6 = -0.08333333333333333;
    public static final double DIGAMMA_CRIT_ARG = 1.0E-16;
    public static final double DIGAMMA_SMALL_ARG = 1.0E-5;
    public static final double DIGAMMA_SMALL_ARGP = -0.5772156649015329;
    public static final double TRIGAMMA_A1 = -0.2531135531135531;
    public static final double TRIGAMMA_A2 = 0.07575757575757576;
    public static final double TRIGAMMA_A3 = -0.03333333333333333;
    public static final double TRIGAMMA_A4 = 0.023809523809523808;
    public static final double TRIGAMMA_A5 = -0.03333333333333333;
    public static final double TRIGAMMA_A6 = 0.16666666666666666;
    public static final double TRIGAMMA_CRIT_ARG = 1.0E-16;
    public static final double TRIGAMMA_SMALL_ARG = 1.0E-4;
    public static final double[] LOGFACTORIAL_PRECOMPUTED = new double[]{0.0, 0.0, 0.693147180559945, 1.791759469228055, 3.178053830347946, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.801827480081469, 15.104412573075516, 17.502307845873887, 19.987214495661885, 22.55216385312342, 25.191221182738683, 27.899271383840894, 30.671860106080675, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485, 45.38013889847691, 48.47118135183523, 51.60667556776438, 54.78472939811232, 58.00360522298052, 61.261701761002, 64.55753862700632, 67.88974313718153, 71.257038967168, 74.65823634883016, 78.0922235533153, 81.55795945611503, 85.05446701758152, 88.58082754219768, 92.13617560368708, 95.7196945421432, 99.33061245478743, 102.96819861451381, 106.63176026064345, 110.32063971475739, 114.03421178146169, 117.77188139974506, 121.53308151543864, 125.31727114935688, 129.12393363912724, 132.9525750356163, 136.80272263732635, 140.67392364823425, 144.5657439463449, 148.47776695177302, 152.40959258449735, 156.3608363030788, 160.33112821663093, 164.32011226319517, 168.32744544842765, 172.35279713916282, 176.39584840699737, 180.45629141754378, 184.5338288614495, 188.6281734236716, 192.7390472878449, 196.86618167288998, 201.00931639928157, 205.1681994826412, 209.34258675253682, 213.53224149456327, 217.73693411395425, 221.95644181913036, 226.19054832372757, 230.43904356577693, 234.70172344281826, 238.97838956183435, 243.26884900298273, 247.5729140961869, 251.8904022097232, 256.2211355500095, 260.5649409718632, 264.9216497985528, 269.2910976510198, 273.6731242856937, 278.0675734403661, 282.4742926876304, 286.893133295427, 291.3239500942703, 295.7666013507606, 300.2209486470141, 304.6868567656687, 309.1641935801469, 313.652829949879, 318.1526396202093, 322.6634991267262, 327.1852877037752, 331.7178871969285, 336.26118197919845, 340.81505887079896, 345.37940706226686, 349.95411804077025, 354.5390855194408, 359.13420536957534, 363.73937555556347, 368.3544960724047, 372.979468885689, 377.61419787391867, 382.25858877306, 386.91254912321756, 391.5759882173296, 396.2488170517915, 400.93094827891576, 405.6222961611449, 410.3227765269373, 415.0323067282496, 419.7508055995448, 424.4781934182571, 429.21439186665157, 433.95932399501487, 438.71291418612117, 443.47508812091894, 448.2457727453846, 453.0248962384961, 457.8123879812781, 462.6081785268749, 467.4121995716081, 472.2243839269805, 477.0446654925856, 481.8729792298879, 486.70926113683936, 491.553448223298, 496.4054784872176, 501.26529089157924, 506.13282534203483, 511.00802266523607, 515.8908245878225, 520.7811737160442, 525.679013515995, 530.5842882944336, 535.4969431801695, 540.4169241059977, 545.344177791155, 550.2786517242856, 555.220294146895, 560.1690540372731, 565.1248810948744, 570.0877257251342, 575.0575390247102, 580.0342727671308, 585.0178793888392, 590.0083119756179, 595.005524249382, 600.0094705553274, 605.0201058494238, 610.0373856862387, 615.0612662070849, 620.0917041284774, 625.1286567308911, 630.1720818478102, 635.2219378550598, 640.2781836604081, 645.340778693435, 650.4096828956552, 655.4848567108891, 660.5662610758735, 665.653857411106, 670.7476076119127, 675.8474740397369, 680.9534195136375, 686.065407301994, 691.1834011144108, 696.307365093814, 701.4372638087372, 706.5730622457875, 711.71472580229, 716.8622202791034, 722.0155118736013, 727.1745671728158, 732.3393531467393, 737.5098371417774, 742.6859868743512, 747.8677704246434, 753.0551562304842, 758.2481130813743, 763.4466101126402, 768.650616799717, 773.8601029525585, 779.0750387101674, 784.2953945352457, 789.521141208959, 794.7522498258135, 799.9886917886435, 805.2304388037031, 810.4774628758636, 815.7297363039102, 820.9872316759379, 826.2499218648428, 831.5177800239063, 836.7907795824699, 842.0688942417005, 847.3520979704384, 852.6403650011331, 857.9336698258575, 863.2319871924054, 868.5352921004646, 873.8435597978657, 879.1567657769076, 884.4748857707518, 889.7978957498902, 895.1257719186799, 900.4584907119453, 905.7960287916463, 911.1383630436112, 916.4854705743288, 921.8373287078049, 927.1939149824767, 932.5552071481862, 937.9211831632081, 943.2918211913357, 948.6670995990198, 954.0469969525604, 959.4314920153495, 964.8205637451659, 970.2141912915183, 975.6123539930362, 981.0150313749084, 986.4222031463686, 991.8338491982234, 997.2499496004278, 1002.6704845997003, 1008.0954346171817, 1013.5247802461362, 1018.9585022496902, 1024.3965815586134, 1029.8389992691355, 1035.2857366408016, 1040.7367750943674, 1046.192096209725, 1051.6516817238692, 1057.115513528895, 1062.58357367003, 1068.0558443437014, 1073.5323078956328, 1079.012946818975, 1084.4977437524656, 1089.9866814786224, 1095.4797429219627, 1100.976911147256, 1106.4781693578009, 1111.983500893733, 1117.492889230361, 1123.0063179765261, 1128.5237708729908, 1134.045231790853, 1139.5706847299848, 1145.100113817496, 1150.6335033062237, 1156.1708375732424};

    public static int binSearch(double[] cutPoints, int minIndex, int maxIndex, double theValue, boolean bOpenRgt) {
        boolean bArgOK;
        int result = -2;
        boolean bl = bArgOK = maxIndex < cutPoints.length && minIndex <= maxIndex;
        if (bArgOK) {
            if (theValue > cutPoints[maxIndex] || theValue == cutPoints[maxIndex] && bOpenRgt) {
                result = -1;
            } else if (minIndex > 0 && (cutPoints[minIndex - 1] > theValue || theValue == cutPoints[minIndex - 1] && !bOpenRgt)) {
                result = -1;
            } else if (minIndex == maxIndex) {
                result = minIndex;
            } else {
                int first = minIndex;
                int last = maxIndex - 1;
                int middle = 0;
                double aMiddle = 0.0;
                int adjustment = 0;
                if (bOpenRgt) {
                    adjustment = 1;
                }
                while (first <= last) {
                    middle = (first + last) / 2;
                    aMiddle = cutPoints[middle];
                    if (theValue == aMiddle) {
                        result = middle + adjustment;
                        break;
                    }
                    if (theValue < aMiddle) {
                        last = middle - 1;
                        continue;
                    }
                    first = middle + 1;
                }
                if (result == -2) {
                    result = theValue < aMiddle ? middle : middle + 1;
                }
            }
        }
        return result;
    }

    public static int binSearch(int[] cutPoints, int minIndex, int maxIndex, int theValue, boolean bOpenRgt) {
        boolean bArgOK;
        int result = -2;
        boolean bl = bArgOK = maxIndex < cutPoints.length && minIndex <= maxIndex;
        if (bArgOK) {
            if (theValue > cutPoints[maxIndex] || theValue == cutPoints[maxIndex] && bOpenRgt) {
                result = -1;
            } else if (minIndex > 0 && (cutPoints[minIndex - 1] > theValue || theValue == cutPoints[minIndex - 1] && !bOpenRgt)) {
                result = -1;
            } else if (minIndex == maxIndex) {
                result = minIndex;
            } else {
                int first = minIndex;
                int last = maxIndex - 1;
                int middle = 0;
                int aMiddle = 0;
                int adjustment = 0;
                if (bOpenRgt) {
                    adjustment = 1;
                }
                while (first <= last) {
                    middle = (first + last) / 2;
                    aMiddle = cutPoints[middle];
                    if (theValue == aMiddle) {
                        result = middle + adjustment;
                        break;
                    }
                    if (theValue < aMiddle) {
                        last = middle - 1;
                        continue;
                    }
                    first = middle + 1;
                }
                if (result == -2) {
                    result = theValue < aMiddle ? middle : middle + 1;
                }
            }
        }
        return result;
    }

    public static double dASum(int n, double[] x, int inc, int offset) {
        double result = 0.0;
        int xSize = x.length;
        if (n > 0 && xSize > 0) {
            int index = offset;
            if (inc < 0) {
                index -= (n - 1) * inc;
            }
            for (int i = 0; i < n; ++i) {
                if (index >= 0 && index < xSize) {
                    result += Math.abs(x[index]);
                }
                index += inc;
            }
        }
        return result;
    }

    public static double dASum(int n, double[] x, int inc) {
        return MathFun.dASum(n, x, inc, 0);
    }

    public static void daxpy(int n, double alpha, double[] x, int ixx, int incx, double[] y, int ixy, int incy) {
        block25: {
            if (n <= 0 || alpha == 0.0) break block25;
            if (incx == incy && incx > 0) {
                if (Math.abs(alpha) != 1.0) {
                    for (int i = 0; i <= (n - 1) * incx; i += incx) {
                        int n2 = ixy + i;
                        y[n2] = y[n2] + alpha * x[ixx + i];
                    }
                } else if (alpha != 1.0) {
                    for (int i = 0; i <= (n - 1) * incx; i += incx) {
                        int n3 = ixy + i;
                        y[n3] = y[n3] - x[ixx + i];
                    }
                } else {
                    for (int i = 0; i <= (n - 1) * incx; i += incx) {
                        int n4 = ixy + i;
                        y[n4] = y[n4] + x[ixx + i];
                    }
                }
            } else {
                int iy = incy >= 0 ? 0 : -(n - 1) * incy;
                if (incx > 0) {
                    if (Math.abs(alpha) != 1.0) {
                        for (int ix = 0; ix <= (n - 1) * incx; ix += incx) {
                            int n5 = ixy + iy;
                            y[n5] = y[n5] + alpha * x[ixx + ix];
                            iy += incy;
                        }
                    } else if (alpha != 1.0) {
                        for (int ix = 0; ix <= (n - 1) * incx; ix += incx) {
                            int n6 = ixy + iy;
                            y[n6] = y[n6] - x[ixx + ix];
                            iy += incy;
                        }
                    } else {
                        for (int ix = 0; ix <= (n - 1) * incx; ix += incx) {
                            int n7 = ixy + iy;
                            y[n7] = y[n7] + x[ixx + ix];
                            iy += incy;
                        }
                    }
                } else {
                    int ix = -(n - 1) * incx;
                    if (Math.abs(alpha) != 1.0) {
                        for (int i = 1; i <= n; ++i) {
                            int n8 = ixy + iy;
                            y[n8] = y[n8] + alpha * x[ixx + ix];
                            ix += incx;
                            iy += incy;
                        }
                    } else if (alpha != 1.0) {
                        for (int i = 1; i <= n; ++i) {
                            int n9 = ixy + iy;
                            y[n9] = y[n9] - x[ixx + ix];
                            ix += incx;
                            iy += incy;
                        }
                    } else {
                        for (int i = 1; i <= n; ++i) {
                            int n10 = ixy + iy;
                            y[n10] = y[n10] + x[ixx + ix];
                            ix += incx;
                            iy += incy;
                        }
                    }
                }
            }
        }
    }

    public static boolean dCopy(double[] x, double[] y) {
        boolean result = true;
        if (x.length == y.length) {
            System.arraycopy(x, 0, y, 0, x.length);
        } else {
            result = false;
        }
        return result;
    }

    public static boolean dCopyOld(double[] x, double[] y) {
        boolean result;
        int xLen = x.length;
        int yLen = y.length;
        boolean bl = result = xLen == yLen;
        if (result) {
            for (int i = 0; i < xLen; ++i) {
                y[i] = x[i];
            }
        }
        return result;
    }

    public static double dDot(int n, double[] x, int ixx, int incx, double[] y, int ixy, int incy) {
        double sum;
        block7: {
            sum = 0.0;
            if (n < 1) break block7;
            if (incx == incy && incx > 0) {
                for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                    sum += x[ixx + ix - 1] * y[ixy + ix - 1];
                }
            } else {
                int iy = incy >= 0 ? 1 : 1 - (n - 1) * incy;
                if (incx > 0) {
                    for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                        sum += x[ixx + ix - 1] * y[ixy + iy - 1];
                        iy += incy;
                    }
                } else {
                    int ix = 1 - (n - 1) * incx;
                    for (int i = 1; i <= n; ++i) {
                        sum += x[ixx + ix - 1] * y[ixy + iy - 1];
                        ix += incx;
                        iy += incy;
                    }
                }
            }
        }
        return sum;
    }

    public static double digamma(double x) {
        double p = MissingValue.getMissing();
        if (x > 1.0E-16) {
            if (x < 1.0E-5) {
                p = -0.5772156649015329 - 1.0 / x;
            } else {
                p = 1.0 / (x += 10.0) / x;
                p = (((((0.021092796092796094 * p + -0.007575757575757576) * p + 0.004166666666666667) * p + -0.003968253968253968) * p + 0.008333333333333333) * p + -0.08333333333333333) * p;
                p += Math.log(x) - 0.5 / x;
                double sum = 0.0;
                for (int i = 1; i <= 10; ++i) {
                    sum += 1.0 / (x - (double)i);
                }
                p -= sum;
            }
        }
        return p;
    }

    public static double trigamma(double x) {
        double p = MissingValue.getMissing();
        if (x > 1.0E-16) {
            if (x < 1.0E-4) {
                p = 1.0 / x / x;
            } else {
                p = 1.0 / (x += 10.0) / x;
                p = ((((((-0.2531135531135531 * p + 0.07575757575757576) * p + -0.03333333333333333) * p + 0.023809523809523808) * p + -0.03333333333333333) * p + 0.16666666666666666) * p + 1.0) / x + 0.5 * p;
                double sum = 0.0;
                for (int i = 1; i <= 10; ++i) {
                    sum += 1.0 / (x - (double)i) / (x - (double)i);
                }
                p += sum;
            }
        }
        return p;
    }

    public static double dNrm2(int n, double[] x, int ixx, int incx) {
        double norm;
        if (n > 1) {
            double scale = 0.0;
            double ssq = 1.0;
            for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                double work;
                int index = ixx + ix - 1;
                double absxi = x[index];
                if (absxi == 0.0) continue;
                if (scale < (absxi = Math.abs(absxi))) {
                    work = scale / absxi;
                    ssq = 1.0 + ssq * work * work;
                    scale = absxi;
                    continue;
                }
                work = absxi / scale;
                ssq += work * work;
            }
            norm = scale * Math.sqrt(ssq);
        } else {
            norm = n == 1 ? Math.abs(x[ixx]) : 0.0;
        }
        return norm;
    }

    public static void dScal(int n, double alpha, double[] x, int ixx, int incx) {
        block5: {
            block6: {
                if (n <= 0) break block5;
                if (Math.abs(alpha) == 1.0) break block6;
                if (alpha != 0.0) {
                    for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                        int index;
                        int n2 = index = ixx + ix - 1;
                        x[n2] = x[n2] * alpha;
                    }
                } else {
                    for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                        int index = ixx + ix - 1;
                        x[index] = 0.0;
                    }
                }
                break block5;
            }
            if (alpha == 1.0) break block5;
            for (int ix = 1; ix <= 1 + (n - 1) * incx; ix += incx) {
                int index = ixx + ix - 1;
                x[index] = -x[index];
            }
        }
    }

    public static void findTwoLargest(double[] vec, double[] large) {
        double largest = MissingValue.getMissing();
        double secLarge = MissingValue.getMissing();
        large[0] = largest;
        large[1] = secLarge;
        int vSize = vec.length;
        if (vSize != 0) {
            if (vSize == 1) {
                large[0] = largest = vec[0];
            } else {
                double cur;
                largest = vec[0];
                secLarge = vec[1];
                if (largest < secLarge) {
                    cur = largest;
                    largest = secLarge;
                    secLarge = cur;
                }
                for (int i = 2; i < vSize; ++i) {
                    cur = vec[i];
                    if (cur > largest) {
                        secLarge = largest;
                        largest = cur;
                        continue;
                    }
                    if (!(cur > secLarge)) continue;
                    secLarge = cur;
                }
                large[0] = largest;
                large[1] = secLarge;
            }
        }
    }

    public static void iIAxpy(int n, double a, double[] x, int ixx, int incx, double[] y, int ixy, int incy) {
        int ix = ixx;
        int iy = ixy;
        for (int i = 0; i < n; ++i) {
            int n2 = iy;
            y[n2] = y[n2] + a * x[ix];
            ix += incx + i;
            iy += incy + i;
        }
    }

    public static double iIDot(int n, double[] x, int ixx, int incx, double[] y, int ixy, int incy) {
        double result = 0.0;
        int ix = ixx;
        int iy = ixy;
        for (int i = 0; i < n; ++i) {
            result += x[ix] * y[iy];
            ix += incx + i;
            iy += incy + i;
        }
        return result;
    }

    public static void iIInit(int n, double dVal, double[] x, int ixx, int inc) {
        int ix = ixx;
        for (int i = 0; i < n; ++i) {
            x[ix] = dVal;
            ix += inc + i;
        }
    }

    public static void iIScal(int n, double dVal, double[] x, int ixx, int inc) {
        int ix = ixx;
        for (int i = 0; i < n; ++i) {
            int n2 = ix;
            x[n2] = x[n2] * dVal;
            ix += inc + i;
        }
    }

    public static boolean isValidDouble(double x) {
        return x >= -1.7976931348623157E308 && x <= Double.MAX_VALUE;
    }

    public static double logFactorial(int n) {
        if (n >= 0 && n < LOGFACTORIAL_PRECOMPUTED.length) {
            return LOGFACTORIAL_PRECOMPUTED[n];
        }
        if (n > 0) {
            return DistributionFunctions.dnlgam(n + 1);
        }
        return MissingValue.getMissing();
    }

    public static void lRZero(double[] vct, int ixx, int n) {
        int index = ixx;
        for (int i = 0; i < n; ++i) {
            vct[index++] = 0.0;
        }
    }

    public static boolean qLReps(double dVal, double alpha) {
        if (alpha > 0.0) {
            return Math.abs(dVal) < alpha * 2.220446049250313E-16;
        }
        return false;
    }

    public static double replaceIfSmall(double dVal, double tol) {
        return Math.abs(dVal) >= tol ? dVal : (dVal >= 0.0 ? tol : -tol);
    }

    public static double vMaxRelDiff(double[] vNew, double[] vOld, double tol) {
        double result = 0.0;
        int n = vNew.length;
        if (n > vOld.length) {
            n = vOld.length;
        }
        double incr = tol;
        if (tol < 0.0) {
            incr = -tol;
        } else if (tol == 0.0) {
            incr = 1.0E-6;
        }
        for (int i = 0; i < n; ++i) {
            double old = vOld[i];
            double relDiff = Math.abs(vNew[i] - old) / (Math.abs(old) + incr);
            if (!(relDiff > result)) continue;
            result = relDiff;
        }
        return result;
    }

    public static double vMaxRelDiff(double[] vNew, double[] vOld) {
        return MathFun.vMaxRelDiff(vNew, vOld, 0.0);
    }

    public static double vNrm1Diff(double[] x, double[] y) {
        int n = x.length;
        if (n > y.length) {
            n = y.length;
        }
        double norm = 0.0;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                double aDiff = Math.abs(x[i] - y[i]);
                if (!(aDiff > norm)) continue;
                norm = aDiff;
            }
        } else if (n == 1) {
            norm = Math.abs(x[0] - y[0]);
        }
        return norm;
    }

    public static double calcMedian(List<Double> inputs, List<Double> weights) {
        double result = MissingValue.getMissing();
        int n = inputs.size();
        if (n == weights.size()) {
            int i = 0;
            long totalWeight = 0L;
            class DoublePair {
                public double first;
                public double second;

                public DoublePair(double a, double b) {
                    this.first = a;
                    this.second = b;
                }
            }
            DoublePair[] pairInputs = new DoublePair[n];
            for (i = 0; i < n; ++i) {
                pairInputs[i] = new DoublePair(inputs.get(i), weights.get(i));
                totalWeight += (long)(weights.get(i) + 0.5);
            }
            Arrays.sort(pairInputs, new Comparator<DoublePair>(){

                @Override
                public int compare(DoublePair obj1, DoublePair obj2) {
                    return Double.compare(obj1.first, obj2.first);
                }
            });
            int medIndex1 = -1;
            int medIndex2 = -1;
            if (totalWeight % 2L == 1L) {
                medIndex1 = ((int)totalWeight + 1) / 2;
                medIndex2 = ((int)totalWeight + 1) / 2;
            } else {
                medIndex1 = (int)totalWeight / 2;
                medIndex2 = (int)totalWeight / 2 + 1;
            }
            double median1 = MissingValue.getMissing();
            double median2 = MissingValue.getMissing();
            long accumWeight = 0L;
            for (i = 0; i < n; ++i) {
                if (MissingValue.isMissing(median1) && (accumWeight += (long)pairInputs[i].second) >= (long)medIndex1) {
                    median1 = pairInputs[i].first;
                }
                if (!MissingValue.isMissing(median2) || accumWeight < (long)medIndex2) continue;
                median2 = pairInputs[i].first;
                break;
            }
            if (!MissingValue.isMissing(median1) && !MissingValue.isMissing(median2)) {
                result = (median1 + median2) / 2.0;
            }
        }
        return result;
    }

    private static boolean isZeroDiff(double d1, double d2, double coef) {
        boolean zeroDiff = false;
        double adiff = Math.abs(d1 - d2);
        zeroDiff = adiff == 0.0 ? true : (d1 == 0.0 || d2 == 0.0 ? false : adiff <= (Math.abs(d1) < Math.abs(d2) ? Math.abs(d2) : Math.abs(d1)) * 2.220446049250313E-16 * coef);
        return zeroDiff;
    }

    public static int compareDoubles(double d1, double d2, double coef) {
        int ret = 0;
        if (!MissingValue.isMissing(d1) && !MissingValue.isMissing(d2)) {
            if (MathFun.isZeroDiff(d1, d2, coef)) {
                ret = 0;
            } else if (d1 > d2) {
                ret = 1;
            } else if (d1 < d2) {
                ret = -1;
            }
        } else if (MissingValue.isMissing(d1) && MissingValue.isMissing(d2)) {
            ret = 0;
        } else if (MissingValue.isMissing(d1)) {
            ret = -1;
        } else if (MissingValue.isMissing(d2)) {
            ret = 1;
        }
        return ret;
    }

    public static int compareDoubles(double d1, double d2) {
        return MathFun.compareDoubles(d1, d2, 128.0);
    }

    public static double numberOfCombinations(int n, int k) {
        double ret = 0.0;
        if (n >= 0 && k >= 0 && k <= n) {
            double logResult = 0.0;
            int t = Math.max(k, n - k);
            int i = 0;
            for (i = t + 1; i <= n; ++i) {
                logResult += Math.log(i);
            }
            double negLogResult = 0.0;
            for (i = 2; i <= n - t; ++i) {
                negLogResult += Math.log(i);
            }
            ret = (logResult -= negLogResult) <= Math.log(Double.MAX_VALUE) ? Math.exp(logResult) : MissingValue.getMissing();
        }
        return ret;
    }

    public static int lTChol(int nRows, double[] mat, int sMat, double[] diag, int sDiag, double tol, boolean chkArg) {
        int result = 0;
        if (chkArg) {
            if (tol < 0.0) {
                result = -1;
            }
            if (result == 0) {
                for (int k = 0; k < nRows; ++k) {
                    if (!(diag[sDiag + k] < 0.0)) continue;
                    result = -1;
                    break;
                }
            }
        }
        if (result == 0) {
            int iDiag = 0;
            int iElm = 0;
            int iFst = 0;
            for (int i = 0; i < nRows; ++i) {
                double rowTol = tol * diag[sDiag + i];
                int jDiag = 0;
                int jFst = 0;
                for (int j = 0; j <= i; ++j) {
                    double valOld = mat[sMat + iElm] - MathFun.dDot(j, mat, sMat + iFst, 1, mat, sMat + jFst, 1);
                    if (j != i) {
                        double valNew = mat[sMat + jDiag];
                        if (valNew != 0.0) {
                            valNew = valOld / valNew;
                        }
                        mat[sMat + iElm] = valNew;
                    } else {
                        if (valOld > rowTol) {
                            valOld = Math.sqrt(valOld);
                        } else {
                            valOld = 0.0;
                            ++result;
                        }
                        mat[sMat + iDiag] = valOld;
                    }
                    ++iElm;
                    jFst = jDiag + 1;
                    jDiag += j + 2;
                }
                iFst = iDiag + 1;
                iDiag += i + 2;
            }
        }
        return result;
    }

    public static int lTDetInverse(int nRows, double[] mat, int sMat, double[] det, int job) {
        int result = 0;
        int nZero = 0;
        int iDiag = 0;
        if (det.length < 2 || job != 1 && job != 10 && job != 11) {
            result = -1;
        }
        if (result == 0) {
            int i;
            for (i = 1; i <= nRows; ++i) {
                if (mat[sMat + ++iDiag - 1] != 0.0) continue;
                ++nZero;
            }
            if (job == 1 || job == 11) {
                if (nZero == 0) {
                    det[0] = 1.0;
                    det[1] = 0.0;
                    iDiag = 0;
                    for (i = 1; i <= nRows; ++i) {
                        det[0] = mat[sMat + (iDiag += i) - 1] * det[0];
                        while (Math.abs(det[0]) < 1.0) {
                            det[0] = det[0] * 10.0;
                            det[1] = det[1] - 1.0;
                        }
                        while (Math.abs(det[0]) >= 10.0) {
                            det[0] = det[0] / 10.0;
                            det[1] = det[1] + 1.0;
                        }
                    }
                } else {
                    det[0] = 0.0;
                    det[1] = 0.0;
                }
            }
            if (job == 10 || job == 11) {
                iDiag = nRows * (nRows + 1) / 2;
                for (i = nRows; i >= 1; --i) {
                    double temp = mat[sMat + iDiag - 1];
                    if (temp == 0.0) {
                        MathFun.iIInit(nRows - i + 1, 0.0, mat, sMat + iDiag - 1, i);
                        MathFun.lRZero(mat, sMat + iDiag - i, i);
                    } else {
                        mat[sMat + iDiag - 1] = temp = 1.0 / temp;
                        temp = -temp;
                        MathFun.iIScal(nRows - i, temp, mat, sMat + iDiag + i - 1, i + 1);
                        for (int j = 1; j <= i - 1; ++j) {
                            temp = mat[sMat + iDiag - i + j - 1];
                            mat[sMat + iDiag - i + j - 1] = 0.0;
                            MathFun.iIAxpy(nRows - i + 1, temp, mat, sMat + iDiag - 1, i, mat, sMat + iDiag - i + j - 1, i);
                        }
                    }
                    iDiag -= i;
                }
            }
            result = nZero;
        }
        return result;
    }

    public static void lTLTransL(int nRows, double[] mat, int sMat) {
        int jDiag = 0;
        for (int j = 1; j <= nRows; ++j) {
            int iDiag = jDiag += j;
            int ij = jDiag;
            for (int i = j; i <= nRows; ++i) {
                mat[sMat + ij - 1] = MathFun.iIDot(nRows - i + 1, mat, sMat + iDiag - 1, i, mat, sMat + ij - 1, i);
                ij += i;
                iDiag = iDiag + i + 1;
            }
        }
    }

    public static int cholInverse(int nRows, double[] mat, int sMat, double[] diag, int sDiag, double tol, double[] inv, int sInv) {
        int result = -1;
        int nElem = nRows * (nRows + 1) / 2;
        for (int i = 0; i < nElem; ++i) {
            inv[sInv + i] = mat[sMat + i];
        }
        result = MathFun.lTChol(nRows, inv, sInv, diag, sDiag, tol, false);
        if (result >= 0) {
            result = nRows - result;
            int job = 10;
            double[] det = new double[2];
            MathFun.lTDetInverse(nRows, inv, sInv, det, job);
            MathFun.lTLTransL(nRows, inv, sInv);
        }
        return result;
    }

    public static void computeSV(int nRows, double[] mat, int sMat, double[] inpVec, int sInpVec, double[] outVec, int sOutVec) {
        int iFirst = 0;
        for (int i = 0; i < nRows; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j <= i; ++j) {
                sum += mat[sMat + iFirst + j] * inpVec[sInpVec + j];
            }
            int xSym = iFirst + i;
            int shift = i + 1;
            for (j = i + 1; j < nRows; ++j) {
                sum += mat[sMat + (xSym += shift++)] * inpVec[sInpVec + j];
            }
            iFirst += i + 1;
            outVec[sOutVec + i] = sum;
        }
    }

    public static void dVecIncr(int n, double[] y, int ixy, double[] x, int ixx) {
        for (int i = 0; i < n; ++i) {
            int n2 = ixy + i;
            y[n2] = y[n2] + x[ixx + i];
        }
    }

    public static void dVecDecr(int n, double[] y, int ixy, double[] x, int ixx) {
        for (int i = 0; i < n; ++i) {
            int n2 = ixy + i;
            y[n2] = y[n2] - x[ixx + i];
        }
    }

    public static double dMaxAbs(int n, double[] x, int off) {
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result = Math.max(result, Math.abs(x[off + i]));
        }
        return result;
    }

    public static void dVecAdd(int n, double[] z, int ixz, double[] x, int ixx, double[] y, int ixy, double coef) {
        for (int i = 0; i < n; ++i) {
            z[ixz + i] = x[ixx + i] + coef * y[ixy + i];
        }
    }

    public static void dVecCopy(int n, double[] vFrom, int fromStart, int fromIncr, double[] vTo, int toStart, int toIncr) {
        if (fromIncr == 1 && toIncr == 1) {
            System.arraycopy(vFrom, fromStart, vTo, toStart, n);
        } else {
            int fromCur = fromStart;
            int toCur = toStart;
            for (int i = 0; i < n; ++i) {
                vTo[toCur] = vFrom[fromCur];
                fromCur += fromIncr;
                toCur += toIncr;
            }
        }
    }

    public static boolean dVecEqual(int n, double[] v1, int start1, double[] v2, int start2) {
        boolean result = true;
        for (int i = 0; i < n; ++i) {
            if (v1[start1 + i] == v2[start2 + i]) continue;
            result = false;
            break;
        }
        return result;
    }

    public static double dSumOfSquaredDiff(int n, double[] v1, int start1, double[] v2, int start2) {
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            double diff = v1[start1 + i] - v2[start2 + i];
            result += diff * diff;
        }
        return result;
    }

    public static double modelParamsCovar(double h, double sigmaSq, double theta, double tauSq, double p) {
        double result = 0.0;
        if (h == 0.0) {
            result = sigmaSq + tauSq;
        } else {
            double hOverTheta = h / theta;
            result = p == 1.0 ? sigmaSq * Math.exp(-hOverTheta) : (p == 2.0 ? sigmaSq * Math.exp(-hOverTheta * hOverTheta) : sigmaSq * Math.exp(-Power.pow(hOverTheta, p)));
        }
        return result;
    }
}

