/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics;

import com.spss.math.MissingValue;

public class Power {
    public static final double MIN_EXP = -744.44;
    public static final double MAX_EXP = 709.78;
    public static final double MACHINE_EPSILON = 2.22E-16;
    private static final double USE_MULTIPLICATION = 50.0;

    private Power() {
    }

    public static double pow(double baseArg, double powArg) {
        double result = MissingValue.getMissing();
        result = Math.abs(powArg) < 50.0 && Power.isInteger(powArg) ? Power.pow(baseArg, (int)powArg) : (baseArg < 0.0 && Power.isOneOverOddInteger(powArg) ? -Math.pow(-baseArg, powArg) : Math.pow(baseArg, powArg));
        return result;
    }

    public static double pow(double baseArg, int powArg) {
        double result = MissingValue.getMissing();
        int apowArg = Math.abs(powArg);
        if ((double)apowArg < 50.0) {
            result = 1.0;
            for (int i = 0; i < apowArg; ++i) {
                result *= baseArg;
            }
            if ((double)powArg < 0.0) {
                result = 1.0 / result;
            }
        } else {
            result = Math.pow(baseArg, powArg);
        }
        return result;
    }

    public static boolean almostEqual(double x, double y, double c) {
        boolean result = false;
        if (x == 0.0 && y == 0.0) {
            result = true;
        } else if (x == 0.0 || y == 0.0) {
            result = false;
        } else if (x > 0.0 && y < 0.0) {
            result = false;
        } else if (x < 0.0 && y > 0.0) {
            result = false;
        } else {
            double ax = Math.abs(x);
            double ay = Math.abs(y);
            double dMax = ax;
            double diff = ax - ay;
            if (diff < 0.0) {
                dMax = ay;
                diff = -diff;
            }
            result = diff / dMax <= c * 2.22E-16;
        }
        return result;
    }

    public static boolean isInteger(double value) {
        return Math.floor(value) == value;
    }

    public static boolean isEvenInteger(double dArg) {
        return Power.isInteger(dArg) && Math.floor(dArg / 2.0) == dArg / 2.0;
    }

    public static boolean isOddInteger(double dArg) {
        return Power.isInteger(dArg) && Math.floor(dArg / 2.0 + 0.5) == dArg / 2.0 + 0.5;
    }

    public static boolean isOneOverOddInteger(double value, double coef) {
        boolean result = false;
        if (value != 0.0) {
            double oneOver = 1.0 / value;
            double x = oneOver / 2.0 + 0.5;
            double y = Math.floor(x + 0.5);
            result = Power.almostEqual(x, y, coef);
        }
        return result;
    }

    public static boolean isOneOverOddInteger(double value) {
        return Power.isOneOverOddInteger(value, 32.0);
    }

    public static boolean isOneOverEvenInteger(double dArg, double coef) {
        boolean result = false;
        if (dArg != 0.0) {
            double oneOver = 1.0 / dArg;
            double x = oneOver / 2.0;
            double y = Math.floor(x + 0.5);
            result = Power.almostEqual(x, y, coef);
        }
        return result;
    }

    public static boolean isOneOverEvenInteger(double dArg) {
        return Power.isOneOverEvenInteger(dArg, 32.0);
    }

    public static double getMinEps() {
        return -744.44;
    }

    public static double getMaxEps() {
        return 709.78;
    }
}

