/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.statistics.probability;

import com.spss.math.statistics.probability.CdfConstants;
import com.spss.math.statistics.probability.CumulateStdNormalFunc;
import com.spss.math.statistics.probability.NaturalLogFunc;

public class BetaFunc
implements CdfConstants {
    private final int POWER_SERIES = 1;
    private final int CONTINUED_FRACTION = 2;
    private final int NORMAL_APPROXIMATION = 3;

    public double apply(double betaVar, double param1, double param2) {
        double temp1;
        double expArg;
        int maxItemNum = 10000;
        double sum = 0.0;
        boolean isQuoteCdf = true;
        boolean isConverge = false;
        boolean isContinue = true;
        double result = 0.0;
        int methodType = 3;
        double complement = 1.0 - betaVar;
        double paramSum = param1 + param2;
        if (param1 > 0.0 && param2 > 0.0) {
            isContinue = false;
            if (betaVar <= 0.0) {
                result = 0.0;
            } else if (complement <= 0.0) {
                result = 1.0;
            } else {
                isContinue = true;
            }
        } else {
            isContinue = false;
            result = -1.7976931348623157E308;
        }
        if (isContinue) {
            isContinue = false;
            if (param1 == 1.0) {
                result = param2 == 1.0 ? betaVar : ((expArg = param2 * Math.log(complement)) < -708.0 ? 1.0 : 1.0 - Math.exp(expArg));
            } else if (param2 == 1.0) {
                expArg = param1 * Math.log(betaVar);
                result = expArg < -708.0 ? 0.0 : Math.exp(expArg);
            } else {
                isContinue = true;
            }
        }
        if (isContinue && param1 == param2) {
            if (betaVar == 0.5) {
                result = 0.5;
            } else if (param1 == 0.5) {
                result = 2.0 * (Math.asin(Math.sqrt(betaVar)) / Math.PI);
            } else {
                isContinue = true;
            }
        }
        if (isContinue) {
            int i;
            double temp2;
            double term;
            methodType = param1 <= 1.0 || param2 <= 1.0 ? 1 : 2;
            if (methodType == 1) {
                if (param1 <= 1.0) {
                    isQuoteCdf = !isQuoteCdf;
                    temp1 = betaVar;
                    betaVar = complement;
                    complement = temp1;
                    temp1 = param1;
                    param1 = param2;
                    param2 = temp1;
                }
                isConverge = false;
                term = 1.0;
                sum = 1.0;
                temp1 = paramSum;
                temp2 = param1 + 1.0;
                for (i = 0; i <= maxItemNum; ++i) {
                    term = (temp1 + (double)i) / (temp2 + (double)i) * betaVar * term;
                    sum += term;
                    if (!(Math.abs(term) < 1.0E-15)) continue;
                    isConverge = true;
                    break;
                }
                if (!isConverge) {
                    methodType = 2;
                }
            }
            if (methodType == 2) {
                temp1 = (param1 + 1.0) / (paramSum + 2.0);
                if (betaVar >= temp1) {
                    isQuoteCdf = !isQuoteCdf;
                    temp1 = betaVar;
                    betaVar = complement;
                    complement = temp1;
                    temp1 = param1;
                    param1 = param2;
                    param2 = temp1;
                }
                isConverge = false;
                term = -betaVar * (paramSum / (param1 + 1.0));
                double coeffCj2 = 1.0;
                double coeffCj1 = 1.0;
                double coeffDj2 = 1.0;
                double coeffDj1 = 1.0 + term;
                sum = coeffCj1 / coeffDj1;
                for (i = 1; i <= maxItemNum; ++i) {
                    temp1 = param1 + (double)i;
                    temp2 = temp1 + (double)i;
                    term = betaVar * ((double)i / temp2) * ((param2 - (double)i) / (temp2 - 1.0));
                    double coeffCj = coeffCj1 + term * coeffCj2;
                    double coeffDj = coeffDj1 + term * coeffDj2;
                    coeffCj2 = coeffCj1;
                    coeffDj2 = coeffDj1;
                    coeffCj1 = coeffCj;
                    coeffDj1 = coeffDj;
                    term = -betaVar * (temp1 / temp2) * ((temp1 + param2) / (temp2 + 1.0));
                    coeffCj = coeffCj1 + term * coeffCj2;
                    coeffDj = coeffDj1 + term * coeffDj2;
                    if (coeffDj == 0.0) {
                        coeffCj2 = coeffCj1;
                        coeffDj2 = coeffDj1;
                        coeffCj1 = coeffCj;
                        coeffDj1 = coeffDj;
                        continue;
                    }
                    coeffCj2 = coeffCj1 / coeffDj;
                    coeffDj2 = coeffDj1 / coeffDj;
                    coeffCj1 = coeffCj / coeffDj;
                    coeffDj1 = 1.0;
                    sum = coeffCj1;
                    double sumTemp = sum;
                    if (!(Math.abs(sum - sumTemp) < 1.0E-15)) continue;
                    isConverge = true;
                    break;
                }
                if (!isConverge) {
                    methodType = 3;
                }
            }
        }
        if (isContinue && methodType != 3) {
            result = sum > 0.0 ? ((expArg = param1 * Math.log(betaVar) + param2 * Math.log(complement) + Math.log(sum) + (new NaturalLogFunc().apply(paramSum) - new NaturalLogFunc().apply(param1 + 1.0) - new NaturalLogFunc().apply(param2))) < -708.0 ? 0.0 : Math.exp(expArg)) : 0.0;
            if (!isQuoteCdf) {
                result = 1.0 - result;
            }
        }
        if (isContinue && methodType == 3) {
            double zScore = 0.0;
            double paramSumm1 = paramSum - 1.0;
            zScore = betaVar * this.betaAuxillaryFunc((param1 - 0.5) / paramSumm1) + complement * this.betaAuxillaryFunc((param2 - 0.5) / paramSumm1) + 1.0;
            if ((zScore /= (paramSumm1 + 0.16666666666666666) * betaVar * complement) > 0.0) {
                temp1 = (1.0 + betaVar) / 3.0 + paramSumm1 * (betaVar - param1 / paramSumm1) + (betaVar / param2 - complement / param1 + (betaVar - 0.5) / paramSum) / 50.0;
                zScore = temp1 * Math.sqrt(zScore);
            } else {
                zScore = 0.0;
            }
            if (!isQuoteCdf) {
                zScore = -zScore;
            }
            result = new CumulateStdNormalFunc().apply(zScore);
        }
        return result;
    }

    private double betaAuxillaryFunc(double value) {
        double temp;
        double result = value > 0.0 ? (value <= MAX_SQUARE_ROOT ? ((temp = 1.0 - value) == 0.0 ? 0.0 : (1.0 - Math.pow(value, 2.0) + 2.0 * value * Math.log(value)) / Math.pow(temp, 2.0)) : -1.0) : (value == 0.0 ? 1.0 : -1.7976931348623157E308);
        return result;
    }
}

