/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.ibm.bi.json.validation.JsonSchemaValidationException;
import com.ibm.bi.json.validation.PatternDigester;
import com.ibm.bi.json.validation.PatternKeywordValidator;
import com.ibm.bi.json.validation.PatternSyntaxChecker;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSchemaValidator.class);

    public boolean validate(String jsonSchemaStr, String jsonDataStr) throws JsonSchemaValidationException {
        ProcessingReport report = null;
        try {
            JsonSchemaFactory factory = this.getJsonSchemaFactory();
            JsonNode jsonSchema = JsonLoader.fromString((String)jsonSchemaStr);
            JsonNode data = JsonLoader.fromString((String)jsonDataStr);
            JsonSchema schema = factory.getJsonSchema(jsonSchema);
            report = schema.validate(data);
        }
        catch (ProcessingException | JsonSchemaValidationException | IOException e) {
            LOGGER.warn(e.getMessage());
            throw new JsonSchemaValidationException(e.getMessage(), e);
        }
        if (report != null && !report.isSuccess()) {
            String message = this.convertProcessingReport(report);
            throw new JsonSchemaValidationException(message);
        }
        return true;
    }

    private String convertProcessingReport(ProcessingReport report) {
        String result = "";
        if (report != null) {
            ListProcessingReport listReport = new ListProcessingReport();
            for (ProcessingMessage msg : report) {
                listReport.log(report.getLogLevel(), msg);
                result = result + msg.asException().getMessage();
            }
        }
        return result;
    }

    private JsonSchemaFactory getJsonSchemaFactory() throws JsonSchemaValidationException {
        try {
            Keyword[] keywords = this.getKeywords();
            return this.buildJsonSchemaFactory(keywords);
        }
        catch (Exception e) {
            throw new JsonSchemaValidationException(e);
        }
    }

    protected Keyword[] getKeywords() {
        ArrayList<Keyword> list = new ArrayList<Keyword>();
        Keyword pattern = Keyword.newBuilder((String)"pattern").withSyntaxChecker((SyntaxChecker)new PatternSyntaxChecker()).withDigester((Digester)new PatternDigester()).withValidatorClass(PatternKeywordValidator.class).freeze();
        list.add(pattern);
        Keyword[] keywords = new Keyword[list.size()];
        list.toArray(keywords);
        return keywords;
    }

    private JsonSchemaFactory buildJsonSchemaFactory(Keyword[] keywords) {
        Library library = null;
        for (Keyword keyword : keywords) {
            library = DraftV4Library.get().thaw().addKeyword(keyword).freeze();
        }
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://www.ibm.com/cognos#", library).setValidationMessages(bundle).freeze();
        return JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
    }
}

