/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternKeywordValidator
extends AbstractKeywordValidator {
    public static final String JSON_SCHEMA_KEYWORD_PATTERN = "pattern";

    public PatternKeywordValidator(JsonNode digest) {
        super(JSON_SCHEMA_KEYWORD_PATTERN);
    }

    public String toString() {
        return this.keyword;
    }

    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String regex = data.getSchema().getNode().get(this.keyword).textValue();
        String value = data.getInstance().getNode().textValue();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(value);
        if (!m.matches()) {
            report.error(this.newMsg(data, bundle, "err.common.pattern.noMatch").putArgument("regex", (Object)regex).putArgument("string", (Object)value));
        }
    }
}

