/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json.validation;

import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternSyntaxChecker.class);

    public PatternSyntaxChecker() {
        super("pattern", NodeType.STRING, new NodeType[0]);
    }

    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String regex = this.getNode(tree).asText();
        if (!this.isValidRegex(regex)) {
            report.error(this.newMsg(tree, bundle, "err.format.invalidRegex").putArgument("value", (Object)regex));
        }
    }

    private boolean isValidRegex(String regex) {
        boolean isValid = true;
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            isValid = false;
        }
        return isValid;
    }
}

