/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.cfgprovider;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfigurationProvider;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringProperty;
import java.io.File;

public class TitanConfigAPIConfigurationProvider
implements JCAMCryptoConfigurationProvider {
    private static final String CAM_KEYSTORE_FILENAME = "CAMKeystore";
    private static final String KEYSTORE_DEFAULT_NAME = "jCSKKeystore";
    private static final String KEYSTORE_DEFAULT_NAME_P12 = "CSKKeystore.p12";
    private DynamicStringProperty camKeyStoreFile = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider.Cognos.certificateLocation");
    private DynamicStringProperty keystoreFilePassword = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider.Cognos.keystoreFilePassword");
    private DynamicBooleanProperty sslConfidentiality = ConfigurationPropertyFactory.getInstance().getBooleanProperty("CRYPTO.SSLConfidentiality", true);
    private DynamicStringProperty sslProtocols = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.SSLProtocols");
    private DynamicStringProperty cryptoCiphersuite = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider.Cognos.cognosCryptoCiphersuite");
    private DynamicStringProperty cskPath = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.CSKPath");
    private DynamicStringProperty cskPathPassword = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.CSKPathPassword");
    private DynamicStringProperty internalDispatcher = ConfigurationPropertyFactory.getInstance().getStringProperty("internalDispatcher");
    private DynamicStringProperty externalDispatcher = ConfigurationPropertyFactory.getInstance().getStringProperty("externalDispatcher");
    private DynamicStringProperty cryptoProvider = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider", "Cognos");
    private DynamicStringProperty jvmTrustStorePassword = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.JVMTrustStorePassword");
    private DynamicStringProperty confidentialityAlgorithm = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider.Cognos.cognosCryptoConfidentialityAlgorithm");
    private DynamicStringProperty digestAlgorithm = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.digestAlgorithm");
    private DynamicStringProperty pdfEncryptionAlgorithm = ConfigurationPropertyFactory.getInstance().getStringProperty("CRYPTO.cryptoProvider.Cognos.cognosPDFConfidentialityAlgorithm");
    private DynamicStringProperty tempFileLocation = ConfigurationPropertyFactory.getInstance().getStringProperty("temp");
    private DynamicBooleanProperty useMutualAuthentication = ConfigurationPropertyFactory.getInstance().getBooleanProperty("CRYPTO.SSLMutualAuthentication", false);

    public String getCamKeystoreFile() {
        return this.camKeyStoreFile.getValue() + "/" + CAM_KEYSTORE_FILENAME + ".jks";
    }

    public String getCamKeystorePwdCiphertext() {
        return this.keystoreFilePassword.getValue();
    }

    public String getCamKeystorePwdPlaintext() {
        return null;
    }

    public boolean getSSLConfidentiality() {
        return this.sslConfidentiality.get();
    }

    public String[] getJSSECiphersuites() {
        return null;
    }

    public String getCognosCryptoCiphersuite() {
        return this.cryptoCiphersuite.get();
    }

    public String[] getSSLProtocols() {
        return this.sslProtocols.get().replaceAll("\\s", "").split(",");
    }

    public String getCSKPath() {
        return this.cskPath.getValue() + File.separator + KEYSTORE_DEFAULT_NAME;
    }

    public String getCSKPathPassword() {
        return this.cskPathPassword.getValue();
    }

    public String getInternalDispatcher() {
        return this.internalDispatcher.get();
    }

    public String getExternalDispatcher() {
        return this.externalDispatcher.get();
    }

    public String getCSKPathP12() {
        return this.cskPath.getValue() + File.separator + KEYSTORE_DEFAULT_NAME_P12;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider.getValue();
    }

    public String getJVMTrustStorePassword() {
        return this.jvmTrustStorePassword.getValue();
    }

    public String getConfidentialityAlgorithm() {
        return this.confidentialityAlgorithm.getValue();
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm.getValue();
    }

    public String getHMACAlgorithm() {
        return "Hmac" + this.getDigestAlgorithm().replace("SHA-", "SHA");
    }

    public String getPDFEncryptionAlgorithm() {
        return this.pdfEncryptionAlgorithm.getValue();
    }

    public String getTempFileLocation() {
        return this.tempFileLocation.getValue();
    }

    public boolean useMutualAuthentication() {
        return this.useMutualAuthentication.getValue();
    }
}

