/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.JsonFactory;
import com.ibm.bi.json.JsonParser;
import java.io.IOException;
import java.util.Map;

public class JsonLaxParser
extends JsonParser {
    public JsonLaxParser() {
    }

    public JsonLaxParser(JsonFactory factory) {
        super(factory);
    }

    @Override
    protected Object parseAny() throws IOException {
        char ch = this.buf[this.off];
        switch (ch) {
            case '{': {
                return this.parseObject();
            }
            case '[': {
                return this.parseArray();
            }
            case '\"': {
                return this.parseString('\"');
            }
            case '\'': {
                return this.parseString('\'');
            }
        }
        if (ch == '-' || ch >= '0' && ch <= '9') {
            return this.parseNumber();
        }
        if (Character.isJavaIdentifierStart(ch)) {
            return this.parseWord();
        }
        this.throwUnexpectedCharacter(ch);
        return null;
    }

    private Object parseWord() throws IOException {
        String value;
        StringBuilder b = new StringBuilder();
        int start = this.off;
        while (Character.isJavaIdentifierPart(this.buf[this.off++])) {
            if (this.off < this.limit) continue;
            if (start != this.off) {
                b.append(this.buf, start, this.off - start);
            }
            this.off = 0;
            start = 0;
            this.limit = this.in.read(this.buf, 0, this.buf.length);
            if (this.limit != -1) continue;
        }
        if (start < this.off) {
            b.append(this.buf, start, this.off - start - 1);
        }
        if (this.limit != -1) {
            --this.off;
        }
        if ("true".equals(value = b.toString())) {
            return this.factory.createBoolean(true);
        }
        if ("false".equals(value)) {
            return this.factory.createBoolean(false);
        }
        if ("null".equals(value)) {
            return this.factory.createNull();
        }
        return this.factory.createString(value);
    }

    @Override
    protected Object parseObject() throws IOException {
        Map map = this.factory.createObject();
        char ch = this.nextToken();
        if (ch == '}') {
            ++this.off;
            return map;
        }
        while (true) {
            Object key;
            if (!this.factory.isString(key = this.parseAny())) {
                this.throwUnexpectedCharacter(ch);
            }
            --this.off;
            this.expect(':');
            this.nextToken();
            Object value = this.parseAny();
            map.put(key, value);
            --this.off;
            if (this.expect('}', ',') == '}') {
                ++this.off;
                return map;
            }
            this.nextToken();
        }
    }
}

