/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.CAFLibraryException;
import com.cognos.caf.CAFLibraryPrivateException;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFValidationException;
import com.cognos.caf.ext.CAFExtConfigurationException;
import com.cognos.caf.ext.CAFExtRuntimeException;
import com.cognos.caf.logging.CAFLog;
import java.io.IOException;

public class CAFExceptionUtilities {
    private static Exception m_firstException = null;

    public static synchronized Exception getFirstException() {
        return m_firstException;
    }

    private static void log(CAFException cafEx) throws CAFException {
        CAFLog.error("CAF engine error occurred", "statutes", cafEx.getIntStatusList(), "exception trace information", "\r\n" + cafEx.getTraceInformation());
    }

    private static synchronized CAFFirewallException _handleException(Exception e, int cafFirewallExceptionStatus) throws CAFException {
        CAFFirewallException cafEx = new CAFFirewallException(e, cafFirewallExceptionStatus);
        CAFExceptionUtilities.log(cafEx);
        if (m_firstException == null) {
            m_firstException = cafEx;
        }
        return cafEx;
    }

    public static void handleException(Exception e, int cafFirewallExceptionStatus) throws CAFExtRuntimeException {
        CAFExtRuntimeException rtException = null;
        try {
            if (e instanceof CAFValidationException) {
                rtException = new CAFExtRuntimeException(1);
            } else {
                CAFFirewallException cafEx = CAFExceptionUtilities._handleException(e, cafFirewallExceptionStatus);
                rtException = new CAFExtRuntimeException(cafEx, 0);
            }
        }
        catch (Exception e2) {
            CAFFirewallException cafEx = new CAFFirewallException(e2, 18);
            throw new CAFExtRuntimeException(cafEx, 0);
        }
        throw rtException;
    }

    public static void handleConfigException(Exception e, int cafFirewallExceptionStatus) throws CAFExtConfigurationException {
        CAFExtConfigurationException configException = null;
        try {
            CAFFirewallException cafEx = CAFExceptionUtilities._handleException(e, cafFirewallExceptionStatus);
            configException = new CAFExtConfigurationException(cafEx);
        }
        catch (Exception e2) {
            CAFFirewallException cafEx = new CAFFirewallException(e2, 19);
            throw new CAFExtConfigurationException(cafEx);
        }
        throw configException;
    }

    public static IOException handleIOException(Exception e, int cafFirewallExceptionStatus) throws IOException {
        IOException ioException = null;
        try {
            CAFFirewallException cafEx = CAFExceptionUtilities._handleException(e, cafFirewallExceptionStatus);
            ioException = new IOException(cafEx.getIntStatusList());
        }
        catch (Exception e2) {
            CAFFirewallException cafEx = new CAFFirewallException(e2, 20);
            throw new IOException(cafEx.getIntStatusList());
        }
        throw ioException;
    }

    public static void handleLibraryException(CAFException cafEx, int CAFLibraryPrivateExceptionStatus, boolean log) throws CAFLibraryException {
        CAFLibraryException libraryException = null;
        try {
            CAFLibraryPrivateException resEx = new CAFLibraryPrivateException(cafEx, CAFLibraryPrivateExceptionStatus);
            if (log || CAFLog.isTracingEnabled) {
                CAFExceptionUtilities.log(resEx);
            }
            libraryException = new CAFLibraryException(resEx);
        }
        catch (Exception e) {
            throw new CAFLibraryException(new CAFFirewallException(e, 48));
        }
        throw libraryException;
    }
}

