/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.rule.CAFPattern;
import java.util.HashMap;
import java.util.regex.Pattern;

public class CAFPatternCache {
    private static HashMap m_compiledPatterns = new HashMap();
    private static HashMap<String, String> m_namedPatterns = new HashMap();

    public static void precompile(String pattern) throws CAFException {
        CAFPatternCache._getPattern(pattern);
    }

    public static void addNamedPattern(CAFPattern cafPattern) throws CAFException {
        m_namedPatterns.put(cafPattern.m_name, cafPattern.m_value);
        CAFPatternCache.precompile(cafPattern.m_value);
    }

    public static String getNamedPattern(String name) {
        return m_namedPatterns.get(name);
    }

    public static boolean matchByPatternName(String input, String patternName) throws CAFException {
        String pattern = m_namedPatterns.get(patternName);
        if (pattern == null) {
            CAFLog.error("invalid pattern name", "pattern name", patternName, "input", input);
            throw new CAFFirewallException(57);
        }
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("matchByPatternName input= " + input + " with patternName=" + patternName + " and pattern=" + pattern, 30000);
        }
        return CAFPatternCache.match(input, pattern);
    }

    private static Pattern _getPattern(String pattern) throws CAFException {
        Pattern cPattern = (Pattern)m_compiledPatterns.get(pattern);
        if (cPattern == null) {
            cPattern = Pattern.compile(pattern);
            m_compiledPatterns.put(pattern, cPattern);
        }
        return cPattern;
    }

    public static boolean match(String input, String pattern) throws CAFException {
        Pattern p = CAFPatternCache._getPattern(pattern);
        return p.matcher(input).lookingAt();
    }

    public static boolean find(String input, String pattern) throws CAFException {
        Pattern p = CAFPatternCache._getPattern(pattern);
        return p.matcher(input).find();
    }

    public static String substitute(String input, String pattern, String subStr) throws CAFException {
        Pattern p = CAFPatternCache._getPattern(pattern);
        return p.matcher(input).replaceAll(subStr);
    }
}

