/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.CAFActionHandlerData;
import com.cognos.caf.CAFFactoryImpl;
import com.cognos.caf.CAFIActionHandler;
import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFMessageStrings;
import com.cognos.caf.CAFProtectorException;
import com.cognos.caf.CAFTagBlock;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.cache.CAFHmacCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFGlobals;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFWeb64;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class CAFProtector
implements CAFIActionHandler {
    static CAFProtector m_instance = new CAFProtector();
    private static int m_substituteCounter = 0;
    private static final byte[] m_HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    public static byte[] m_XSSCharsTable = new byte[256];
    public static byte[] m_tpXSSChars = null;
    private static final String JS_CAF_TP_XSS_CHECKING_USED = "caf_tpXSSCheckingUsed = ";
    private static final String JS_CAF_TP_XSS_CHARS = "caf_tpXSSChars = \"";

    private static synchronized int nextCount() {
        return ++m_substituteCounter;
    }

    public static void initialize() throws CAFException {
        block5: {
            try {
                m_tpXSSChars = CAFConfig.m_tpXSSChars.getBytes("UTF-8");
                if (m_tpXSSChars.length <= 256) {
                    for (int i = 0; i < 256; ++i) {
                        CAFProtector.m_XSSCharsTable[i] = 0;
                    }
                    for (int j = 0; j < m_tpXSSChars.length; ++j) {
                        CAFProtector.m_XSSCharsTable[CAFProtector.m_tpXSSChars[j]] = 1;
                    }
                    break block5;
                }
                throw new CAFProtectorException(14);
            }
            catch (UnsupportedEncodingException e) {
                throw new CAFProtectorException(15);
            }
        }
    }

    public static CAFProtector getInstance() {
        return m_instance;
    }

    public static String web64AndWrap(String str) throws CAFException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(str.length() + 16);
            baos.write("CAFW".getBytes("UTF-8"));
            byte[] encoded = CAFWeb64.encode(str.getBytes("UTF-8"));
            byte[] dataLenByte = new byte[4];
            int strLen = encoded.length;
            dataLenByte[0] = (byte)(strLen >> 24 & 0xFF);
            dataLenByte[1] = (byte)(strLen >> 16 & 0xFF);
            dataLenByte[2] = (byte)(strLen >> 8 & 0xFF);
            dataLenByte[3] = (byte)(strLen & 0xFF);
            baos.write(CAFUtil.byteToHex(dataLenByte));
            baos.write(encoded);
            return baos.toString("UTF-8");
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 26);
        }
    }

    public static boolean parseAndDecodeS7XSS(String queryString, StringBuffer outBuf) throws CAFException {
        try {
            return CAFProtector.s7DecodeXSSChars(queryString, outBuf);
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 27);
        }
    }

    public static boolean parseAndDecodeOptimizedXSS(String str, StringBuffer outBuf) throws CAFException {
        try {
            boolean markerFound = false;
            int startPos = str.indexOf("XSSSTART");
            if (startPos != -1) {
                markerFound = true;
                outBuf.setLength(0);
                if (startPos > 0) {
                    outBuf.append(str.substring(0, startPos));
                }
                startPos += "XSSSTART".length();
            }
            if (markerFound) {
                int i = -1;
                int strLen = str.length();
                int endPos = 0;
                char c = '\u0000';
                byte[] arrByte = new byte[2];
                while (endPos != -1 && startPos != -1 && startPos < strLen && endPos < strLen) {
                    endPos = CAFProtector.nextEndMarker(str, startPos);
                    if (endPos == -1) continue;
                    if (endPos > startPos) {
                        for (i = startPos; i < endPos; ++i) {
                            c = str.charAt(i);
                            if (c == '*') {
                                c = '%';
                            } else if (c == '_' && i + 2 < endPos) {
                                arrByte[0] = (byte)str.charAt(i + 1);
                                arrByte[1] = (byte)str.charAt(i + 2);
                                c = (char)CAFUtil.hexToByte(arrByte)[0];
                                i += 2;
                            }
                            outBuf.append(c);
                        }
                    }
                    if ((endPos += "XSSEND".length()) >= strLen) continue;
                    startPos = str.indexOf("XSSSTART", endPos);
                    if (startPos == -1) {
                        outBuf.append(str.substring(endPos, strLen));
                        continue;
                    }
                    if (startPos > endPos) {
                        outBuf.append(str.substring(endPos, startPos));
                    }
                    startPos += "XSSSTART".length();
                }
            }
            return markerFound;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 28);
        }
    }

    public static boolean parseAndDecodeXSSChars(String queryString, StringBuffer outBuf) throws CAFException {
        boolean res = true;
        res = CAFProtector.parseAndDecodeS7XSS(queryString, outBuf);
        if (!res) {
            res = CAFProtector.parseAndDecodeOptimizedXSS(queryString, outBuf);
        }
        return res;
    }

    private static int nextEndMarker(String str, int pos) {
        int startPos = -1;
        int endPos = -1;
        int level = 1;
        while (level > 0) {
            startPos = str.indexOf("XSSSTART", pos);
            endPos = str.indexOf("XSSEND", pos);
            if (endPos == -1) {
                level = 0;
                pos = -1;
                continue;
            }
            if (startPos == -1) {
                pos = endPos;
                if (--level <= 0) continue;
                pos += "XSSEND".length();
                continue;
            }
            if (startPos < endPos) {
                ++level;
                pos = startPos + "XSSSTART".length();
                continue;
            }
            pos = endPos;
            if (--level <= 0) continue;
            pos += "XSSEND".length();
        }
        return pos;
    }

    public static String generateSecureErrorId() {
        StringBuffer logId = new StringBuffer(256);
        logId.append(CAFUtil.getTimeStamp(true));
        logId.append("-#");
        logId.append(CAFProtector.nextCount());
        return logId.toString().replace(' ', '-');
    }

    private static String substituteError(String str, Locale locale) throws CAFException {
        String cafmsg = null;
        if (CAFConfig.m_secureError) {
            String logId = CAFProtector.generateSecureErrorId();
            CAFProtector.logSecureError(logId, str);
            cafmsg = CAFProtector.buildSecureErrorMsg(logId, locale);
        } else {
            cafmsg = str;
        }
        return cafmsg;
    }

    public static String signAndWrap(String str, String passport, SigningSession signingSession) throws CAFException {
        try {
            if (passport == null || passport.length() == 0) {
                throw new CAFProtectorException(13);
            }
            if (signingSession == null) {
                signingSession = CAFFactoryImpl.camFactory.createSigningSession();
            }
            String wrap = CAFHmacCache.getWrappedHMAC(str, passport, null, signingSession);
            if (str.startsWith("<")) {
                wrap = CAFProtector.web64AndWrap(wrap);
            }
            return wrap;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 17);
        }
    }

    public static String saltedHMACWeb64AndWrap(String str, String passport, SigningSession signingSession) throws CAFException {
        try {
            String wrap = CAFHmacCache.getWrappedHMAC(str, passport, CAFGlobals.CAF_SIGNATURE_SALT, signingSession);
            wrap = CAFProtector.web64AndWrap(wrap);
            return wrap;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 31);
        }
    }

    public static boolean containsXSSChar(String str, StringBuffer invalidChar) throws CAFException {
        for (int i = 0; i < m_tpXSSChars.length; ++i) {
            if (str.indexOf(m_tpXSSChars[i]) == -1) continue;
            if (invalidChar != null) {
                invalidChar.setLength(0);
                invalidChar.append((char)m_tpXSSChars[i]);
            }
            return true;
        }
        return false;
    }

    private void s7EncodeXSS(String str, StringBuffer outBuf) {
        char[] arrChar = str.toCharArray();
        char c = '\u0000';
        for (int i = 0; i < arrChar.length; ++i) {
            c = arrChar[i];
            if (c == '_') {
                outBuf.append("_5f");
                continue;
            }
            if (c == '%') {
                outBuf.append("_25");
                continue;
            }
            if ((c & 0xFF00) == 0 && m_XSSCharsTable[c] == 1) {
                outBuf.append('_');
                outBuf.append((char)m_HEX_CHARS[(c & 0xF0) >> 4]);
                outBuf.append((char)m_HEX_CHARS[c & 0xF]);
                continue;
            }
            outBuf.append(c);
        }
    }

    private String s7EncodeXSSurl(String url) throws CAFException {
        try {
            int qsPos = url.indexOf(63) + 1;
            int urlLen = url.length();
            if (qsPos > 0 && qsPos != urlLen) {
                StringBuffer buf = new StringBuffer(urlLen * 2);
                buf.append(url.substring(0, qsPos));
                buf.append("AFDATA");
                this.s7EncodeXSS(url.substring(qsPos), buf);
                url = buf.toString();
            }
            return url;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 18);
        }
    }

    private static boolean s7DecodeXSSChars(String queryString, StringBuffer outBuf) throws CAFException {
        try {
            boolean res = false;
            if (queryString.startsWith("AFDATA")) {
                String str = queryString.substring("AFDATA".length());
                char c = '\u0000';
                char[] arrChar = str.toCharArray();
                byte[] hex = new byte[2];
                for (int i = 0; i < arrChar.length; ++i) {
                    c = arrChar[i];
                    if (c == '_' && i + 2 < arrChar.length) {
                        hex[0] = (byte)arrChar[i + 1];
                        hex[1] = (byte)arrChar[i + 2];
                        outBuf.append((char)CAFUtil.hexToByte(hex)[0]);
                        i += 2;
                        continue;
                    }
                    outBuf.append(c);
                }
                res = true;
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 25);
        }
    }

    private static void optimizedEncodeXSS(String queryString, StringBuffer outBuf) {
        char[] arrChar = queryString.toCharArray();
        char c = '\u0000';
        int tempbuflookahead = 16;
        int tempbuflen = queryString.length() * 2;
        char[] tempbuf = new char[tempbuflen + 16];
        int tempbufidx = -1;
        for (int i = 0; i < arrChar.length; ++i) {
            c = arrChar[i];
            if (c == '%') {
                tempbuf[++tempbufidx] = 42;
            } else if (c == '*') {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = 50;
                tempbuf[++tempbufidx] = 97;
            } else if (c == '_') {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = 53;
                tempbuf[++tempbufidx] = 102;
            } else if ((c & 0xFF00) == 0 && m_XSSCharsTable[c] == 1) {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = (char)m_HEX_CHARS[(c & 0xF0) >> 4];
                tempbuf[++tempbufidx] = (char)m_HEX_CHARS[c & 0xF];
            } else {
                tempbuf[++tempbufidx] = c;
            }
            if (tempbufidx < tempbuflen) continue;
            outBuf.append(tempbuf, 0, tempbufidx + 1);
            tempbufidx = -1;
        }
        if (tempbufidx >= 0) {
            outBuf.append(tempbuf, 0, tempbufidx + 1);
        }
    }

    public static String wrapAndXSSEncode(String str) throws CAFException {
        try {
            StringBuffer xssBuf = new StringBuffer(4096);
            xssBuf.setLength(0);
            xssBuf.append("XSSSTART");
            CAFProtector.optimizedEncodeXSS(str, xssBuf);
            xssBuf.append("XSSEND");
            return xssBuf.toString();
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 19);
        }
    }

    public static String getJavascriptConfig() {
        StringBuffer out = new StringBuffer(1024);
        out.append("\n");
        out.append(JS_CAF_TP_XSS_CHECKING_USED);
        out.append(CAFConfig.m_tpXSSCheckingUsed);
        out.append(";\n");
        out.append(JS_CAF_TP_XSS_CHARS);
        for (int i = 0; i < m_tpXSSChars.length; ++i) {
            if (m_tpXSSChars[i] == 34) {
                out.append("\\\"");
                continue;
            }
            if (m_tpXSSChars[i] == 92) {
                out.append("\\\\");
                continue;
            }
            out.append((char)m_tpXSSChars[i]);
        }
        out.append("\";\n");
        return out.toString();
    }

    public static String getContextId(String component, String passport, SigningSession signingSession) throws CAFException {
        try {
            String contextId = null;
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("getContextId()", "passport", passport, 30000, "protector");
            }
            if (passport == null || passport.length() == 0) {
                throw new CAFProtectorException(13);
            }
            if (component == null) {
                throw new CAFProtectorException(32);
            }
            if (signingSession == null) {
                signingSession = CAFFactoryImpl.camFactory.createSigningSession();
            }
            if (component.equals("es") || component.equals("ans") || component.equals("qs") || component.equals("rs") || component.equals("pc") || component.equals("ps") || component.equals("rv") || component.equals("pp") || component.equals("cmm") || component.equals("icd") || component.equals("viz") || component.equals("aa")) {
                StringBuffer contextIdBuf = new StringBuffer();
                long time = System.currentTimeMillis();
                time = (long)Math.floor(time / 3600000L);
                contextIdBuf.append(String.valueOf(time));
                contextIdBuf.append("|");
                contextIdBuf.append(component);
                contextId = CAFProtector.saltedHMACWeb64AndWrap(contextIdBuf.toString(), passport, signingSession);
            } else {
                contextId = "";
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("getContextId() failed - failure on capability check", "component", component, "passport", passport, 50000, "protector");
                }
            }
            return contextId;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 23);
        }
    }

    public static boolean isSafeURL(String url) throws CAFException {
        boolean res = false;
        try {
            if (url == null) {
                throw new CAFProtectorException(29);
            }
            res = CAFLibrary.isSafeURL(url);
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 30);
        }
        return res;
    }

    @Override
    public String doActions(String str, Vector actions, Vector values, CAFActionHandlerData ahd) throws CAFException {
        try {
            int actionsLen = actions.size();
            String action = null;
            String value = null;
            boolean optionalUnwrap = false;
            boolean forceXSSEncoding = false;
            if (ahd == null) {
                ahd = new CAFActionHandlerData(null, null);
            }
            ahd.actions = actions;
            ahd.values = values;
            boolean removeActionValue = false;
            int i = 0;
            while (i < actionsLen) {
                removeActionValue = false;
                action = (String)actions.get(i);
                value = (String)values.get(i);
                if (action.equals("setpassportid")) {
                    ahd.passport = value;
                    removeActionValue = true;
                } else if (action.equals("setcomponent")) {
                    ahd.component = value;
                    removeActionValue = true;
                } else if (action.equals("setlocale")) {
                    String locStr1 = value;
                    String locStr2 = null;
                    if (locStr1.length() == 2) {
                        locStr2 = locStr1;
                    } else if (locStr1.length() == 5) {
                        locStr2 = locStr1.substring(3);
                        locStr1 = locStr1.substring(0, 2);
                        CAFLog.trace("setlocale", "first", locStr1, "second", locStr2, 10000, "protector");
                    } else {
                        CAFLog.error("Unknown or invalid locale value in setlocale action", "locale", locStr1);
                    }
                    if (locStr2 != null) {
                        ahd.locale = new Locale(locStr1, locStr2);
                    }
                    removeActionValue = true;
                } else if (action.equals("setflag") && value.equals("optionalunwrap")) {
                    optionalUnwrap = true;
                } else if (CAFConfig.m_tpXSSCheckingUsed && action.equals("encoding") && value.equals("xss")) {
                    forceXSSEncoding = true;
                }
                if (removeActionValue) {
                    actions.remove(i);
                    values.remove(i);
                    --actionsLen;
                    continue;
                }
                ++i;
            }
            actionsLen = actions.size();
            for (i = actionsLen - 1; i >= 0; --i) {
                action = (String)actions.get(i);
                value = (String)values.get(i);
                if (CAFConfig.m_tpXSSCheckingUsed) {
                    if (action.equals("context") && value.equals("getdata")) {
                        if (!forceXSSEncoding && str.indexOf(37) == -1 && !CAFProtector.containsXSSChar(str, null)) continue;
                        str = CAFProtector.wrapAndXSSEncode(str);
                        continue;
                    }
                    if (action.equals("type") && value.equals("s7url")) {
                        str = this.s7EncodeXSSurl(str);
                        continue;
                    }
                    if (action.equals("decode") && value.equals("xss")) {
                        StringBuffer modifiedStr = new StringBuffer(str.length());
                        if (str.substring(0, "AFDATA".length()).equalsIgnoreCase("AFDATA")) {
                            StringBuffer buf = new StringBuffer(str.length());
                            if (CAFProtector.s7DecodeXSSChars(str.substring("AFDATA".length()), buf)) {
                                str = buf.toString();
                            }
                        } else if (CAFProtector.parseAndDecodeXSSChars(str, modifiedStr)) {
                            str = modifiedStr.toString();
                        }
                    }
                }
                if (action.equals("get")) {
                    if (value.equals("jsconfig")) {
                        str = CAFProtector.getJavascriptConfig();
                        continue;
                    }
                    if (value.equals("contextid")) {
                        if (ahd.signingSession == null) {
                            SigningSession ss;
                            ahd.signingSession = ss = CAFFactoryImpl.camFactory.createSigningSession();
                        }
                        if (ahd.passport == null) {
                            throw new CAFProtectorException(13);
                        }
                        str = CAFProtector.getContextId(ahd.component, ahd.passport, ahd.signingSession);
                        continue;
                    }
                    if (value.equals("configsignedreporturls")) {
                        str = String.valueOf(CAFConfig.m_signedReportUrls);
                        continue;
                    }
                    if (!value.equals("extendedcontextid")) continue;
                    str = String.valueOf(CAFConfig.m_extendedContextId);
                    continue;
                }
                if (action.equals("encrypt")) {
                    CAFLog.error("CAF encrypt functionality deprecated - please report this error to the CAF team");
                    continue;
                }
                if (action.equals("decrypt")) {
                    CAFLog.error("CAF decrypt functionality deprecated - please report this error to the CAF team");
                    continue;
                }
                if (action.equals("substitute") && value.equals("error")) {
                    str = CAFProtector.substituteError(str, ahd.locale);
                    continue;
                }
                if (action.equals("sign")) {
                    if (!CAFConfig.m_validationEnabled) continue;
                    if (value.equals("unwrap")) {
                        if (optionalUnwrap && !str.startsWith("CAFS".substring(0, 2)) || str.length() <= 0) continue;
                        str = CAFValidator.unwrapSignature(str, null);
                        continue;
                    }
                    if (value.equals("cpstarget")) {
                        if (!CAFLog.isTracingEnabled) continue;
                        CAFLog.trace("doActions() - cpstarget signing is deprecated and disabled", 10000, "protector");
                        continue;
                    }
                    boolean reportURL = value.equals("reporturl");
                    if (reportURL && (!CAFConfig.m_signedReportUrls || !reportURL)) continue;
                    if (ahd.signingSession == null) {
                        ahd.signingSession = CAFFactoryImpl.camFactory.createSigningSession();
                    }
                    if (ahd.passport == null) {
                        throw new CAFProtectorException(13);
                    }
                    str = CAFProtector.signAndWrap(str, ahd.passport, ahd.signingSession);
                    continue;
                }
                if (action.equals("issafeurl")) {
                    str = CAFProtector.isSafeURL(str) ? "true" : "false";
                    continue;
                }
                if (!action.equals("checkurlhostdomain")) continue;
                str = CAFValidator.checkURLHostDomain(str) ? "true" : "false";
            }
            return str;
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 12);
        }
    }

    public String doActions(String str, String actionValues, CAFActionHandlerData ahd) throws CAFException {
        Vector actions = new Vector();
        Vector values = new Vector();
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("doActions()", "actionValues", actionValues, "input str", str, 10000, "protector");
        }
        CAFTagBlock.parseActions(actionValues, 0, actionValues.length(), actions, values, null);
        String res = this.doActions(str, actions, values, ahd);
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("doActions()", "output str", res, 10000, "protector");
        }
        return res;
    }

    public static String buildSecureErrorMsg(String logId, Locale locale) throws CAFException {
        Locale loc = null;
        if (locale == null) {
            CAFLog.warn("Received null locale when creating the secure error page");
            loc = new Locale("en", "us");
        } else {
            loc = locale;
        }
        String errPage = CAFMessageStrings.get().getString("CAF_SECURELOG_MSG", loc);
        errPage = errPage + logId;
        return errPage;
    }

    public static void logSecureError(String logId, String message) throws CAFException {
        StringBuffer msg = new StringBuffer();
        msg.append("SecureErrorId: ");
        msg.append(logId);
        msg.append("\r\nOriginal Error: ");
        msg.append(message);
        CAFLog.error(msg.toString());
    }

    private static boolean keepErrorCode(String errorCode) {
        String[] errorCodesToKeep = new String[]{"2107", "cmDuplicateName", "cmNoRead", "cmNoPermission", "cmBadName", "cmDuplicateObject", "cmNoDelChild", "cmArchiveExists", "cmArchiveOverwriteError", "cmArchiveCreateError", "cmObjectNotFound", "cmNoSetPolicy", "cmNoWrite", "cmArchiveNotExist", "cmArchiveDeleteFailed", "cmArchiveEncrypted", "cmNoCredentiaExists", "cmDuplicateAdd", "cmNoCredentialAccessDataSource", "cmExpectedArchiveEncryptPassword", "cmBadNameQuotes", "cmDeploymentArchiveInUse", "cmArchiveBad", "cmBadDeleteUnarchivedObjects", "cmNameConflict"};
        if (errorCode == null) {
            return false;
        }
        for (String errCode : errorCodesToKeep) {
            if (!errorCode.equalsIgnoreCase(errCode)) continue;
            return true;
        }
        return false;
    }

    public static void doSecureError(BodyFault fault, Locale locale, boolean userHasDetailErrorCapability, boolean defect251099) throws CAFException {
        try {
            String CAF_ERROR_CODE = "caf";
            BodyFaultDetail faultDetail = fault.getDetail();
            List exceptions = faultDetail.getExceptions();
            Iterator it = exceptions.iterator();
            if (it.hasNext()) {
                BodyFaultException exception = (BodyFaultException)it.next();
                String errorCode = exception.getErrorCode();
                if (errorCode != null && "caf".equalsIgnoreCase(errorCode)) {
                    return;
                }
                if (!CAFProtector.keepErrorCode(errorCode)) {
                    exception.setErrorCode("caf");
                }
                List messages = exception.getMessages();
                String sSecureLogId = CAFProtector.generateSecureErrorId();
                StringBuffer sMessages = new StringBuffer();
                String sFirstMessage = null;
                if (messages.size() > 0) {
                    for (BodyFaultMessage faultMessage : messages) {
                        String messageString = faultMessage.getMessageString();
                        if (messageString == null || messageString.length() == 0) continue;
                        if (sFirstMessage == null) {
                            sFirstMessage = messageString;
                        } else {
                            sMessages.append("\r\n");
                        }
                        sMessages.append(messageString);
                    }
                    exception.clearMessages();
                    CAFProtector.logSecureError(sSecureLogId, sMessages.toString());
                    BodyFaultMessage originalMessage = exception.createAndAddMessage();
                    String cafmsgtext = CAFProtector.buildSecureErrorMsg(sSecureLogId, locale);
                    boolean displayingCAFMessage = true;
                    if (userHasDetailErrorCapability) {
                        if (defect251099) {
                            if (CAFConfig.m_spoofFixEnabled == 2) {
                                if (cafmsgtext != null) {
                                    originalMessage.setMessageString(cafmsgtext);
                                }
                            } else if (sFirstMessage != null) {
                                originalMessage.setMessageString(sFirstMessage);
                                displayingCAFMessage = false;
                            }
                        } else if (sFirstMessage != null) {
                            originalMessage.setMessageString(sFirstMessage);
                            displayingCAFMessage = false;
                        }
                    } else if (defect251099) {
                        if (CAFConfig.m_spoofFixEnabled == 1 || CAFConfig.m_spoofFixEnabled == 2) {
                            if (cafmsgtext != null) {
                                originalMessage.setMessageString(cafmsgtext);
                            }
                        } else if (sFirstMessage != null) {
                            originalMessage.setMessageString(sFirstMessage);
                            displayingCAFMessage = false;
                        }
                    } else if (sFirstMessage != null) {
                        originalMessage.setMessageString(sFirstMessage);
                        displayingCAFMessage = false;
                    }
                    BodyFaultMessage cafMessage = null;
                    if (!displayingCAFMessage) {
                        cafMessage = exception.createAndAddMessage();
                        if (cafmsgtext != null) {
                            cafMessage.setMessageString(cafmsgtext);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CAFProtectorException(e, 11);
        }
    }
}

