/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.caf.CAFExceptionUtilities;
import com.cognos.caf.CAFFirewallException;
import com.cognos.caf.CAFProtector;
import com.cognos.caf.cache.CAFACLCapabilityCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.CamException;
import java.util.List;
import java.util.Locale;

public class CAFSecureErrorHandler
extends BasicHandler {
    static final String CAM_AUTH_USER_RECOVERABLE = "camAuthUserRecoverable";

    public CAFSecureErrorHandler() {
        super(null);
    }

    public static boolean canReceiveDetailedErrors(String passport) throws CAFException {
        try {
            if (passport == null) {
                throw new CAFFirewallException(40);
            }
            boolean res = CAFACLCapabilityCache.staticCheckCapability(passport, "canReceiveDetailedErrors", false);
            CAFLog.trace("CAFSecureErrorHandler - capability check", "canReceiveDetailedErrors", String.valueOf(res), 10000);
            return res;
        }
        catch (CAFException e) {
            CAFLog.trace("check for canReceivedDetailedErros failed", "passport", passport, "exception", e.getTraceInformation(), 10000);
            return false;
        }
    }

    public static boolean canReceiveDetailedErrors(BIBusEnvelope env) throws CAFException {
        if (env == null) {
            CAFLog.warn("secure error - null request envelope");
            return false;
        }
        return CAFUtil.getUserCapabilty(env, "canReceiveDetailedErrors");
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            if (CAFConfig.m_secureError) {
                boolean done = false;
                if (mc == null) {
                    CAFLog.warn("secure error - null message context");
                    done = true;
                } else if (mc.hasResponded()) {
                    CAFLog.warn("secure error - message context is mark has responded");
                    done = true;
                } else if (mc.getFault() == null) {
                    CAFLog.warn("secure error - null fault");
                    done = true;
                }
                if (!done) {
                    boolean logonFault = false;
                    SOAPEnvelope env = mc.getFault().generateEnvelope();
                    if (env == null) {
                        CAFLog.warn("secure error - null envelope");
                        done = true;
                    } else {
                        BiBusHeader header = env.getBiBusHeader();
                        if (header == null) {
                            CAFLog.warn("secure error - null header");
                            done = true;
                        } else {
                            Cam cam = header.getCam();
                            CamException camException = cam.getException();
                            String errorCodeString = camException.getErrorCodeString();
                            if (errorCodeString != null && errorCodeString.length() != 0) {
                                if (CAM_AUTH_USER_RECOVERABLE.equals(errorCodeString)) {
                                    logonFault = true;
                                }
                                if (CAFLog.isTracingEnabled) {
                                    CAFLog.trace("CAFSecureErrorHandler - cam exception", "error code", errorCodeString, "logon fault", String.valueOf(logonFault), 10000);
                                }
                            }
                        }
                    }
                    if (!done && !logonFault) {
                        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                        if (requestEnvelope == null) {
                            CAFLog.warn("secure error - null request envelope");
                            done = true;
                        } else {
                            boolean userHasDetailErrorCapability;
                            String b_actionInput = requestEnvelope.getFormValue("b_action");
                            String ui_actionInput = requestEnvelope.getFormValue("ui.action");
                            BodyFault bodyFault = env.getBodyFault();
                            boolean defect251099 = false;
                            int enable251099MsgHiding = CAFConfig.m_spoofFixEnabled;
                            if (b_actionInput != null && ui_actionInput != null && b_actionInput.compareToIgnoreCase("cognosViewer") == 0 && ui_actionInput.compareToIgnoreCase("run") == 0) {
                                BodyFaultDetail faultDetail = bodyFault.getDetail();
                                List exceptions = faultDetail.getExceptions();
                                block2: for (BodyFaultException exception : exceptions) {
                                    List messages;
                                    String errorCode = exception.getErrorCode();
                                    if (errorCode == null || errorCode.compareToIgnoreCase("cmInvalidSearchPath") != 0 || (messages = exception.getMessages()).size() <= 1) continue;
                                    for (BodyFaultMessage faultMessage : messages) {
                                        String messageString = faultMessage.getMessageString();
                                        if (!messageString.startsWith("CM-REQ-4158")) continue;
                                        defect251099 = true;
                                        continue block2;
                                    }
                                }
                            }
                            if (!(userHasDetailErrorCapability = CAFSecureErrorHandler.canReceiveDetailedErrors(requestEnvelope)) || defect251099 && enable251099MsgHiding == 2) {
                                if (CAFLog.isTracingEnabled) {
                                    CAFLog.trace("CAFSecureErrorHandler - before fault processing", "fault", bodyFault == null ? null : bodyFault.asXML(), 10000);
                                }
                                CAFProtector.doSecureError(bodyFault, (Locale)mc.getProperty("locale"), userHasDetailErrorCapability, defect251099);
                                if (CAFLog.isTracingEnabled) {
                                    CAFLog.trace("CAFSecureErrorHandler - after fault processing", "fault", bodyFault == null ? null : bodyFault.asXML(), 10000);
                                }
                            }
                        }
                    }
                }
                if (done) {
                    CAFLog.warn("secure error skipped");
                }
            }
        }
        catch (Exception e) {
            CAFExceptionUtilities.handleException(e, 24);
        }
    }
}

