/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.CAFCookie;
import com.cognos.caf.CAFRequestObject;
import com.cognos.caf.CAFValidatorException;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFGlobals;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFValidationData;
import com.cognos.caf.common.CAFWeb64;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.rule.CAFRuleException;
import com.cognos.caf.rule.CAFRules;
import com.cognos.caf.rule.CAFValidationRule;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CAFValidator {
    private static final String CRN_cookie = "crn";
    private static final String CRN_skin = "crn_skin";
    private static final Pattern extractCRNskin = Pattern.compile("skin=([^&]*)");

    public static boolean checkTimestamp(String timestamp) throws CAFException {
        boolean valid = true;
        long objectTime = 0L;
        if (valid) {
            try {
                objectTime = Long.parseLong(timestamp);
            }
            catch (NumberFormatException e) {
                CAFLog.error("object timestamp parsing failed", "timestamp", timestamp, "exception", e.getMessage());
                objectTime = 0L;
                valid = false;
            }
        }
        if (valid) {
            long currentTime = System.currentTimeMillis();
            if (objectTime > (currentTime = (long)Math.floor(currentTime / 3600000L)) + 1L) {
                valid = false;
                CAFLog.error("object timestamp is after current time");
            } else if (objectTime < currentTime - 72L) {
                valid = false;
                CAFLog.error("object timestamp is older than " + String.valueOf(72) + " hours");
            }
            if (!valid) {
                CAFLog.error("object timestamp mismatch", "timestamp", String.valueOf(objectTime), "current time", String.valueOf(currentTime));
            }
        }
        return valid;
    }

    public static boolean isSafeURL(String strURL) throws CAFException {
        if (CAFConfig.m_validationEnabled) {
            boolean res = false;
            CAFValidationData valData = new CAFValidationData();
            valData.value = strURL;
            valData.name = "safeurl";
            res = CAFValidator.validateVariableApi(valData);
            if (res) {
                res = CAFValidationRule.postCheck("safeurl", strURL);
            }
            return res;
        }
        return true;
    }

    public static boolean checkURLHostDomain(String strURL) throws CAFException {
        try {
            CAFLog.warn("Entering CheckURLHostDomain");
            if (CAFConfig.m_validationEnabled) {
                URL url = null;
                boolean res = false;
                boolean done = false;
                if (strURL.length() == 0 || strURL.charAt(0) == '/' || strURL.charAt(0) == '?') {
                    res = true;
                    done = true;
                }
                if (!done) {
                    try {
                        url = new URL(strURL.toLowerCase());
                    }
                    catch (MalformedURLException e) {
                        done = true;
                        CAFLog.error("malformed URL", "message", e.getMessage());
                    }
                }
                if (!done && !CAFConfig.m_checkValidDomains) {
                    done = true;
                    res = true;
                    CAFLog.warn("Not checking valid domains at 1.");
                }
                if (!done) {
                    StringBuffer hostPort;
                    String host = url.getHost();
                    CAFLog.warn("Checking " + host + " against valid domain list.");
                    int dotPos = host.indexOf(46);
                    if (dotPos > 0 && CAFConfig.validDomainsManager.isValid(host.substring(dotPos))) {
                        res = true;
                    }
                    int port = url.getPort();
                    if (!res) {
                        if (port == -1 && CAFConfig.m_validHostPorts.contains(host)) {
                            res = true;
                        } else {
                            hostPort = new StringBuffer(host);
                            if (port != -1) {
                                hostPort.append(':');
                                hostPort.append(port);
                            } else if (url.getProtocol().equals("http")) {
                                hostPort.append(":80");
                            } else if (url.getProtocol().equals("https")) {
                                hostPort.append(":443");
                            } else {
                                done = true;
                                CAFLog.error("URL with unknown protocol without port specified", "protocol", url.getProtocol(), "host", hostPort.toString());
                            }
                            if (CAFConfig.m_validHostPorts.contains(hostPort.toString())) {
                                res = true;
                            } else if ((port == 80 && url.getProtocol().equals("http") || port == 443 && url.getProtocol().equals("https")) && CAFConfig.m_validHostPorts.contains(host)) {
                                res = true;
                            }
                        }
                    }
                    if (!done && !res) {
                        hostPort = new StringBuffer(host);
                        if (port != -1) {
                            hostPort.append(':');
                            hostPort.append(port);
                        }
                        CAFLog.error("Invalid URL domain or host", "host port", hostPort.toString());
                        CAFLog.error("URL does not match any valid domain or host", "valid hosts", CAFConfig.m_validHostPorts.toString(), "valid domains", CAFConfig.validDomainsManager.toString());
                    }
                }
                if (!res) {
                    CAFLog.error("is valid URL failed", "URL", strURL);
                }
                return res;
            }
            return true;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 17);
        }
    }

    public static String unwrapWeb64(String str) throws CAFException {
        try {
            boolean continueToCheck = true;
            String res = "";
            if (str.startsWith("CAFW")) {
                int prefixLen = "CAFW".length();
                String data = null;
                if (str.length() < prefixLen + 8) {
                    CAFLog.error("web64 data too small", "minimum expected", Integer.toString(prefixLen + 8), "actual", Integer.toString(str.length()));
                    continueToCheck = false;
                } else {
                    String dataLenStr = str.substring(prefixLen, prefixLen + 8);
                    int dataLen = CAFUtil.signatureDataLenStrToInt(dataLenStr);
                    if (dataLen < 0) {
                        CAFLog.error("web64 data length less than 0 invalid", "data length", Integer.toString(dataLen));
                        continueToCheck = false;
                    } else {
                        data = str.substring(prefixLen + 8);
                        if (data.length() != dataLen) {
                            CAFLog.error("invalid web64 data length", "expected", Integer.toString(dataLen), "actual", Integer.toString(str.length()));
                            continueToCheck = false;
                        }
                    }
                    if (continueToCheck && data != null) {
                        byte[] bytes = CAFWeb64.decode(data.getBytes("UTF-8"));
                        res = new String(bytes, "UTF-8");
                    }
                }
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 11);
        }
    }

    public static String unwrapSignature(String str, StringBuffer passportHMAC) throws CAFException {
        try {
            byte[] hmacsLenHex;
            if (str.startsWith("CAFW")) {
                str = CAFValidator.unwrapWeb64(str);
            }
            long passportIdHMACLen = -1L;
            int dataLen = -1;
            String res = "";
            boolean error = false;
            int strLen = str.length();
            int prefixLen = 0;
            if (str.startsWith("CAFS")) {
                prefixLen = "CAFS".length();
            } else if (str.startsWith("CAFA")) {
                prefixLen = "CAFA".length();
            } else {
                error = true;
                CAFLog.error("Invalid HMAC or signed data, CAFA, or CAFS prefix not found", "string", str);
            }
            int hmacStart = 10 + prefixLen;
            if (strLen < hmacStart) {
                error = true;
                CAFLog.error("HMACs lengths and data length required", "value length", Integer.toString(strLen), "required length", Integer.toString(hmacStart));
            }
            if (!error && (passportIdHMACLen = CAFUtil.hexToLong(hmacsLenHex = str.substring(prefixLen, prefixLen + 2).getBytes("UTF-8"))) <= 0L) {
                error = true;
                CAFLog.error("HMACs length of 0 or less invalid", "passport HMAC length", Long.toString(passportIdHMACLen));
            }
            if (!error) {
                byte[] dataLenHex = str.substring(prefixLen + 2, prefixLen + 2 + 8).getBytes("UTF-8");
                byte[] dataLenByte = CAFUtil.hexToByte(dataLenHex);
                dataLen = (dataLenByte[0] & 0xFF) << 24;
                dataLen += (dataLenByte[1] & 0xFF) << 16;
                dataLen += (dataLenByte[2] & 0xFF) << 8;
                if ((dataLen += dataLenByte[3] & 0xFF) < 0) {
                    error = true;
                    CAFLog.error("data length less than 0 invalid", "data length", Integer.toString(dataLen));
                }
            }
            if (!error && (long)str.length() < (long)hmacStart + passportIdHMACLen) {
                error = true;
                CAFLog.error("HMACs not found", "string length", Integer.toString(strLen), "required length", Long.toString((long)hmacStart + passportIdHMACLen));
            }
            if (!error && (long)str.length() < (long)hmacStart + passportIdHMACLen + (long)dataLen) {
                error = true;
                CAFLog.error("data not found", "string length", Integer.toString(strLen), "required length", Long.toString((long)hmacStart + passportIdHMACLen + (long)dataLen));
            }
            if (!error) {
                if (passportHMAC != null) {
                    passportHMAC.append(str.substring(hmacStart, (int)((long)hmacStart + passportIdHMACLen)));
                }
                if ((res = str.substring((int)((long)hmacStart + passportIdHMACLen))) != null && res.length() != dataLen) {
                    error = true;
                    CAFLog.error("invalid data", "data", res);
                    CAFLog.error("invalid data length", "expected length", String.valueOf(dataLen), "actual length", String.valueOf(res.length()));
                    res = "";
                }
            }
            if (error) {
                CAFLog.error("unwrap signature failed", "string", str);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 8);
        }
    }

    public static boolean checkHMAC(String hmac, String str, String passport, SigningSession signingSession, boolean salted, StringBuffer failureDetails) throws CAFException {
        try {
            boolean res = false;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256 + str.length());
            baos.write(str.getBytes("UTF-8"));
            if (passport != null) {
                baos.write(passport.getBytes("UTF-8"));
            }
            if (salted) {
                baos.write(CAFGlobals.CAF_SIGNATURE_SALT);
            }
            byte[] bytes = baos.toByteArray();
            byte[] hmacBytes = CAFWeb64.decode(hmac.getBytes("UTF-8"));
            try {
                res = signingSession.hmacVerify(hmacBytes, bytes);
                if (!res) {
                    failureDetails.append("CAM hmacVerify failed");
                }
            }
            catch (CAMCryptoException e) {
                failureDetails.append("CAM crypto message - ");
                failureDetails.append(e.getMessage());
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 9);
        }
    }

    private static boolean checkSignatureUsingCAFCookie(String str, String hmac, boolean salted, String passport, SigningSession signingSession, CAFCookie cafCookie) throws CAFException {
        boolean res = true;
        List passportList = null;
        if (cafCookie != null) {
            cafCookie.validateAndExtract(passport, signingSession);
            passportList = cafCookie.passports();
            if (passportList == null || passportList.isEmpty()) {
                res = false;
            }
        }
        if (!res || cafCookie == null) {
            CAFLog.error("could not get backup passport from CAF cookie", "CAF cookie", cafCookie == null ? null : cafCookie.toString());
        } else {
            Iterator i = passportList.iterator();
            StringBuffer failureDetails = new StringBuffer();
            boolean valid = false;
            while (!valid && i.hasNext()) {
                passport = (String)i.next();
                failureDetails.setLength(0);
                valid = CAFValidator.checkHMAC(hmac, str, passport, signingSession, salted, failureDetails);
                if (!CAFLog.isTracingEnabled) continue;
                if (valid) {
                    CAFLog.trace("CAF cookie passport check succeeded", "cookie passport", passport, 10000);
                    continue;
                }
                CAFLog.trace("CAF cookie passport check failed", "cookie passport", passport, "details", failureDetails.toString(), 10000);
            }
            if (!valid) {
                res = false;
                CAFLog.error("failed to check signature with CAF cookie passports", "CAF cookie", cafCookie.toString());
            }
        }
        return res;
    }

    private static boolean checkSignature(String str, String hmac, String passport, SigningSession signingSession, CAFCookie cafCookie, boolean salted, boolean pureHMAC) throws CAFValidatorException {
        try {
            boolean res = true;
            StringBuffer failureDetails = new StringBuffer();
            if (pureHMAC) {
                res = CAFValidator.checkHMAC(hmac, str, passport, signingSession, salted, failureDetails);
                if (!res) {
                    CAFLog.error("pure HMAC check failed", "details", failureDetails.toString());
                }
            } else {
                boolean done = false;
                if (passport != null) {
                    res = CAFValidator.checkHMAC(hmac, str, passport, signingSession, salted, failureDetails);
                    if (res) {
                        done = true;
                    } else if (CAFLog.isTracingEnabled) {
                        CAFLog.trace("primary passport signature check failed", "passport", passport, "details", failureDetails.toString(), 10000, "validator");
                    }
                }
                if (!done) {
                    if (cafCookie == null) {
                        res = false;
                        if (CAFLog.isTracingEnabled) {
                            CAFLog.trace("no CAF cookie - no backup passports to check signature", 10000, "validator");
                        }
                    } else {
                        if (CAFLog.isTracingEnabled) {
                            CAFLog.trace("checking signature with CAF cookie", 10000, "validator");
                        }
                        if (!(res = CAFValidator.checkSignatureUsingCAFCookie(str, hmac, salted, passport, signingSession, cafCookie))) {
                            CAFLog.error("signature check failed using CAF cookie passports", "CAF cookie", cafCookie.toString());
                        }
                    }
                }
            }
            if (!res) {
                String MSG = "check signature failed";
                CAFLog.error("check signature failed", "string", str, "hmac", hmac);
                CAFLog.error("check signature failed", "passport", passport, "salted", String.valueOf(salted));
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 15);
        }
    }

    public static boolean unwrapAndCheckSignature(String encValue, StringBuffer unwrapValue, String passport, SigningSession signingSession, CAFCookie cafCookie, boolean saltRequired, boolean pureHMAC) throws CAFException {
        try {
            boolean res = true;
            String unwrapStr = null;
            StringBuffer hmacBuf = new StringBuffer(128);
            String web64Decoded = null;
            if (encValue.startsWith("CAFW")) {
                encValue = CAFValidator.unwrapWeb64(encValue);
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("unwrapAndCheckSignature() - web64 unwrap", "encoded value", encValue, 10000, "validator");
                }
                if (encValue == null || encValue.length() == 0) {
                    CAFLog.error("failed to unwrap web64 for signature check");
                    res = false;
                } else {
                    web64Decoded = encValue;
                }
            }
            boolean salted = encValue.startsWith("CAFA");
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("unwrapAndCheckSignature()", "salted", String.valueOf(salted), 10000, "validator");
            }
            if (res && saltRequired && !salted) {
                CAFLog.error("salted signature required");
                res = false;
            }
            if (res && (unwrapStr = CAFValidator.unwrapSignature(encValue, hmacBuf)).length() == 0) {
                CAFLog.error("empty unwrap not valid");
                res = false;
            }
            if (res) {
                res = CAFValidator.checkSignature(unwrapStr, hmacBuf.toString(), passport, signingSession, cafCookie, salted, pureHMAC);
            }
            if (res) {
                if (unwrapValue != null) {
                    unwrapValue.setLength(0);
                    unwrapValue.append(unwrapStr);
                }
            } else {
                String msg = "unwrap and check signature failed";
                if (web64Decoded == null) {
                    CAFLog.error(msg);
                } else {
                    CAFLog.error(msg, "web64 decoded value", web64Decoded);
                }
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 2);
        }
    }

    public static boolean validateVariable(CAFValidationData valData, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean res = false;
            if (valData.name == null) {
                valData.name = new String();
            }
            if (valData.value == null) {
                valData.value = new String();
            }
            if ((res = CAFRules.isVariableValid(valData, requestObject)) && valData.sign) {
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("validateVariable() - checking signature", "sign", String.valueOf(valData.sign), 10000, "validator");
                }
                res = CAFValidator.unwrapAndCheckSignature(valData.value, null, requestObject.getPassport(), requestObject.getSigningSession(), requestObject.getCAFCookie(), false, false);
            }
            if (!res) {
                CAFLog.error("invalid variable", "name", valData.name, "value", valData.value);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 1);
        }
    }

    public static boolean validateVariableApi(CAFValidationData valData) throws CAFException {
        try {
            boolean res = false;
            if (CAFConfig.m_validationEnabled) {
                if (valData.name == null) {
                    valData.name = new String();
                }
                if (valData.value == null) {
                    valData.value = new String();
                }
                if (!(res = CAFRules.isVariableValidApi(valData))) {
                    CAFLog.error("HSC - validateVariableAPI - ", "name", valData.name, "value", valData.value);
                    CAFLog.error("invalid variable", "name", valData.name, "value", valData.value);
                }
                return res;
            }
            return true;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 1);
        }
    }

    public static boolean validateCookie(CAFValidationData valData, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean res = false;
            res = valData.name.toLowerCase().equals(CRN_cookie) ? CAFValidator.extractSkinProperty(valData, requestObject) : CAFRules.isCookieValid(valData, requestObject);
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 10);
        }
    }

    private static boolean extractSkinProperty(CAFValidationData valData, CAFRequestObject requestObject) throws CAFException {
        try {
            boolean res = true;
            boolean changed = false;
            String intermediate = valData.value;
            StringBuffer modified = new StringBuffer(valData.value.length());
            while (CAFUtil.perfURLDecode(intermediate.toCharArray(), modified)) {
                intermediate = modified.toString();
                modified = new StringBuffer(intermediate.length());
                changed = true;
            }
            if (changed) {
                valData.value = intermediate;
            }
            Matcher m_skin = extractCRNskin.matcher(valData.value);
            while (m_skin.find() && res) {
                int count = m_skin.groupCount();
                valData.name = CRN_skin;
                valData.value = m_skin.group(1);
                res = CAFRules.isCookieValid(valData, requestObject);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 15);
        }
    }

    public boolean verifyUnwrapContextId(String contextId) throws CAFException {
        try {
            boolean res = false;
            if (contextId.length() == 0) {
                CAFLog.error("invalid length 0 context id");
            }
            if (!res) {
                CAFLog.error("context id validation failed", "context id", contextId);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFValidatorException(e, 6);
        }
    }
}

