/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.cache;

import com.cognos.caf.cache.CAFCMCache;
import com.cognos.caf.cache.CAFCacheException;
import com.cognos.caf.cache.ICAFACLCapabilityCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;

public class CAFACLCapabilityCache
extends CAFCMCache
implements ICAFACLCapabilityCache {
    private static ICAFACLCapabilityCache m_instance = new CAFACLCapabilityCache();
    public static boolean m_checkCapabilities = true;

    public static boolean staticCheckCapability(String passport, String capability, boolean throwOnSOAPFault) throws CAFException {
        try {
            boolean res = true;
            if (m_checkCapabilities) {
                res = m_instance.checkCapability(passport, capability);
            }
            return res;
        }
        catch (CAFException e) {
            Exception cause = e.getRootCause();
            if (cause != null && cause instanceof SoapFaultException && !throwOnSOAPFault) {
                return false;
            }
            throw e;
        }
    }

    public static void staticFlushCapabilities(String passport) throws CAFException {
        m_instance.flushCapabilities(passport);
    }

    public static HashSet staticGetCapabilities(String passport, boolean throwOnSOAPFault) throws CAFException {
        try {
            return m_instance.getCapabilities(passport);
        }
        catch (CAFException e) {
            Exception cause = e.getRootCause();
            if (cause != null && cause instanceof SoapFaultException && !throwOnSOAPFault) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void flushCapabilities(String passport) throws CAFException {
        if (passport != null) {
            super.put(passport, null);
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("cached capabilities flushed", "passport", passport, 10000);
            }
        }
    }

    @Override
    public HashSet getCapabilities(String passport) throws CAFException {
        if (passport == null) {
            throw new CAFCacheException(12);
        }
        HashSet capabilities = (HashSet)this.get(passport);
        if (capabilities == null) {
            capabilities = this.addEntry(passport);
        }
        if (capabilities != null) {
            capabilities = (HashSet)capabilities.clone();
        }
        if (CAFLog.isTracingEnabled) {
            CAFLog.trace("get capabilities", "capabilities", capabilities == null ? null : capabilities.toString(), "passport", passport, 10000);
        }
        return capabilities;
    }

    @Override
    public boolean checkCapability(String passport, String capability) throws CAFException {
        boolean res = false;
        try {
            if (CAFLog.isTracingEnabled) {
                CAFLog.trace("check capability", "capability", capability, 10000);
            }
            if (passport == null) {
                throw new CAFCacheException(12);
            }
            HashSet entry = (HashSet)this.get(passport);
            if (entry == null) {
                entry = this.addEntry(passport);
            }
            if (entry != null) {
                res = entry.contains(capability);
            }
        }
        catch (Exception e) {
            throw new CAFCacheException(e, 0);
        }
        return res;
    }

    private HashSet addEntry(String passport) throws CAFException {
        HashSet<String> entry = null;
        try {
            ContentManagerQueryCommand cmd = new ContentManagerQueryCommand("~~");
            cmd.addQueryPropertyName("userCapabilities");
            Element cam = super.getCAMElement(passport);
            cmd.addCAMElement(cam);
            cmd.execute();
            if (cmd.isResponseReceived()) {
                entry = new HashSet<String>();
                Element result = cmd.getQueryResponseElement();
                List items = result.selectNodes(".//value/item");
                if (items.size() > 0) {
                    for (Element e : items) {
                        entry.add(e.getText());
                    }
                } else {
                    CAFLog.trace("no capabilities exist for user", 10000);
                }
                super.put(passport, entry);
                if (CAFLog.isTracingEnabled) {
                    CAFLog.trace("capabilities cached", "passport", passport, "capabilities", entry.toString(), 10000);
                }
            } else {
                CAFLog.error("did not receive response from CM ACL check");
            }
        }
        catch (Exception e) {
            if (e instanceof SoapFaultException) {
                CAFLog.warn("received SOAP fault during capability check", "details", ((SoapFaultException)e).getDetail());
            }
            throw new CAFCacheException(e, 1);
        }
        return entry;
    }
}

