/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.cache;

import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.caf.cache.CAFCacheException;
import com.cognos.caf.cache.CAFGenericCache;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFWeb64;
import java.io.ByteArrayOutputStream;

public class CAFHmacCache
extends CAFGenericCache {
    private static CAFHmacCache m_instance = new CAFHmacCache();

    public static String getWrappedHMAC(String str, String passport, byte[] salt, SigningSession signingSession) throws CAFCacheException {
        try {
            StringBuffer cacheKey = new StringBuffer(str);
            if (passport != null) {
                cacheKey.append(passport);
            }
            if (salt != null) {
                cacheKey.append(salt);
            }
            String entry = m_instance.getEntry(str, passport, salt, signingSession, cacheKey.toString());
            return entry;
        }
        catch (Exception e) {
            throw new CAFCacheException(e, 20);
        }
    }

    private String getEntry(String str, String passport, byte[] salt, SigningSession signingSession, String cacheKey) throws CAFCacheException {
        String entry = (String)m_instance.get(cacheKey);
        if (entry == null) {
            entry = m_instance.computeEntry(str, passport, salt, signingSession);
            this.put(cacheKey, entry);
        }
        return entry;
    }

    private byte[] HMACandWeb64(String str, String secret, byte[] salt, SigningSession signingSession) throws CAFCacheException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256 + str.length());
            baos.write(str.getBytes("UTF-8"));
            if (secret != null) {
                baos.write(secret.getBytes("UTF-8"));
            }
            if (salt != null) {
                baos.write(salt);
            }
            byte[] hmac = null;
            try {
                hmac = signingSession.hmac(baos.toByteArray());
            }
            catch (Exception e) {
                throw new CAFCacheException(e, 2);
            }
            byte[] hmacWeb64 = CAFWeb64.encode(hmac);
            return hmacWeb64;
        }
        catch (Exception e) {
            throw new CAFCacheException(e, 4);
        }
    }

    private String computeEntry(String str, String passport, byte[] salt, SigningSession signingSession) throws CAFCacheException {
        try {
            int strLen = str.length();
            byte[] passportIdHMACWeb64 = this.HMACandWeb64(str, passport, salt, signingSession);
            byte[] hmacsLenByte = new byte[]{(byte)passportIdHMACWeb64.length};
            byte[] dataLenByte = new byte[]{(byte)(strLen >> 24 & 0xFF), (byte)(strLen >> 16 & 0xFF), (byte)(strLen >> 8 & 0xFF), (byte)(strLen & 0xFF)};
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256 + strLen);
            baos.write(CAFUtil.byteToHex(hmacsLenByte));
            baos.write(CAFUtil.byteToHex(dataLenByte));
            baos.write(passportIdHMACWeb64);
            StringBuffer buf = new StringBuffer(128 + strLen);
            if (salt != null) {
                buf.append("CAFA");
            } else {
                buf.append("CAFS");
            }
            buf.append(baos.toString("UTF-8"));
            if (strLen > 0) {
                buf.append(str);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new CAFCacheException(e, 4);
        }
    }
}

