/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public abstract class CAFException
extends Exception {
    public static final int MAX_STATUS = 199;
    public static final int INVALID_STATUS = 0;
    public static final int NO_BASE_STATUS_FOR_CLASS_NAME = 1;
    public static final int EXTERNAL_EXCEPTION = 2;
    public static final int NO_CLASS_STATUS_DESCRIPTION = 3;
    public static final int NO_DESCRIPTION_FOR_STATUS = 4;
    private static final int MAX_DEPTH = 128;
    private static HashMap m_baseStatuses = new HashMap();
    private static HashMap m_statusDescriptions = new HashMap();
    private int m_status = -1;
    private int m_classRelativeStatus = -1;
    private String m_statusDescription = null;
    private Exception m_cause = null;
    private String m_detail = null;
    private static final String m_INVALID_STATUS = "invalid status";
    private static final String m_NO_BASE_STATUS_FOR_CLASS_NAME = "no base status for class name";
    private static final String m_NO_CLASS_STATUS_DESCRIPTION = "no class status description";
    private static final String m_NO_DESCRIPTION_FOR_STATUS = "no description defined for status";

    protected static void addStatusDescription(String className, int status, String description) {
        HashMap<Integer, String> classStatusDes = (HashMap<Integer, String>)m_statusDescriptions.get(className);
        if (classStatusDes == null) {
            classStatusDes = new HashMap<Integer, String>();
            m_statusDescriptions.put(className, classStatusDes);
        }
        classStatusDes.put(new Integer(status), description);
    }

    public CAFException(Exception cause) {
        this(cause, 2);
    }

    public CAFException(Exception cause, int status) {
        this(status);
        this.m_cause = cause;
    }

    public CAFException(int status) {
        this.setStatus(status);
    }

    public Exception getRootCause() {
        Exception e = null;
        if (this.m_cause != null) {
            e = this.m_cause;
            for (int depth = 0; e != null && e instanceof CAFException && depth < 128; ++depth) {
                e = ((CAFException)e).m_cause;
            }
            if (e != null && e instanceof CAFException) {
                e = null;
            }
        }
        return e;
    }

    public void setDetail(String detail) {
        this.m_detail = detail;
    }

    public int getClassRelativeStatus() {
        return this.m_classRelativeStatus;
    }

    private Exception _printTraceInformation(PrintStream ps, CAFException e) {
        Exception rootException = e;
        if (e.m_cause != null) {
            rootException = e.m_cause;
            if (e.m_cause instanceof CAFException) {
                rootException = this._printTraceInformation(ps, (CAFException)e.m_cause);
            }
        }
        String className = e.getClass().getName();
        String strStatus = new Integer(e.m_status).toString();
        ps.println("\tStatus " + (strStatus.length() < 4 ? new String("    ").substring(0, 4 - strStatus.length()) : "") + strStatus + " - " + e.m_statusDescription + " (" + className + ")");
        if (e.m_detail != null) {
            ps.println("        Detail: " + e.m_detail);
        }
        return rootException;
    }

    public String getTraceInformation() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println("CAF status stack:");
        Exception rootException = this._printTraceInformation(ps, this);
        ps.println("Java call stack of root cause:");
        rootException.printStackTrace(ps);
        String str = null;
        try {
            str = baos.toString("UTF-8");
        }
        catch (Exception e) {
            str = "exception - invalid UTF-8 format: " + e.getMessage();
        }
        return str;
    }

    private void setStatus(int status) {
        this.m_classRelativeStatus = status;
        this.m_status = status;
        if (this.m_status < 0 || this.m_status > 199) {
            this.m_statusDescription = m_INVALID_STATUS;
        } else {
            String className = this.getClass().getName();
            Integer baseStatus = (Integer)m_baseStatuses.get(className);
            if (baseStatus == null) {
                this.m_statusDescription = m_NO_BASE_STATUS_FOR_CLASS_NAME;
            } else {
                this.m_status = baseStatus + status;
                this.m_statusDescription = this.getStatusDescription(className, status);
            }
        }
    }

    private void _printIntStatusList(StringBuffer buf, CAFException e) {
        boolean last = false;
        if (e.m_cause != null & e.m_cause instanceof CAFException) {
            this._printIntStatusList(buf, (CAFException)e.m_cause);
        } else {
            last = true;
        }
        if (!last) {
            buf.append(", ");
        }
        buf.append(e.m_status);
    }

    public String getIntStatusList() {
        StringBuffer buf = new StringBuffer(1024);
        this._printIntStatusList(buf, this);
        return buf.toString();
    }

    private String getStatusDescription(String className, int status) {
        String description = null;
        HashMap classStatusDescription = (HashMap)m_statusDescriptions.get(className);
        if (classStatusDescription == null) {
            description = "no class status description- class name: " + className;
        } else {
            description = (String)classStatusDescription.get(new Integer(status));
            if (description == null) {
                description = m_NO_DESCRIPTION_FOR_STATUS;
            }
        }
        return description;
    }

    static {
        String CLASS_PREFIX = "com.cognos.caf.";
        m_baseStatuses.put("com.cognos.caf.common.CAFException", new Integer(0));
        m_baseStatuses.put("com.cognos.caf.Application", new Integer(200));
        m_baseStatuses.put("com.cognos.caf.CAFFirewallException", new Integer(400));
        m_baseStatuses.put("com.cognos.caf.CAFValidatorException", new Integer(600));
        m_baseStatuses.put("com.cognos.caf.CAFProtectorException", new Integer(800));
        m_baseStatuses.put("com.cognos.caf.common.CAFCommonException", new Integer(1000));
        m_baseStatuses.put("com.cognos.caf.config.CAFConfigException", new Integer(1200));
        m_baseStatuses.put("com.cognos.caf.rule.CAFRuleException", new Integer(1400));
        m_baseStatuses.put("com.cognos.caf.logging.CAFLoggingException", new Integer(1800));
        m_baseStatuses.put("com.cognos.caf.cache.CAFCacheException", new Integer(2000));
        m_baseStatuses.put("com.cognos.caf.CAFLibraryPrivateException", new Integer(2200));
        m_baseStatuses.put("com.cognos.caf.CAFXMLHandlerException", new Integer(2400));
        m_baseStatuses.put("com.cognos.caf.CAFCookieException", new Integer(2600));
        m_baseStatuses.put("com.cognos.caf.CAFHandlerException", new Integer(2800));
    }
}

