/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.common;

import com.cognos.caf.common.CAFException;
import com.cognos.caf.logging.CAFLog;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.GregorianCalendar;

public class CAFUtil {
    private static String m_defaultEncoding;
    private static final String[] hexURLBytes;
    private static boolean[] dontNeedEncoding;

    public static void urlEncode(byte[] bytes, StringBuffer buf) throws CAFException {
        int length = bytes.length;
        int ch = -1;
        for (int i = 0; i < length; ++i) {
            ch = bytes[i];
            if (ch >= 0 && ch <= 127) {
                if (dontNeedEncoding[ch]) {
                    buf.append((char)ch);
                    continue;
                }
                if (ch == 32) {
                    buf.append('+');
                    continue;
                }
                buf.append(hexURLBytes[ch]);
                continue;
            }
            ch = 128 + (bytes[i] & 0x7F);
            buf.append(hexURLBytes[ch]);
        }
    }

    public static String getDefaultEncoding() {
        return m_defaultEncoding;
    }

    public static boolean isHexDigit(int ch) {
        return ch >= 97 && ch <= 102 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90;
    }

    public static boolean perfURLDecode(char[] str, StringBuffer outBuf) {
        boolean decoded = false;
        int h1 = -1;
        int h2 = -1;
        int c = 0;
        int pos = -1;
        int strLen = str.length;
        for (pos = 0; pos < strLen; ++pos) {
            c = str[pos];
            if (c != 37 && c != 43 || (c != 37 || pos + 2 >= strLen || !CAFUtil.isHexDigit(str[pos + 1]) || !CAFUtil.isHexDigit(str[pos + 2])) && c != 43) continue;
            if (pos > 0) {
                outBuf.append(str, 0, pos);
            }
            decoded = true;
            break;
        }
        if (decoded) {
            int tempbuflen = (strLen - pos + 1) * 2;
            char[] tempbuf = new char[tempbuflen];
            int tempbufidx = -1;
            while (pos < strLen) {
                c = str[pos];
                if (c == 37 && pos + 2 < strLen && CAFUtil.isHexDigit(h1 = str[pos + 1]) && CAFUtil.isHexDigit(h2 = str[pos + 2])) {
                    h1 = h1 >= 48 && h1 <= 57 ? (h1 -= 48) : (h1 >= 97 && h1 <= 102 ? 10 + h1 - 97 : 10 + h1 - 65);
                    h2 = h2 >= 48 && h2 <= 57 ? (h2 -= 48) : (h2 >= 97 && h2 <= 102 ? 10 + h2 - 97 : 10 + h2 - 65);
                    tempbuf[++tempbufidx] = (char)((h1 << 4) + h2);
                    pos += 2;
                } else {
                    tempbuf[++tempbufidx] = c == 43 ? 32 : c;
                }
                ++pos;
            }
            if (tempbufidx >= 0) {
                outBuf.append(tempbuf, 0, tempbufidx + 1);
            }
        }
        return decoded;
    }

    public static boolean htmlDecode(char[] urlData, StringBuffer outBuf) {
        boolean decode = false;
        boolean res = false;
        int num = -1;
        int h1 = 0;
        int h2 = 0;
        char c0 = '\u0000';
        char c1 = '\u0000';
        char c2 = '\u0000';
        int c3 = 0;
        int c4 = 0;
        char c5 = '\u0000';
        int udLen = urlData.length;
        int pos = -1;
        pos = CAFUtil.indexOf(urlData, '&');
        if (pos != -1) {
            outBuf.ensureCapacity(urlData.length * 2);
            if (pos > 0) {
                outBuf.append(urlData, 0, pos);
            }
        }
        if (pos != -1) {
            int tempbuflen = (udLen - pos + 1) * 2;
            char[] tempbuf = new char[tempbuflen];
            int tempbufidx = -1;
            for (int i = pos; i < udLen; ++i) {
                decode = false;
                c0 = urlData[i];
                if (c0 == '&' && i + 3 < udLen) {
                    c1 = urlData[i + 1];
                    c2 = urlData[i + 2];
                    c3 = urlData[i + 3];
                    if (i + 4 < udLen) {
                        c4 = urlData[i + 4];
                        if (i + 5 < udLen) {
                            c5 = urlData[i + 5];
                        }
                    }
                    if (c3 == 59) {
                        if (c1 == 'l' && c2 == 't' || c1 == 'L' && c2 == 'T') {
                            tempbuf[++tempbufidx] = 60;
                            decode = true;
                            i += 3;
                        } else if (c1 == 'g' && c2 == 't' || c1 == 'G' && c2 == 'T') {
                            tempbuf[++tempbufidx] = 62;
                            decode = true;
                            i += 3;
                        }
                    } else if (i + 4 < udLen && (c1 == 'a' && c2 == 'm' && c3 == 112 || c1 == 'A' && c2 == 'M' && c2 == 'P') && c4 == 59) {
                        tempbuf[++tempbufidx] = 38;
                        decode = true;
                        i += 4;
                    } else if (c1 == '#') {
                        if (c2 >= '0' && c2 <= '9') {
                            if (c3 == 59) {
                                tempbuf[++tempbufidx] = (char)(c2 - 48);
                                decode = true;
                                i += 3;
                            } else if (i + 4 < udLen && c3 >= 48 && c3 <= 57 && c4 == 59) {
                                tempbuf[++tempbufidx] = (char)((c2 - 48) * 10 + c3 - 48);
                                decode = true;
                                i += 4;
                            } else if (i + 5 < udLen && c3 >= 48 && c3 <= 57 && c4 >= 0 && c4 <= 57 && c5 == ';' && (num = (c2 - 48) * 100 + (c3 - 48) * 10 + c4 - 48) < 256) {
                                tempbuf[++tempbufidx] = (char)num;
                                decode = true;
                                i += 5;
                            }
                        } else if (c2 == 'x' && i + 4 < udLen && CAFUtil.isHexDigit(c3)) {
                            h1 = 0;
                            h2 = 0;
                            if (c4 == 59) {
                                h2 = c3;
                                decode = true;
                                i += 4;
                            } else if (i + 5 < udLen && CAFUtil.isHexDigit(c4) && c5 == ';') {
                                h1 = c3;
                                h2 = c4;
                                decode = true;
                                i += 5;
                            }
                            if (decode) {
                                if (h1 != 0) {
                                    h1 = h1 >= 48 && h1 <= 57 ? (int)((char)(h1 - 48)) : (h1 >= 97 && h1 <= 102 ? (int)((char)(10 + h1 - 97)) : (int)((char)(10 + h1 - 65)));
                                }
                                h2 = h2 >= 48 && h2 <= 57 ? (int)((char)(h2 - 48)) : (h2 >= 97 && h2 <= 102 ? (int)((char)(10 + h2 - 97)) : (int)((char)(10 + h2 - 65)));
                                tempbuf[++tempbufidx] = (char)((h1 << 4) + h2);
                            }
                        }
                    } else if (i + 5 < udLen && (c1 == 'q' && c2 == 'u' && c3 == 111 && c4 == 116 && c5 == ';' || c1 == 'Q' && c2 == 'U' && c3 == 79 && c4 == 84 && c5 == ';')) {
                        tempbuf[++tempbufidx] = 34;
                        decode = true;
                        i += 5;
                    }
                }
                if (decode) {
                    if (res) continue;
                    res = true;
                    continue;
                }
                tempbuf[++tempbufidx] = c0;
            }
            if (tempbufidx >= 0) {
                outBuf.append(tempbuf, 0, tempbufidx + 1);
            }
        }
        if (!res) {
            outBuf.setLength(0);
        }
        return res;
    }

    public static byte[] byteToHex(byte[] bytes) {
        byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        byte[] res = new byte[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            res[i * 2] = HEX_CHARS[(bytes[i] & 0xF0) >> 4];
            res[i * 2 + 1] = HEX_CHARS[bytes[i] & 0xF];
        }
        return res;
    }

    public static byte[] hexToByte(byte[] hex) throws CAFException {
        int hexLen = hex.length;
        byte[] res = new byte[hexLen / 2];
        byte[] resInput = new byte[2];
        long r = -1L;
        int i = 0;
        while (i + 1 < hexLen) {
            resInput[0] = hex[i];
            resInput[1] = hex[i + 1];
            r = CAFUtil.hexToLong(resInput);
            if (r != -1L) {
                res[i / 2] = (byte)r;
            }
            i += 2;
        }
        return res;
    }

    public static long hexToLong(byte[] hex) throws CAFException {
        int hexLen = hex.length;
        if (hexLen != 2) {
            CAFLog.warn("Hex array has more than 2 bytes ");
            return -1L;
        }
        long lr = -1L;
        int i = 0;
        while (i + 1 < hexLen) {
            byte h1 = hex[i];
            byte h2 = hex[i + 1];
            if (CAFUtil.isHexDigit(h1) && CAFUtil.isHexDigit(h2)) {
                lr = h1 >= 48 && h1 <= 57 ? (long)(h1 - 48 << 4) : (h1 >= 97 && h1 <= 102 ? (long)(10 + h1 - 97 << 4) : (long)(10 + h1 - 65 << 4));
                lr = h2 >= 48 && h2 <= 57 ? (lr += (long)(h2 - 48)) : (h2 >= 97 && h2 <= 102 ? (lr += (long)(10 + h2 - 97)) : (lr += (long)(10 + h2 - 65)));
            }
            i += 2;
        }
        return lr;
    }

    public static String getTimeStamp(boolean preciseTimeStamp) {
        GregorianCalendar calendar = new GregorianCalendar();
        Object[] args = new Object[]{new Integer(calendar.get(1)), new Integer(calendar.get(2) + 1), new Integer(calendar.get(5)), new Integer(calendar.get(11)), new Integer(calendar.get(12)), new Integer(calendar.get(13)), new Integer(calendar.get(14))};
        StringBuffer format = new StringBuffer(256);
        format.append("{0,number,0000}-{1,number,00}-{2,number,00} ");
        format.append("{3,number,00}:{4,number,00}:{5,number,00}");
        if (preciseTimeStamp) {
            format.append(".{6,number,000}");
        }
        MessageFormat mf = new MessageFormat(format.toString());
        return mf.format(args);
    }

    public static int indexOf(char[] str, char c) {
        int strlen = str.length;
        for (int i = 0; i < strlen; ++i) {
            if (str[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static void readInputStream(InputStream is, ByteArrayOutputStream baos) throws IOException, CAFException {
        int nBytesRead;
        byte[] buf = new byte[8192];
        do {
            if ((nBytesRead = is.read(buf)) < 0) continue;
            baos.write(buf, 0, nBytesRead);
        } while (nBytesRead >= 0);
    }

    public static int signatureDataLenStrToInt(String str) throws UnsupportedEncodingException {
        int dataLen = -1;
        byte[] dataLenHex = str.getBytes("UTF-8");
        try {
            byte[] dataLenByte = CAFUtil.hexToByte(dataLenHex);
            dataLen = (dataLenByte[0] & 0xFF) << 24;
            dataLen += (dataLenByte[1] & 0xFF) << 16;
            dataLen += (dataLenByte[2] & 0xFF) << 8;
            dataLen += dataLenByte[3] & 0xFF;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataLen;
    }

    public static boolean getUserCapabilty(BIBusEnvelope env, String capability) throws CAFException {
        if (env == null) {
            CAFLog.warn("secure error - null request envelope");
            return false;
        }
        if (capability == null) {
            CAFLog.warn("secure error - null capability");
            return false;
        }
        UserCapabilityCache usercapabilityCache = env.getBiBusHeader().getUserCapabilityCache();
        if (usercapabilityCache == null) {
            CAFLog.warn("secure error - no userCapabilitiesCache");
            return false;
        }
        boolean hasCapability = usercapabilityCache.hasItem(capability);
        if (hasCapability) {
            CAFLog.warn("secure error - found userCapabilities");
            return true;
        }
        CAFLog.warn("secure error - did not find userCapabilities");
        return false;
    }

    static {
        int i;
        m_defaultEncoding = new String("UTF-8");
        hexURLBytes = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
        dontNeedEncoding = new boolean[256];
        for (i = 0; i < 256; ++i) {
            CAFUtil.dontNeedEncoding[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            CAFUtil.dontNeedEncoding[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            CAFUtil.dontNeedEncoding[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            CAFUtil.dontNeedEncoding[i] = true;
        }
        CAFUtil.dontNeedEncoding[45] = true;
        CAFUtil.dontNeedEncoding[95] = true;
        CAFUtil.dontNeedEncoding[46] = true;
        CAFUtil.dontNeedEncoding[33] = true;
        CAFUtil.dontNeedEncoding[126] = true;
        CAFUtil.dontNeedEncoding[42] = true;
        CAFUtil.dontNeedEncoding[39] = true;
        CAFUtil.dontNeedEncoding[40] = true;
        CAFUtil.dontNeedEncoding[41] = true;
    }
}

