/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.config;

import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.ValidDomainManager;
import com.cognos.caf.config.CAFConfigException;
import com.cognos.caf.logging.CAFLog;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class CAFConfig {
    private static final String m_MANUAL_CONFIG_FILE = "cafconfig.xml";
    static final String CAF_TRUE = "true";
    static final String CAF_FALSE = "false";
    private static final String CAF_VALIDATION_ENABLED = "caf_enabled";
    private static final String CAF_CHECK_VALID_DOMAINS = "caf_checkValidDomains";
    private static final String CAF_SECURE_ERROR = "caf_secureError";
    private static final String CAF_SIGNED_REPORT_URLS = "caf_signedReportUrls";
    private static final String CAF_TP_PARAMETERS_BLOCKED = "caf_tpParametersBlocked";
    private static final String CAF_TP_XSS_CHARS = "caf_tpXSSChars";
    private static final String CAF_TP_XSS_CHECKING_USED = "caf_tpXSSCheckingUsed";
    private static final String CAF_TP_SESSION_HEADER = "caf_tpSessionHeader";
    public static final String CAF_GLOBAL_REJECTION_PATTERN = "caf_globalRejectionPattern";
    private static final String CAF_EXTENDED_CONTEXT_ID = "caf_extendedContextId";
    private static final String CAF_USER_CONTEXT_ID = "caf_userContextId";
    private static final String CAF_RESTORE_SDK_BEHAVIOUR = "caf_spoofFixEnabled";
    private static Element m_topManual = null;
    public static HashSet m_validHostPorts = new HashSet();
    public static ValidDomainManager validDomainsManager = new ValidDomainManager();
    public static Vector m_logFilterPatterns = new Vector();
    public static boolean m_validationEnabled = false;
    public static String m_tpXSSChars = new String("<'>");
    public static boolean m_tpXSSCheckingUsed = false;
    public static boolean m_tpParametersBlocked = false;
    public static boolean m_checkValidDomains = false;
    public static String m_tpSessionHeader = null;
    public static boolean m_extendedContextId = true;
    public static boolean m_secureError = true;
    public static boolean m_signedReportUrls = false;
    public static String m_globalRejectionPattern = null;
    public static int m_spoofFixEnabled = 0;

    private static void configureURLDomainHost(ICCLConfiguration cclConfig) throws CAFException {
        String hostPort = CAFConfig.fetchCCLGatewayValue(cclConfig);
        CAFConfig.addValidHostDomain(hostPort);
        hostPort = CAFConfig.fetchCCLInternalDispatcher(cclConfig);
        CAFConfig.addValidHostDomain(hostPort);
    }

    public static String fetchCCLGatewayValue(ICCLConfiguration cclConfig) throws CAFException {
        String gateway = CAFConfig.fetchCCLConfigEntry(cclConfig, "gateway");
        return gateway;
    }

    public static String fetchCCLInternalDispatcher(ICCLConfiguration cclConfig) throws CAFException {
        String dispatcher = CAFConfig.fetchCCLConfigEntry(cclConfig, "internalDispatcher");
        return dispatcher;
    }

    public static String fetchCCLConfigEntry(ICCLConfiguration cclConfig, String entryName) throws CAFException {
        String configValue = null;
        try {
            configValue = cclConfig.getValue(entryName, false);
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 6);
        }
        configValue = CAFConfig.extractHostPort(configValue);
        return configValue;
    }

    private static String extractHostPort(String originalURL) throws CAFException {
        if (originalURL.length() > 0) {
            URL url = null;
            try {
                originalURL = originalURL.toLowerCase();
                if (originalURL.startsWith("https")) {
                    originalURL = "http" + originalURL.substring("https".length());
                }
                url = new URL(originalURL.toLowerCase());
            }
            catch (Exception e) {
                throw new CAFConfigException(e, 7);
            }
            String host = url.getHost();
            StringBuffer hostPort = new StringBuffer(host);
            if (url.getPort() > 0) {
                hostPort.append(':');
                hostPort.append(url.getPort());
            }
            originalURL = hostPort.toString();
        }
        return originalURL;
    }

    private static void enableDefaultValidation() {
        m_checkValidDomains = true;
        m_signedReportUrls = true;
        m_logFilterPatterns.add("Trusted_Connection");
        m_logFilterPatterns.add("m_connection_userid");
    }

    public static void initialize(ICCLConfiguration cclConfig, String configDirPath) throws CAFException {
        try {
            CAFConfig.cclConfigure(cclConfig);
            if (m_validationEnabled) {
                CAFConfig.enableDefaultValidation();
            }
            CAFConfig.fileConfigure(configDirPath);
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 8);
        }
        try {
            CAFConfig.checkConfig();
            CAFConfig.configureURLDomainHost(cclConfig);
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 17);
        }
    }

    public static void lateInitialize(ICCLConfiguration cclConfig) throws CAFException {
        try {
            CAFConfig.checkConfig();
            CAFConfig.configureURLDomainHost(cclConfig);
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 17);
        }
    }

    public static Element getTopManual() {
        return m_topManual;
    }

    private static void cclConfigure(ICCLConfiguration cclConfig) throws CAFConfigException {
        try {
            String sSection = "CAF";
            Element topCCL = cclConfig.getValueElement(sSection, false);
            if (topCCL == null) {
                throw new CAFConfigException(21);
            }
            String CRN_PARAMETER_TAG = "parameter";
            Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
            QName qnParameter = new QName(CRN_PARAMETER_TAG, nsCRN);
            List parameterElementList = topCCL.elements(qnParameter);
            int length = parameterElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                Element parameterNode = (Element)parameterElementList.get(loop);
                Attribute nameAttr = (Attribute)parameterNode.selectSingleNode("@name");
                if (nameAttr.getValue().equals("caf_validDomainList")) {
                    List itemNodes = parameterNode.selectNodes("./crn:value/crn:item");
                    for (Element item : itemNodes) {
                        CAFConfig.addValidHostDomain(item.getText());
                    }
                    continue;
                }
                Element valueNode = (Element)parameterNode.selectSingleNode("./crn:value");
                CAFConfig.setValue(nameAttr.getValue(), valueNode.getText());
            }
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 3);
        }
    }

    private static void fileConfigure(String cafDirPath) throws CAFException {
        File file = new File(cafDirPath, m_MANUAL_CONFIG_FILE);
        if (file.canRead()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (Exception e) {
                throw new CAFConfigException(e, 4);
            }
            CAFConfig.manualConfigure(is);
        }
    }

    private static void manualConfigure(InputStream is) throws CAFException {
        try {
            Document doc = null;
            SAXReader reader = new SAXReader();
            doc = reader.read(is);
            String sSection = "CAF";
            m_topManual = (Element)doc.selectSingleNode("/crn:parameters/crn:parameter[@name=\"" + sSection + "\"]");
            List parameterNodes = doc.selectNodes("/crn:parameters/crn:parameter[@name=\"" + sSection + "\"]/crn:value/crn:parameter");
            for (Element parameterNode : parameterNodes) {
                Attribute nameAttr = (Attribute)parameterNode.selectSingleNode("@name");
                Element valueNode = (Element)parameterNode.selectSingleNode("./crn:value");
                CAFConfig.setValue(nameAttr.getValue(), valueNode.getText());
            }
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 5);
        }
    }

    public static void refreshConfig(String config) throws CAFException {
        try {
            validDomainsManager.clear();
            m_validHostPorts.clear();
            ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes("UTF-8"));
            CAFConfig.manualConfigure(bais);
            CAFConfig.checkConfig();
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 23);
        }
    }

    private static void addValidHostDomain(String hostDomainValue) throws CAFException {
        block15: {
            try {
                hostDomainValue = hostDomainValue.trim().toLowerCase();
                if (hostDomainValue.length() <= 0 || validDomainsManager.addDomain(hostDomainValue)) break block15;
                String localHostName = null;
                String FQHostName = null;
                m_validHostPorts.add(hostDomainValue);
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    FQHostName = localMachine.getCanonicalHostName().toLowerCase();
                    localHostName = localMachine.getHostName().toLowerCase();
                }
                catch (UnknownHostException uhe) {
                    CAFLog.trace("local host name lookup failed", "exception message", uhe.getMessage(), 30000);
                }
                try {
                    if (localHostName != null && localHostName.length() > 0) {
                        URL urlHostDomain = new URL("http://" + hostDomainValue.toLowerCase());
                        String host = urlHostDomain.getHost();
                        int port = urlHostDomain.getPort();
                        if ("localhost".equals(host)) {
                            if (port != -1) {
                                localHostName = localHostName + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHostName);
                        } else if (localHostName.equals(host)) {
                            String localHost = "localhost";
                            if (port != -1) {
                                localHost = localHost + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHost);
                        } else if (FQHostName.equals(host)) {
                            String localHost = "localhost";
                            if (port != -1) {
                                localHost = localHost + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHost);
                        }
                    }
                }
                catch (MalformedURLException mue) {
                    CAFLog.trace("URL conversion for hostname failed", "exception message", mue.getMessage(), 30000);
                }
            }
            catch (Exception e) {
                throw new CAFConfigException(e, 10);
            }
        }
    }

    private static void setValue(String name, String val) throws CAFException {
        try {
            if (name.equals(CAF_VALIDATION_ENABLED)) {
                m_validationEnabled = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_TP_XSS_CHARS)) {
                m_tpXSSChars = val;
            } else if (name.equals(CAF_TP_XSS_CHECKING_USED)) {
                m_tpXSSCheckingUsed = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_SECURE_ERROR)) {
                m_secureError = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_CHECK_VALID_DOMAINS)) {
                m_checkValidDomains = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_TP_PARAMETERS_BLOCKED)) {
                m_tpParametersBlocked = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_SIGNED_REPORT_URLS)) {
                m_signedReportUrls = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_EXTENDED_CONTEXT_ID) || name.equals(CAF_USER_CONTEXT_ID)) {
                m_extendedContextId = val.equals(CAF_TRUE);
            } else if (name.equals(CAF_TP_SESSION_HEADER)) {
                if (val.length() > 0) {
                    m_tpSessionHeader = val;
                }
            } else if (name.equals(CAF_GLOBAL_REJECTION_PATTERN)) {
                m_globalRejectionPattern = val;
                if (m_globalRejectionPattern.length() == 0) {
                    m_globalRejectionPattern = null;
                } else {
                    CAFPatternCache.precompile(m_globalRejectionPattern);
                }
            } else if (name.equals(CAF_RESTORE_SDK_BEHAVIOUR)) {
                try {
                    m_spoofFixEnabled = Integer.parseInt(val);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 11);
        }
    }

    private static void checkConfig() throws CAFException {
        try {
            if (m_tpXSSCheckingUsed && m_tpXSSChars.length() == 0) {
                throw new CAFConfigException(15);
            }
            int count = m_logFilterPatterns.size();
            int current = 0;
            if (count > 0) {
                try {
                    for (current = 0; current < count; ++current) {
                        String pattern = (String)m_logFilterPatterns.elementAt(current);
                        CAFPatternCache.precompile(pattern);
                    }
                }
                catch (Exception e) {
                    String pattern = (String)m_logFilterPatterns.elementAt(current);
                    CAFLog.error("rrror while compiling log filter pattern", "pattern", pattern);
                    throw new CAFConfigException(e, 19);
                }
            }
            HashSet<String> validDomains = validDomainsManager.getValidDomains();
            String domain2 = null;
            for (String domain2 : validDomains) {
                if (domain2.length() >= 4 && domain2.indexOf(46, 1) != -1) continue;
                CAFLog.error("top level domains such as .ca and .com disallowed", "domain", domain2);
                throw new CAFConfigException(9);
            }
        }
        catch (Exception e) {
            throw new CAFConfigException(e, 14);
        }
    }
}

