/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.logging;

import com.cognos.caf.CAFMessageStrings;
import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.config.CAFConfig;
import com.cognos.caf.logging.BuildInfo;
import com.cognos.caf.logging.CAFLoggingException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CAFLog {
    public static final String CAF = "caf";
    public static final String GENERAL = "general";
    public static final String LIBRARY = "library";
    public static final String REQUEST = "request";
    public static final String RULE = "rule";
    public static final String PROTECTOR = "protector";
    public static final String VALIDATOR = "validator";
    public static final String SENSITIVE_CAF_COOKIE = "CAF cookie";
    public static final String SENSITIVE_CAF_COOKIE_BUFFER = "CAF cookie buffer";
    public static final String SENSITIVE_PASSPORT = "passport";
    public static final String SENSITIVE_PASSPORT_LIST = "passport list";
    public static final int TOP = 50000;
    public static final int INFO = 30000;
    public static final int DEBUG = 10000;
    private static final int WARNING_LEVEL = 40000;
    public static final int m_METHOD_FILE = 0;
    public static final int m_METHOD_IPF = 1;
    public static boolean isTracingEnabled = false;
    private static boolean m_enabled = false;
    private static LogTypedLogger m_auditLogger = null;
    private static Map m_traceLoggers = new HashMap();
    private static Set m_sensitiveArgDescs = new HashSet();
    private static int m_buildVersion = 0;

    public static void initialize() throws CAFException {
        try {
            m_sensitiveArgDescs.add(SENSITIVE_CAF_COOKIE);
            m_sensitiveArgDescs.add(SENSITIVE_CAF_COOKIE_BUFFER);
            m_sensitiveArgDescs.add(SENSITIVE_PASSPORT);
            m_sensitiveArgDescs.add(SENSITIVE_PASSPORT_LIST);
            m_buildVersion = BuildInfo.getVersion();
            m_traceLoggers.put(GENERAL, LogTypedLogger.getInstance((String)"Trace.caf.general", LogTraceIndication.class));
            m_traceLoggers.put(LIBRARY, LogTypedLogger.getInstance((String)"Trace.caf.library", LogTraceIndication.class));
            m_traceLoggers.put(REQUEST, LogTypedLogger.getInstance((String)"Trace.caf.request", LogTraceIndication.class));
            m_traceLoggers.put(RULE, LogTypedLogger.getInstance((String)"Trace.caf.rule", LogTraceIndication.class));
            m_traceLoggers.put(PROTECTOR, LogTypedLogger.getInstance((String)"Trace.caf.protector", LogTraceIndication.class));
            m_traceLoggers.put(VALIDATOR, LogTypedLogger.getInstance((String)"Trace.caf.validator", LogTraceIndication.class));
            m_auditLogger = LogTypedLogger.getInstance((String)"Audit.caf", LogAuditIndication.class);
            Collection col = m_traceLoggers.values();
            LogTypedLogger logger = null;
            Iterator i = col.iterator();
            while (i.hasNext() && !isTracingEnabled) {
                logger = (LogTypedLogger)i.next();
                isTracingEnabled = logger.isEnabled(50000);
            }
            m_enabled = true;
        }
        catch (Exception e) {
            throw new CAFLoggingException(e, 2);
        }
    }

    private static void formatLog(String logType, String msg, String argDesc, String arg, String argDesc2, String arg2, StringBuffer line1, StringBuffer line2) {
        StringBuffer header = new StringBuffer(1024);
        if (logType != null) {
            header.append(logType);
            header.append(" - ");
        }
        header.append(msg);
        if (argDesc == null && argDesc2 == null) {
            line1.append(header);
        } else {
            MessageFormat mf2;
            Object[] args2;
            if (argDesc != null) {
                args2 = new Object[]{header, argDesc, arg == null ? "null" : arg};
                mf2 = new MessageFormat("{0}: {1} => {2}");
                line1.append(mf2.format(args2));
            }
            if (argDesc2 != null) {
                args2 = new Object[]{header, argDesc2, arg2 == null ? "null" : arg2};
                mf2 = new MessageFormat("{0}: {1} => {2}");
                line2.append(mf2.format(args2));
            }
        }
    }

    private static void logToIPFAudit(int indicationLevel, String status, String msg, String argDesc, String arg, String argDesc2, String arg2) throws CAFException {
        try {
            if (m_auditLogger.isEnabled(indicationLevel)) {
                StringBuffer line1 = new StringBuffer(1024);
                StringBuffer line2 = new StringBuffer(1024);
                CAFLog.formatLog(null, msg, argDesc, arg, argDesc2, arg2, line1, line2);
                LogAuditIndication indication = null;
                if (indicationLevel == 20000 || indicationLevel == 10000) {
                    indication = new LogAuditIndication(CAF, 0);
                } else {
                    LogAuditAccessIndication accessIndication = new LogAuditAccessIndication(CAF, m_buildVersion);
                    accessIndication.setStatus(status);
                    indication = accessIndication;
                }
                indication.setLevel(indicationLevel);
                indication.setOperation("Request");
                if (line1.length() > 0) {
                    indication.setLogData(line1.toString());
                    m_auditLogger.log((Object)indication);
                }
                if (line2.length() > 0) {
                    indication.setLogData(line2.toString());
                    m_auditLogger.log((Object)indication);
                }
            }
        }
        catch (Exception e) {
            throw new CAFLoggingException(e, 4);
        }
    }

    private static void logToIPFTrace(int indicationLevel, String loggerName, String msg, String argDesc, String arg, String argDesc2, String arg2) throws CAFException {
        try {
            LogTypedLogger traceLogger = (LogTypedLogger)m_traceLoggers.get(loggerName);
            if (traceLogger == null) {
                throw new CAFLoggingException(6);
            }
            if (traceLogger.isEnabled(indicationLevel)) {
                StringBuffer line1 = new StringBuffer(1024);
                StringBuffer line2 = new StringBuffer(1024);
                CAFLog.formatLog(null, msg, argDesc, arg, argDesc2, arg2, line1, line2);
                LogTraceIndication indication = new LogTraceIndication(CAF, m_buildVersion);
                indication.setLevel(indicationLevel);
                indication.setObject(CAF);
                indication.setAction((byte)11);
                if (line1.length() > 0) {
                    indication.setMessage(line1.toString());
                    traceLogger.log((Object)indication);
                }
                if (line2.length() > 0) {
                    indication.setMessage(line2.toString());
                    traceLogger.log((Object)indication);
                }
            }
        }
        catch (Exception e) {
            throw new CAFLoggingException(e, 5);
        }
    }

    private static String checkForSensitiveData(String str) throws CAFException {
        String res = str;
        String matchPattern = null;
        if (str != null) {
            for (String pattern : CAFConfig.m_logFilterPatterns) {
                if (!CAFPatternCache.match(str, pattern)) continue;
                matchPattern = pattern;
                break;
            }
        }
        if (matchPattern != null) {
            res = "[Suppressed because of match with pattern: " + matchPattern + " ]";
        }
        return res;
    }

    public static void error(String msg) throws CAFException {
        CAFLog.error(msg, null, null, null, null);
    }

    public static void error(String msg, String arg1, String arg2) throws CAFException {
        CAFLog.error(msg, arg1, arg2, null, null);
    }

    private static String suppressArg(String arg) {
        if (arg != null) {
            arg = "[Sensitive data suppressed. Enable tracing to obtain original.]";
        }
        return arg;
    }

    public static void error(String msg, String argDesc, String arg, String argDesc2, String arg2) throws CAFException {
        if (m_enabled) {
            msg = CAFLog.checkForSensitiveData(msg);
            arg = CAFLog.checkForSensitiveData(arg);
            arg2 = CAFLog.checkForSensitiveData(arg2);
            if (!isTracingEnabled) {
                if (m_sensitiveArgDescs.contains(argDesc)) {
                    arg = CAFLog.suppressArg(arg);
                }
                if (m_sensitiveArgDescs.contains(argDesc2)) {
                    arg2 = CAFLog.suppressArg(arg2);
                }
            }
            CAFLog.logToIPFAudit(50000, "Failure", msg, argDesc, arg, argDesc2, arg2);
        }
    }

    public static void logCAFStatus() throws CAFException {
        if (m_enabled) {
            String msg;
            Locale serverLoc = CAFLog.getServerLocale();
            if (CAFConfig.m_validationEnabled) {
                msg = CAFMessageStrings.get().getString("CAF_ENABLED", serverLoc);
                CAFLog.logToIPFAudit(50000, "Info", msg, null, null, null, null);
            } else {
                msg = CAFMessageStrings.get().getString("CAF_DISABLED", serverLoc);
                CAFLog.logToIPFAudit(50000, "Warning", msg, null, null, null, null);
            }
            if (CAFConfig.m_tpXSSCheckingUsed) {
                msg = CAFMessageStrings.get().getString("CAF_XSS_ENABLED", serverLoc);
                CAFLog.logToIPFAudit(50000, "Info", msg, null, null, null, null);
            } else {
                msg = CAFMessageStrings.get().getString("CAF_XSS_DISABLED", serverLoc);
                CAFLog.logToIPFAudit(50000, "Info", msg, null, null, null, null);
            }
        }
    }

    public static void warn(String msg) throws CAFException {
        CAFLog.warn(msg, null, null, null, null);
    }

    public static void warn(String msg, String argDesc, String arg) throws CAFException {
        CAFLog.warn(msg, argDesc, arg, null, null);
    }

    public static void warn(String msg, String argDesc, String arg, String argDesc2, String arg2) throws CAFException {
        if (m_enabled && m_auditLogger.isEnabled(40000)) {
            msg = CAFLog.checkForSensitiveData(msg);
            arg = CAFLog.checkForSensitiveData(arg);
            arg2 = CAFLog.checkForSensitiveData(arg2);
            CAFLog.logToIPFAudit(40000, "Warning", msg, argDesc, arg, argDesc2, arg2);
        }
    }

    public static void trace(String msg, int level) throws CAFException {
        CAFLog.trace(msg, null, null, null, null, level, null);
    }

    public static void trace(String msg, int level, String className) throws CAFException {
        CAFLog.trace(msg, null, null, null, null, level, className);
    }

    public static void trace(String msg, String argDesc, String arg, int level) throws CAFException {
        CAFLog.trace(msg, argDesc, arg, null, null, level, null);
    }

    public static void trace(String msg, String argDesc, String arg, int level, String className) throws CAFException {
        CAFLog.trace(msg, argDesc, arg, null, null, level, className);
    }

    public static void trace(String msg, String argDesc, String arg, String argDesc2, String arg2, int level) throws CAFException {
        CAFLog.trace(msg, argDesc, arg, argDesc2, arg2, level, null);
    }

    public static void trace(String msg, String argDesc, String arg, String argDesc2, String arg2, int indicationLevel, String loggerName) throws CAFException {
        if (m_enabled && isTracingEnabled) {
            msg = CAFLog.checkForSensitiveData(msg);
            arg = CAFLog.checkForSensitiveData(arg);
            arg2 = CAFLog.checkForSensitiveData(arg2);
            if (loggerName == null) {
                loggerName = GENERAL;
            }
            CAFLog.logToIPFTrace(indicationLevel, loggerName, msg, argDesc, arg, argDesc2, arg2);
        }
    }

    public static Locale getServerLocale() {
        Locale serverLocale;
        ICCLConfiguration cclConfig = CCLConfigurationFactory.createConfiguration();
        try {
            cclConfig.init();
            String serverLocaleStr = cclConfig.getValue("serverLocale", false);
            if (serverLocaleStr == null || serverLocaleStr.isEmpty()) {
                Locale serverLocale2 = Locale.getDefault();
                return serverLocale2;
            }
            int indexOfDash = serverLocaleStr.indexOf(45);
            serverLocale = indexOfDash == -1 ? new Locale(serverLocaleStr, "") : new Locale(serverLocaleStr.substring(0, indexOfDash), serverLocaleStr.substring(indexOfDash + 1));
        }
        catch (CCLConfigurationException ex) {
            serverLocale = Locale.getDefault();
        }
        return serverLocale;
    }
}

