/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.caf.rule;

import com.cognos.caf.CAFPatternCache;
import com.cognos.caf.CAFRequestObject;
import com.cognos.caf.CAFValidator;
import com.cognos.caf.common.CAFBooleanHolder;
import com.cognos.caf.common.CAFException;
import com.cognos.caf.common.CAFGlobals;
import com.cognos.caf.common.CAFUtil;
import com.cognos.caf.common.CAFValidationData;
import com.cognos.caf.logging.CAFLog;
import com.cognos.caf.rule.CAFPattern;
import com.cognos.caf.rule.CAFRuleException;
import com.cognos.caf.rule.CAFValidationFunction;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;

public class CAFValidationRule {
    static final int m_MAX_URL_SIZE = 32768;
    private String m_name = null;
    private String m_xpath = null;
    private String m_type = null;
    private LinkedList<CAFPattern> m_patterns = new LinkedList();
    private String m_validChars = null;
    private int m_maxLen = Integer.MAX_VALUE;
    private boolean m_sign = false;
    private boolean m_thirdParty = false;
    private Method m_validationFunction = null;
    private boolean m_postOnly = false;
    private String m_contextIdPattern = null;
    private String m_signOverride = null;
    private static Pattern jsonIconField;
    private static Pattern jsonFactionField;
    private static Pattern emptyJSON;

    public static boolean postCheck(String patternName, String value) throws CAFException {
        boolean res = false;
        try {
            StringBuffer htmpUnescapeVal = new StringBuffer();
            boolean decoded = CAFUtil.htmlDecode(value.toCharArray(), htmpUnescapeVal);
            String checkValueString = value;
            if (decoded) {
                checkValueString = htmpUnescapeVal.toString();
            }
            if (CAFValidationRule.isInvalidBackUrl(patternName, checkValueString)) {
                return false;
            }
            if (CAFValidationRule.checkPattern("categoryJS", checkValueString)) {
                res = CAFValidationRule.checkPattern("jsExceptions", checkValueString);
            } else if (CAFValidationRule.checkPattern("categoryAbsURL", value)) {
                if (CAFValidationRule.checkPattern("backSlashedAbsURL", value)) {
                    value = value.replaceFirst("\\\\\\\\", "//");
                }
                res = CAFValidationRule.checkAbsURL(value);
            } else if (CAFValidationRule.checkPattern("categorySlashSlashURL", value)) {
                value = value.replaceFirst("^(\\\\|/)+", "//");
                value = value.replace("\\", "/");
                value = "http:" + value;
                res = CAFValidationRule.checkAbsURL(value);
            } else if (CAFValidationRule.checkPattern("relativeurl", value)) {
                res = true;
            } else {
                CAFLog.error("postCheck did not find a category", "name", patternName);
            }
        }
        catch (CAFRuleException e) {
            CAFLog.error("postCheck failed.", "name", patternName);
        }
        catch (CAFException e) {
            CAFLog.error("postCheck failed lower level check.");
        }
        return res;
    }

    private static boolean isInvalidBackUrl(String patternName, String checkValueString) throws CAFException {
        boolean result = false;
        try {
            if (patternName != null && patternName.equalsIgnoreCase("backURL")) {
                result = CAFValidationRule.checkPattern("type_url_reject", checkValueString);
            }
        }
        catch (CAFException e) {
            CAFLog.error("Unexpected CAFException in CAFValidationRule.isInvalidBackUrl");
            throw e;
        }
        return result;
    }

    private static boolean checkAbsURL(String value) throws CAFException {
        boolean res = CAFValidationRule.checkPattern("absURL", value);
        if (res) {
            res = CAFValidator.checkURLHostDomain(value);
        }
        return res;
    }

    private static void initJSONPatterns() {
        String jsonIconFieldRegex = CAFPatternCache.getNamedPattern("jsoniconfield");
        String jsonfActionFieldRegex = CAFPatternCache.getNamedPattern("jsonfactionfield");
        if (jsonIconField == null) {
            jsonIconField = Pattern.compile(jsonIconFieldRegex);
        }
        if (jsonFactionField == null) {
            jsonFactionField = Pattern.compile(jsonfActionFieldRegex);
        }
        if (emptyJSON == null) {
            emptyJSON = Pattern.compile("while\\(1\\);/\\*\\[\\]");
        }
    }

    private static boolean jsonFieldValidate(String patternName, Matcher m_fieldMatcher) throws CAFException {
        boolean fieldRes = true;
        while (fieldRes && m_fieldMatcher.find()) {
            String fieldValue = m_fieldMatcher.group(1);
            fieldRes = CAFValidationRule.postCheck(patternName, fieldValue);
            CAFLog.warn("HSC JSON - found field:" + fieldValue);
        }
        return fieldRes;
    }

    public static boolean jsonValidate(String patternName, String value) throws CAFException {
        boolean res = false;
        boolean iconRes = true;
        boolean fActionRes = true;
        CAFValidationRule.initJSONPatterns();
        Matcher m_empty = emptyJSON.matcher(value);
        if (m_empty.find()) {
            CAFLog.warn("JSON icon field is empty.");
            return true;
        }
        Matcher m_IconField = jsonIconField.matcher(value);
        Matcher m_FactionField = jsonFactionField.matcher(value);
        iconRes = CAFValidationRule.jsonFieldValidate(patternName, m_IconField);
        if (iconRes) {
            fActionRes = CAFValidationRule.jsonFieldValidate(patternName, m_FactionField);
        }
        if (iconRes && fActionRes) {
            res = true;
        }
        return res;
    }

    private static String extractJsonField(Matcher m_matcherObject) throws CAFException {
        String fieldValue = null;
        if (m_matcherObject.find()) {
            for (int i = 1; i < m_matcherObject.groupCount(); ++i) {
                if (m_matcherObject.group(i) == null) continue;
                fieldValue = m_matcherObject.group(i);
            }
        } else {
            CAFLog.warn("extractJsonField matcher 'find' did not succeed.");
        }
        return fieldValue;
    }

    private static boolean checkPattern(String patternName, String value) throws CAFException {
        boolean res = false;
        String strPattern = CAFPatternCache.getNamedPattern(patternName);
        if (strPattern == null) {
            CAFLog.error("reference to unknown pattern", "name", patternName);
            throw new CAFRuleException(2);
        }
        res = CAFPatternCache.match(value, strPattern);
        return res;
    }

    private CAFValidationRule() {
    }

    public static CAFValidationRule parse(XMLStreamReader staxStreamReader) throws CAFException {
        CAFValidationRule validationRule = new CAFValidationRule();
        validationRule._parse(staxStreamReader);
        return validationRule;
    }

    private void _parse(XMLStreamReader staxStreamReader) throws CAFException {
        try {
            String localName = staxStreamReader.getLocalName();
            this.parseAttributes(staxStreamReader);
            while (staxStreamReader.hasNext()) {
                int event = staxStreamReader.next();
                if (event == 2) {
                    if (!localName.equalsIgnoreCase(staxStreamReader.getLocalName())) continue;
                    break;
                }
                if (event != 1) continue;
                CAFPattern cafPattern = CAFPattern.parse(staxStreamReader);
                if (cafPattern == null) break;
                if (cafPattern.m_override) {
                    this.m_patterns.addFirst(cafPattern);
                    continue;
                }
                this.m_patterns.add(cafPattern);
            }
            this.checkRuleType();
        }
        catch (Exception e) {
            CAFLog.error("failed to parse validation rule", "name", this.m_name);
            throw new CAFRuleException(e, 7);
        }
    }

    private void setValidationFunction(String function) throws CAFException {
        try {
            Class[] args = new Class[]{CAFValidationData.class, CAFValidationRule.class, CAFRequestObject.class};
            this.m_validationFunction = CAFValidationFunction.class.getMethod(function, args);
            if (this.m_validationFunction == null) {
                throw new CAFRuleException(46);
            }
        }
        catch (Exception e) {
            CAFLog.error("Failed to load validation function", "function", function);
            throw new CAFRuleException(e, 46);
        }
    }

    private void addSubRule(String attName, String attValue) throws CAFException {
        if (attName.equals("name")) {
            this.m_name = attValue;
        } else if (attName.equals("xpath")) {
            this.m_xpath = attValue;
        } else if (attName.equals("type")) {
            this.m_type = attValue;
        } else if (attName.equals("postcheck")) {
            this.m_type = attValue;
        } else if (attName.equals("json")) {
            this.m_type = attValue;
        } else if (attName.equals("maxlen")) {
            this.m_maxLen = new Integer(attValue);
        } else if (attName.equals("validchars")) {
            this.m_validChars = attValue;
        } else if (attName.equals("sign")) {
            this.m_sign = attValue.equals("true");
        } else if (attName.equals("thirdparty")) {
            this.m_thirdParty = attValue.equals("true");
        } else if (attName.equals("postonly")) {
            this.m_postOnly = attValue.equals("true");
        } else if (attName.equals("contextidpattern")) {
            this.m_contextIdPattern = attValue;
        } else if (attName.equals("signoverride")) {
            this.m_signOverride = attValue;
            if (!CAFGlobals.checkComponentName(this.m_signOverride)) {
                throw new CAFRuleException(73);
            }
        } else if (attName.equals("validationfunction")) {
            this.setValidationFunction(attValue);
        }
    }

    private void parseAttributes(XMLStreamReader staxStreamReader) throws CAFException {
        int attributeCount = staxStreamReader.getAttributeCount();
        for (int k = 0; k < attributeCount; ++k) {
            String attributeName = staxStreamReader.getAttributeLocalName(k);
            String attributeValue = staxStreamReader.getAttributeValue(k);
            this.addSubRule(attributeName, attributeValue);
        }
    }

    private void checkRuleType() throws CAFException {
        if (this.m_type != null) {
            if (this.m_type.equals("searchpath")) {
                CAFPattern pattern = new CAFPattern("searchpath_reject", true);
                this.m_patterns.add(pattern);
                if (this.m_maxLen == Integer.MAX_VALUE) {
                    this.m_maxLen = 32768;
                }
            } else if (this.m_type.equals("url") || this.m_type.equals("postcheck")) {
                if (this.m_maxLen == Integer.MAX_VALUE) {
                    this.m_maxLen = 32768;
                }
                CAFPattern pattern = new CAFPattern("type_url", false);
                pattern.m_override = true;
                this.m_patterns.add(pattern);
                pattern = new CAFPattern("type_url_reject", true);
                pattern.m_override = false;
                this.m_patterns.add(pattern);
            } else if (!this.m_type.equals("json")) {
                if (this.m_type.equals("bool")) {
                    if (this.m_maxLen == Integer.MAX_VALUE) {
                        this.m_maxLen = 6;
                    }
                    CAFPattern pattern = new CAFPattern("type_bool", false);
                    this.m_patterns.add(pattern);
                } else if (this.m_type.equals("uint")) {
                    if (this.m_maxLen == Integer.MAX_VALUE) {
                        this.m_maxLen = 32;
                    }
                    CAFPattern pattern = new CAFPattern("type_uint", false);
                    this.m_patterns.add(pattern);
                } else if (this.m_type.equals("int")) {
                    if (this.m_maxLen == Integer.MAX_VALUE) {
                        this.m_maxLen = 32;
                    }
                    CAFPattern pattern = new CAFPattern("type_int", false);
                    this.m_patterns.add(pattern);
                } else if (this.m_type.equals("inlinespec")) {
                    this.m_maxLen = 0x1000000;
                    this.m_validChars = String.valueOf('~');
                }
            }
        }
    }

    public String getName() {
        String res = this.m_name;
        if (res == null) {
            res = this.m_xpath;
        }
        return res;
    }

    public String getXpath() {
        return this.m_xpath;
    }

    public String getType() {
        return this.m_type;
    }

    public String getValidChars() {
        return this.m_validChars;
    }

    public boolean getSign() {
        return this.m_sign;
    }

    public boolean getThirdParty() {
        return this.m_thirdParty;
    }

    public String applySubstitutePatterns(String str) throws CAFException {
        try {
            String res = str;
            CAFPattern pattern2 = null;
            for (CAFPattern pattern2 : this.m_patterns) {
                if (!pattern2.m_substitute) continue;
                res = CAFPatternCache.substitute(res, pattern2.m_value, pattern2.m_substitutestr == null ? "" : pattern2.m_substitutestr);
            }
            return res;
        }
        catch (Exception e) {
            throw new CAFRuleException(e, 24);
        }
    }

    public boolean isValueValid(CAFValidationData valData, CAFBooleanHolder overrideResult, CAFRequestObject requestObject) throws CAFException {
        String TYPE_URL = "url";
        String TYPE_POSTCHECK = "postcheck";
        String TYPE_JSON = "json";
        boolean valid = true;
        boolean done = false;
        overrideResult.value = false;
        String value = valData.value;
        String patternName = valData.name;
        if (!done) {
            CAFPattern pattern2 = null;
            Iterator i = this.m_patterns.iterator();
            String strPattern = null;
            boolean result = true;
            while (i.hasNext()) {
                pattern2 = (CAFPattern)i.next();
                if (pattern2.m_substitute) continue;
                if (!pattern2.m_reject) {
                    valid = value.length() == 0;
                }
                if (pattern2.m_reference) {
                    result = CAFValidationRule.checkPattern(pattern2.m_name, value);
                } else {
                    strPattern = pattern2.m_value;
                    result = CAFPatternCache.match(value, strPattern);
                }
                if (result && !pattern2.m_reject) {
                    valid = true;
                    done = pattern2.m_override;
                    overrideResult.value = pattern2.m_override;
                    break;
                }
                if (!result || !pattern2.m_reject) continue;
                if (pattern2.m_reference) {
                    CAFLog.error("value matches rejection pattern", "pattern name", pattern2.m_name);
                } else {
                    CAFLog.error("value matches rejection pattern", "pattern", strPattern);
                }
                valid = false;
                done = true;
                overrideResult.value = pattern2.m_override;
                break;
            }
            if (!done && value.length() == 0) {
                valid = true;
                done = true;
            }
            if (result) {
                if (this.m_type != null) {
                    if (this.m_type.equals("url") || this.m_type.equals("postcheck")) {
                        valid = CAFValidationRule.postCheck(patternName, value);
                        done = true;
                    }
                    if (this.m_type.equals("json")) {
                        valid = CAFValidationRule.jsonValidate(patternName, value);
                        done = true;
                    }
                }
                if (this.m_validationFunction != null) {
                    try {
                        Object[] args = new Object[]{valData, this, requestObject};
                        Boolean res = Boolean.FALSE;
                        try {
                            res = (Boolean)this.m_validationFunction.invoke(null, args);
                        }
                        catch (InvocationTargetException e) {
                            Throwable t = null;
                            try {
                                t = e.getTargetException();
                            }
                            catch (Throwable t2) {
                                throw new CAFRuleException(55);
                            }
                            if (t instanceof Exception) {
                                throw (Exception)t;
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PrintStream ps = new PrintStream(baos);
                            t.printStackTrace(ps);
                            CAFLog.error("throwable type exception", "message", t.getMessage(), "stack", baos.toString("UTF-8"));
                            throw new CAFRuleException(56);
                        }
                        valid = res;
                        done = true;
                    }
                    catch (Exception e) {
                        throw new CAFRuleException(e, 47);
                    }
                }
            }
            if (!done && !valid) {
                for (CAFPattern pattern2 : this.m_patterns) {
                    if (pattern2.m_reject) continue;
                    strPattern = pattern2.m_reference ? CAFPatternCache.getNamedPattern(pattern2.m_name) : pattern2.m_value;
                    CAFLog.error("value does not match pattern", "pattern", strPattern);
                }
            }
        }
        if (!valid) {
            CAFLog.error("invalid value", "decoded value", value);
        }
        return valid;
    }

    public boolean isValueValidApi(CAFValidationData valData, CAFBooleanHolder overrideResult) throws CAFException {
        String TYPE_URL = "url";
        boolean valid = true;
        boolean done = false;
        overrideResult.value = false;
        String value = valData.value;
        if (!done) {
            CAFPattern pattern2 = null;
            Iterator i = this.m_patterns.iterator();
            String strPattern = null;
            boolean result = true;
            while (i.hasNext()) {
                pattern2 = (CAFPattern)i.next();
                if (pattern2.m_substitute) continue;
                if (!pattern2.m_reject) {
                    valid = value.length() == 0;
                }
                if (pattern2.m_reference) {
                    result = CAFValidationRule.checkPattern(pattern2.m_name, value);
                } else {
                    strPattern = pattern2.m_value;
                    result = CAFPatternCache.match(value, strPattern);
                }
                if (result && !pattern2.m_reject) {
                    valid = true;
                    done = pattern2.m_override;
                    overrideResult.value = pattern2.m_override;
                    break;
                }
                if (!result || !pattern2.m_reject) continue;
                if (pattern2.m_reference) {
                    CAFLog.error("value matches rejection pattern", "pattern name", pattern2.m_name);
                } else {
                    CAFLog.error("value matches rejection pattern", "pattern", strPattern);
                }
                valid = false;
                done = true;
                overrideResult.value = pattern2.m_override;
                break;
            }
            if (!done && value.length() == 0) {
                valid = true;
                done = true;
            }
            if (!done && this.m_type != null && this.m_type.equals("url")) {
                valid = CAFValidator.checkURLHostDomain(value);
                done = true;
            }
            if (!done && this.m_validationFunction != null) {
                try {
                    Object[] args = new Object[]{valData, this};
                    Boolean res = Boolean.FALSE;
                    try {
                        res = (Boolean)this.m_validationFunction.invoke(null, args);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = null;
                        try {
                            t = e.getTargetException();
                        }
                        catch (Throwable t2) {
                            throw new CAFRuleException(55);
                        }
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(baos);
                        t.printStackTrace(ps);
                        CAFLog.error("throwable type exception", "message", t.getMessage(), "stack", baos.toString("UTF-8"));
                        throw new CAFRuleException(56);
                    }
                    valid = res;
                    done = true;
                }
                catch (Exception e) {
                    throw new CAFRuleException(e, 47);
                }
            }
            if (!done && !valid) {
                for (CAFPattern pattern2 : this.m_patterns) {
                    if (pattern2.m_reject) continue;
                    strPattern = pattern2.m_reference ? CAFPatternCache.getNamedPattern(pattern2.m_name) : pattern2.m_value;
                    CAFLog.error("value does not match pattern", "pattern", strPattern);
                }
            }
        }
        if (!valid) {
            CAFLog.error("invalid value", "decoded value", value);
        }
        return valid;
    }

    public boolean isValueValid(String value, CAFBooleanHolder overrideResult, CAFRequestObject requestObject) throws CAFException {
        CAFValidationData valData = new CAFValidationData();
        valData.name = "";
        valData.value = value;
        return this.isValueValid(valData, overrideResult, requestObject);
    }

    public boolean isValueValidApi(String value, CAFBooleanHolder overrideResult) throws CAFException {
        CAFValidationData valData = new CAFValidationData();
        valData.name = "";
        valData.value = value;
        return this.isValueValidApi(valData, overrideResult);
    }

    public int getMaxLength() {
        return this.m_maxLen;
    }

    public boolean getPostOnly() {
        return this.m_postOnly;
    }

    public LinkedList<CAFPattern> getPatterns() {
        return this.m_patterns;
    }

    public String getVvalidChars() {
        return this.m_validChars;
    }

    public int getMaxLen() {
        return this.m_maxLen;
    }

    public boolean isSign() {
        return this.m_sign;
    }

    public boolean isThirdParty() {
        return this.m_thirdParty;
    }

    public Method getValidationFunction() {
        return this.m_validationFunction;
    }

    public boolean isPostOnly() {
        return this.m_postOnly;
    }

    public String getContextIdPattern() {
        return this.m_contextIdPattern;
    }

    public String getSignOverride() {
        return this.m_signOverride;
    }

    public static Pattern getJsonIconField() {
        return jsonIconField;
    }

    public static Pattern getJsonFactionField() {
        return jsonFactionField;
    }

    public static Pattern getEmptyJSON() {
        return emptyJSON;
    }
}

