/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.http.BIHttpClientPool;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.CAServerList;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.LoadBalancingRequestHandler;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.Server;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.ServerList;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.AsyncContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancingFilter.class);
    public static final String REQUEST_ID_ATTRIBUTE = "reqId";
    private static String DEFAULT_EXCLUSION_PATTERN = ".*/health$|.*v1/(ping|disp)(/.*)?";
    private Pattern excludePattern = Pattern.compile(DEFAULT_EXCLUSION_PATTERN);
    private static final AtomicLong reqId = new AtomicLong(0L);
    private BIHttpClientPool clientPool = new BIHttpClientPool();
    private ServerList serverList;

    public LoadBalancingFilter() {
        this(new CAServerList());
    }

    public LoadBalancingFilter(CAServerList caServerList) {
        this.serverList = caServerList;
    }

    public void destroy() {
        this.serverList.shutdown();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute(REQUEST_ID_ATTRIBUTE, (Object)reqId.getAndIncrement());
        long start = System.currentTimeMillis();
        if (this.dontLoadBalance((HttpServletRequest)request)) {
            this.setAffinityHeader((HttpServletRequest)request, (HttpServletResponse)response);
            chain.doFilter(request, response);
        } else {
            LOGGER.trace("Start : {}, {}", request.getAttribute(REQUEST_ID_ATTRIBUTE), (Object)start);
            this.loadBalanceRequest(request, response);
        }
    }

    private void setAffinityHeader(HttpServletRequest request, HttpServletResponse response) {
        String aff = Long.toString(Server.getLocalID());
        response.setHeader("X-CA-Affinity", aff);
        request.setAttribute("serverID", (Object)aff);
    }

    boolean dontLoadBalance(HttpServletRequest request) {
        if ("/v1/serverlist".equals(request.getPathInfo())) {
            return false;
        }
        if (request.getHeader("X-CA-LB") != null) {
            return true;
        }
        String pi = request.getPathInfo();
        if (StringUtils.isNotEmpty((CharSequence)pi) && this.excludePattern.matcher(pi).matches()) {
            return true;
        }
        return request.getHeader("X-CA-Affinity") == null && request.getHeader("X-CA-Routing") == null;
    }

    protected void loadBalanceRequest(ServletRequest request, ServletResponse response) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        AsyncContext asyncCtx = this.getAsyncContext(servletRequest, servletResponse);
        LoadBalancingRequestHandler handler = new LoadBalancingRequestHandler(this.serverList, this.clientPool);
        handler.setAsyncContext(asyncCtx);
        asyncCtx.start((Runnable)handler);
    }

    private AsyncContext getAsyncContext(HttpServletRequest req, HttpServletResponse resp) {
        if (req.isAsyncStarted()) {
            return req.getAsyncContext();
        }
        AsyncContext ctx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ctx.setTimeout(0L);
        return ctx;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        this.clientPool.initialize(false);
        String exclude = ConfigurationPropertyFactory.getInstance().getStringProperty("bi-loadbalancer.exclusionPattern", DEFAULT_EXCLUSION_PATTERN).get();
        if (StringUtils.isNotEmpty((CharSequence)exclude)) {
            this.setExcludePattern(exclude);
        }
        LOGGER.info("LoadBalancingFilter initialized");
    }

    private void setExcludePattern(String exclude) {
        try {
            this.excludePattern = Pattern.compile(exclude);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Invalid exclusion pattern: {}", (Object)exclude);
        }
    }
}

