/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.loadbalancer;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.RoutingException;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.Server;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.ServerCollection;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.ServerDoctor;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.ServerList;
import com.netflix.config.DynamicStringProperty;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAServerList
implements ServerList {
    private static final String SERVERGROUP_EQUALS = "servergroup=";
    private static final Logger LOGGER = LoggerFactory.getLogger(CAServerList.class);
    ServerCollection allServers = new ServerCollection();
    private Map<Long, Server> serverMap = Collections.synchronizedMap(new HashMap());
    Map<String, ServerCollection> serverGroupLists = Collections.synchronizedMap(new HashMap());
    private static ScheduledExecutorService execSvc;
    protected final DynamicStringProperty listOfServers;
    private ServerDoctor serverDoctor = new ServerDoctor(this);

    public CAServerList() {
        this(ConfigurationPropertyFactory.getInstance().getStringProperty("bi-loadbalancer.listOfServers"), CAServerList.getExecSvc());
        if (execSvc != null) {
            execSvc.scheduleWithFixedDelay(this.serverDoctor, 10L, 10L, TimeUnit.SECONDS);
        }
    }

    private static ScheduledExecutorService getExecSvc() {
        try {
            return (ManagedScheduledExecutorService)new InitialContext().lookup("concurrent/biScheduledExecSvc");
        }
        catch (NamingException e) {
            LOGGER.error("can't find concurrent/biScheduledExecSvc", (Throwable)e);
            return Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "ServerDoctor");
                }
            });
        }
    }

    protected CAServerList(DynamicStringProperty listOfServers, ScheduledExecutorService scheduledExecutorService) {
        this.listOfServers = listOfServers;
        execSvc = scheduledExecutorService;
        this.initServerUrls();
    }

    public CAServerList(Server ... servers) {
        this.listOfServers = new DynamicStringProperty("bi-loadbalancer.listOfServers", "");
        for (Server server : servers) {
            this.addToServerList(server);
        }
    }

    public CAServerList(DynamicStringProperty list) {
        this(list, null);
    }

    private void initServerUrls() {
        this.initialize();
        this.listOfServers.addCallback(() -> this.initialize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Object[] serverUrls = this.listOfServers.get().split(",");
        ServerCollection serverCollection = this.allServers;
        synchronized (serverCollection) {
            this.allServers.clear();
            this.serverMap.clear();
            this.serverDoctor.clear();
            LOGGER.debug("new server list: {}", (Object)Arrays.toString(serverUrls));
            for (Object url : serverUrls) {
                if (!StringUtils.isNotEmpty((String)url)) continue;
                this.addServer((String)url);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuilder map = new StringBuilder();
                this.serverMap.forEach((key, value) -> map.append(key).append(":").append(value).append(","));
                LOGGER.debug("map: {}", (Object)map.toString());
            }
        }
    }

    protected void addServer(String url) {
        try {
            Server server = new Server(url);
            this.addToServerList(server);
        }
        catch (MalformedURLException e) {
            LOGGER.info("Server at URL {} ignored, due to bad format", (Object)url);
        }
    }

    @Override
    public Server getServer(HttpServletRequest request) throws RoutingException {
        if (this.allServers.isEmpty()) {
            LOGGER.error("serverList is empty");
            return null;
        }
        LOGGER.trace("serverMap: {}", this.serverMap);
        Server server = this.getSpecificServer(request);
        if (server != null) {
            if (server.isAlive()) {
                return server;
            }
            this.markSick(server);
        }
        ServerCollection validServerList = this.getServerListForRequest(request);
        while ((server = validServerList.getNextServer()) != null && !server.isAlive()) {
            this.markSick(server);
        }
        LOGGER.trace("returning {}", (Object)(server != null ? server.toString() : "null"));
        return server;
    }

    private ServerCollection getServerListForRequest(HttpServletRequest request) throws RoutingException {
        String requestServerGroup = CAServerList.getServerGroup(request);
        if (!StringUtils.isEmpty((String)requestServerGroup)) {
            ServerCollection serverGroupList = this.serverGroupLists.get(requestServerGroup);
            if (serverGroupList != null) {
                return serverGroupList;
            }
            LOGGER.warn("Supplied server group {} does not exist.  It will be ignored.", (Object)requestServerGroup);
            throw new RoutingException("Server group does not exist: " + requestServerGroup);
        }
        return this.allServers;
    }

    static String getServerGroup(HttpServletRequest request) throws RoutingException {
        String header = request.getHeader("X-CA-Routing");
        if (header != null) {
            if (header.toLowerCase().startsWith(SERVERGROUP_EQUALS)) {
                return header.substring(SERVERGROUP_EQUALS.length());
            }
            return header;
        }
        return null;
    }

    private void markSick(Server server) {
        this.allServers.remove(server);
        String group = server.getGroup();
        if (StringUtils.isNotEmpty((String)group)) {
            this.serverGroupLists.get(group).remove(server);
        }
        this.serverDoctor.add(server);
        LOGGER.debug("Server at {} failed, moved to sick pool", (Object)server.toString());
    }

    private Server getSpecificServer(HttpServletRequest request) throws RoutingException {
        try {
            String header = request.getHeader("X-CA-Affinity");
            if (header != null) {
                Server theServer = this.serverMap.get(Long.parseLong(header));
                if (theServer != null) {
                    return theServer;
                }
                LOGGER.error("specific server {} not in map: {}", (Object)Long.parseLong(header), this.serverMap);
                throw new RoutingException("unknown server: " + Long.parseLong(header));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Bad X-CA-Affinity header value: {}", (Object)request.getHeader("X-CA-Affinity"));
            throw new RoutingException("Bad X-CA-Affinity header value: " + request.getHeader("X-CA-Affinity"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToServerList(Server server) {
        Server theServer = server;
        Map<Long, Server> map = this.serverMap;
        synchronized (map) {
            if (this.serverMap.containsKey(server.getID())) {
                theServer = this.serverMap.get(server.getID());
            } else {
                this.serverMap.put(theServer.getID(), theServer);
            }
        }
        this.allServers.add(theServer);
        if (!"".equals(server.getGroup())) {
            this.addServerToGroup(server.getGroup(), server);
        }
        LOGGER.debug("Server at {} added to pool {} time(s).", (Object)server.toString(), (Object)server.getCapacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerToGroup(String group, Server server) {
        ServerCollection serverGroupList;
        Map<String, ServerCollection> map = this.serverGroupLists;
        synchronized (map) {
            serverGroupList = this.serverGroupLists.get(group);
            if (serverGroupList == null) {
                serverGroupList = new ServerCollection();
                this.serverGroupLists.put(group, serverGroupList);
            }
        }
        serverGroupList.add(server);
    }

    int getListSize() {
        return this.allServers.size();
    }

    @Override
    public List<Server> getList() {
        return new ArrayList<Server>(this.serverMap.values());
    }

    ServerDoctor getServerDoctor() {
        return this.serverDoctor;
    }

    @Override
    public void shutdown() {
        if (execSvc != null && !(execSvc instanceof ManagedScheduledExecutorService)) {
            execSvc.shutdownNow();
        }
    }
}

