/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.loadbalancer;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.http.BIHttpClientPool;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.LoadBalancerMessageKeys;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.RoutingException;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.Server;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.ServerList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancingRequestHandler
implements Runnable {
    private static final String BI_V1 = "/bi/v1";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancingRequestHandler.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected AsyncContext context;
    private ServerList serverList;
    private BIHttpClientPool clientPool;
    private Server server;

    public LoadBalancingRequestHandler(ServerList serverList, BIHttpClientPool clientPool) {
        this.serverList = serverList;
        this.clientPool = clientPool;
    }

    protected LoadBalancingRequestHandler(ServerList serverList, BIHttpClientPool clientPool, HttpServletRequest request) {
        this(serverList, clientPool);
        this.request = request;
    }

    public void setAsyncContext(AsyncContext context) {
        this.request = (HttpServletRequest)context.getRequest();
        this.response = (HttpServletResponse)context.getResponse();
        this.context = context;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start : {}, {}", (Object)this.requestId(), (Object)start);
        }
        int statusCode = 410;
        statusCode = "/v1/serverlist".equals(this.request.getPathInfo()) ? this.report() : this.serviceRequest();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} {} {} {}", new Object[]{this.requestId(), LoadBalancingRequestHandler.getURL(this.server, this.request), statusCode, System.currentTimeMillis() - start});
        }
        this.context.complete();
    }

    protected int serviceRequest() {
        int status = 410;
        try {
            while (status == 410) {
                this.server = this.serverList.getServer(this.request);
                if (this.server == null) {
                    return this.setStatusUnavailable();
                }
                status = this.forwardRequest(this.server);
            }
        }
        catch (RoutingException e) {
            status = 400;
        }
        return status;
    }

    protected int setStatusUnavailable() {
        int statusCode = 503;
        String msgNoServer = LoadBalancerMessageKeys.NO_SERVER.buildMessage().getLocalizedMessage();
        try {
            String msgJson = String.format("{\"msg\":\"%s\"}", msgNoServer);
            this.response.setStatus(503);
            this.response.getWriter().write(msgJson);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOGGER.error(msgNoServer);
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int forwardRequest(Server server) {
        int statusCode = 200;
        HttpResponse proxyResponse = null;
        try {
            HttpHost host = new HttpHost(server.getServer(), server.getPort(), server.getScheme());
            proxyResponse = this.sendProxyRequest(host);
            statusCode = proxyResponse.getStatusLine().getStatusCode();
            this.copyResponseHeaders(proxyResponse, this.request, this.response);
            if (statusCode >= 500) {
                server.setAlive(false);
                this.copyResponseEntity(proxyResponse, this.response);
                statusCode = 503;
                LOGGER.error("{} failed with {}", (Object)server.toString(), (Object)statusCode);
                int n = statusCode;
                return n;
            }
            if (statusCode == 304) {
                this.response.setStatus(statusCode);
                this.response.setIntHeader("Content-Length", 0);
            } else {
                this.response.setStatus(statusCode);
                this.copyResponseEntity(proxyResponse, this.response);
            }
        }
        catch (IOException e) {
            server.setAlive(false);
            statusCode = 410;
            this.response.setStatus(statusCode);
            LOGGER.error("{} failed with {}", (Object)server.toString(), (Object)e.getMessage());
        }
        finally {
            if (proxyResponse != null) {
                try {
                    EntityUtils.consume((HttpEntity)proxyResponse.getEntity());
                }
                catch (IOException iOException) {}
            }
            if (statusCode != 410) {
                server.success();
            } else {
                server.failure();
            }
        }
        return statusCode;
    }

    protected HttpResponse sendProxyRequest(HttpHost host) throws IOException {
        HttpRequest proxyRequest = LoadBalancingRequestHandler.createProxyRequestWithEntity(this.request);
        this.copyRequestHeaders(this.request, proxyRequest);
        this.setAdditionalHeaders(proxyRequest);
        return this.sendRequest(host, proxyRequest);
    }

    private static String getURL(Server server, HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        if (server != null) {
            sb.append(server.toString());
        }
        return sb.append("/bi").append(request.getPathInfo()).toString();
    }

    public int report() {
        if (Boolean.getBoolean("show-server-list")) {
            this.response.setContentType("application/json");
            JsonObject report = new JsonObject();
            try {
                report.set("thisServer", (Object)new Server(HttpUtils.getServerName()).getJsonStatistics());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            JsonArray list = new JsonArray();
            this.serverList.getList().forEach(server -> list.add((Object)server.getJsonStatistics()));
            report.set("serverList", (Object)list);
            try {
                this.response.getWriter().write(report.toString());
            }
            catch (IOException e) {
                LOGGER.debug("Failed to return server list report: {}", (Object)e.getMessage());
            }
            return 200;
        }
        return 403;
    }

    protected HttpResponse sendRequest(HttpHost host, HttpRequest request) throws IOException {
        long remoteStart = System.currentTimeMillis();
        CloseableHttpResponse proxyResponse = this.clientPool.getClient().execute(host, request);
        if (LOGGER.isDebugEnabled()) {
            String requestLine = request.getRequestLine().getUri();
            LOGGER.debug("{} remote call to {} {} {}", new Object[]{this.requestId(), host.toURI() + (requestLine.contains("?") ? requestLine.substring(0, requestLine.indexOf("?")) : requestLine), proxyResponse.getStatusLine().getStatusCode(), System.currentTimeMillis() - remoteStart});
        }
        return proxyResponse;
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected static String getForwardURI(HttpServletRequest req) {
        String qs;
        StringBuilder sb = new StringBuilder();
        String pathInfo = req.getPathInfo();
        sb.append("/bi");
        if (StringUtils.isNotEmpty((String)pathInfo)) {
            sb.append(HttpUtils.encodePathInfo((String)pathInfo));
        }
        if (StringUtils.isNotEmpty((String)(qs = req.getQueryString()))) {
            sb.append("?").append(qs);
        }
        return sb.toString();
    }

    private static HttpRequest createProxyRequestWithEntity(HttpServletRequest request) throws IOException {
        String method = request.getMethod();
        BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, LoadBalancingRequestHandler.getForwardURI(request));
        if (!"GET".equalsIgnoreCase(method)) {
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)request.getInputStream(), (long)request.getContentLength()));
        }
        return eProxyRequest;
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            this.copyRequestHeader(servletRequest, proxyRequest, headerName);
        }
    }

    protected void copyRequestHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest, String headerName) {
        if (headerName.equalsIgnoreCase("Content-Length")) {
            return;
        }
        if (HttpUtils.hopByHopHeaders.containsHeader(headerName)) {
            return;
        }
        Enumeration headers = servletRequest.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String headerValue = (String)headers.nextElement();
            proxyRequest.addHeader(headerName, headerValue);
        }
    }

    private void setAdditionalHeaders(HttpRequest proxyRequest) {
        proxyRequest.addHeader("X-CA-LB", "true");
        proxyRequest.setHeader("X-CA-RequestID", Long.toString(this.requestId()));
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            this.copyResponseHeader(servletRequest, servletResponse, header);
        }
    }

    private void copyResponseHeader(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Header header) {
        String headerName = header.getName();
        if (HttpUtils.hopByHopHeaders.containsHeader(headerName)) {
            return;
        }
        String headerValue = header.getValue();
        if ("Location".equalsIgnoreCase(headerName)) {
            servletResponse.addHeader(headerName, this.fixLocation(headerValue));
        } else {
            servletResponse.addHeader(headerName, headerValue);
        }
    }

    String fixLocation(String locationValue) {
        if (locationValue.startsWith("http")) {
            String biPath = this.request.getHeader("X-BI-Path");
            String location = locationValue.replaceAll("https?://([^/]+)/", "/");
            if (StringUtils.isNotEmpty((String)biPath)) {
                if (biPath.contains(BI_V1)) {
                    biPath = biPath.substring(0, biPath.lastIndexOf(BI_V1));
                }
            } else {
                biPath = this.request.getContextPath();
            }
            return biPath + location;
        }
        return locationValue;
    }

    private long requestId() {
        return (Long)this.request.getAttribute("reqId");
    }
}

