/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.loadbalancer;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private String scheme = "http";
    private String host = "localhost";
    private int port = 9300;
    private boolean isAlive = true;
    private int capacity = 1;
    private String group = "";
    private long successCount = 0L;
    private long failureCount = 0L;
    static long localServerID = 0L;

    public Server(String urlString) throws MalformedURLException {
        String[] server = urlString.split(";");
        try {
            URL url = new URL(server[0]);
            this.scheme = url.getProtocol();
            this.host = url.getHost();
            this.setPort(url.getPort());
            if (server.length > 1) {
                this.setGroup(server[1]);
            }
            if (server.length > 2) {
                this.setCapacity(server[2]);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid dispatcher url ({})", (Object)server[0]);
            throw e;
        }
    }

    private void setGroup(String group) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(group);
            this.group = new String(decodedBytes);
            return;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("setGroup - unable to decode group name '{}', use as is.", (Object)group);
            this.group = group;
            return;
        }
    }

    private void setPort(int port) {
        if (port > 0) {
            this.port = port;
        }
    }

    void setCapacity(String sCap) {
        try {
            int cap = Math.round(Float.parseFloat(sCap));
            if (cap > 10) {
                cap = 10;
            }
            this.capacity = cap <= 0 ? 1 : cap;
        }
        catch (NumberFormatException e) {
            LOGGER.error("Invalid dispatcher weight ({}), using 1", (Object)sCap);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServer() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getGroup() {
        return this.group;
    }

    public void setAlive(boolean alive) {
        this.isAlive = alive;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public void success() {
        ++this.successCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public void failure() {
        ++this.failureCount;
    }

    public String getStatistics() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" - ").append(this.isAlive ? "Active" : "Inactive");
        sb.append(" - Success: ").append(new DecimalFormat().format(this.successCount));
        sb.append(" - Failure: ").append(new DecimalFormat().format(this.failureCount));
        return sb.toString();
    }

    public JsonObject getJsonStatistics() {
        JsonObject stats = new JsonObject();
        stats.put("name", (Object)this.toString());
        stats.put("id", (Object)this.getID());
        stats.put("group", (Object)this.getGroup());
        stats.put("alive", (Object)(this.isAlive ? "Active" : "Inactive"));
        stats.put("success", (Object)this.successCount);
        stats.put("failure", (Object)this.failureCount);
        return stats;
    }

    public String toString() {
        return this.getUrl();
    }

    private String getUrl() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.getScheme()).append("://").append(this.getServer().toLowerCase()).append(":").append(this.getPort()).toString();
    }

    public int compareTo(Server server) {
        return this.toString().compareTo(server.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (this.isAlive != other.isAlive) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isAlive ? 1231 : 1237);
        result = 31 * result + this.port;
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    public long getID() {
        CRC32 checksum = new CRC32();
        byte[] bytes = this.toString().getBytes();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidandAlive() {
        String url = this.getUrl();
        int code = 0;
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection(url);
            connection.setConnectTimeout(500);
            connection.setReadTimeout(200);
            code = connection.getResponseCode();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
            LOGGER.debug("Connection to {} failed with status {}", (Object)url, (Object)code);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Connection to {} failed with {}", (Object)url, (Object)e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error("Connection to {} failed with {}", (Object)url, (Object)e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        URL theUrl = new URL(url + "/bi/health");
        return (HttpURLConnection)theUrl.openConnection();
    }

    public static long getLocalID() {
        if (localServerID == 0L) {
            try {
                localServerID = new Server(HttpUtils.getServerName()).getID();
            }
            catch (MalformedURLException e) {
                LOGGER.error("Bad URL: {}", (Object)HttpUtils.getServerName(), (Object)e);
            }
        }
        return localServerID;
    }
}

