/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.loadbalancer;

import com.ibm.bi.platform.commons.web.filters.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerCollection {
    private List<Server> servers = Collections.synchronizedList(new ArrayList());
    protected AtomicInteger index = new AtomicInteger(0);

    public void clear() {
        this.servers.clear();
        this.index.set(0);
    }

    protected Server getNextServer() {
        int size = this.servers.size();
        return size == 0 ? null : this.servers.get(this.nextIndex(size));
    }

    private int nextIndex(int size) {
        return this.index.getAndIncrement() % size;
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public int size() {
        return this.servers.size();
    }

    public void add(Server server) {
        for (int i = 1; i <= server.getCapacity(); ++i) {
            this.servers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Server sickServer) {
        if (sickServer.getCapacity() == 1) {
            this.servers.remove(sickServer);
        } else {
            List<Server> list = this.servers;
            synchronized (list) {
                Iterator<Server> it = this.servers.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals(sickServer)) continue;
                    it.remove();
                }
            }
        }
    }

    public boolean contains(Server server) {
        return this.servers.contains(server);
    }
}

