/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.loadbalancer;

import com.ibm.bi.platform.commons.web.filters.loadbalancer.CAServerList;
import com.ibm.bi.platform.commons.web.filters.loadbalancer.Server;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerDoctor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerDoctor.class);
    private CAServerList caServerList;
    private Set<Server> sickServerSet = ConcurrentHashMap.newKeySet();

    public ServerDoctor(CAServerList caServerList) {
        this.caServerList = caServerList;
    }

    @Override
    public void run() {
        try {
            if (!this.sickServerSet.isEmpty()) {
                this.sickServerSet.forEach(server -> this.checkServer((Server)server));
            } else {
                LOGGER.trace("sickServerSet empty");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void checkServer(Server server) {
        if (server.isValidandAlive()) {
            this.sickServerSet.remove(server);
            server.setAlive(true);
            LOGGER.debug("Resurrecting server at {}", (Object)server);
            this.caServerList.addToServerList(server);
        } else {
            LOGGER.debug("Server still sick: {}", (Object)server);
        }
    }

    public void clear() {
        this.sickServerSet.clear();
    }

    public void add(Server server) {
        this.sickServerSet.add(server);
    }

    int getSickSize() {
        return this.sickServerSet.size();
    }
}

