/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassportValidator {
    private static Logger LOGGER = LoggerFactory.getLogger(PassportValidator.class);
    private static Cache<String, MutableLong> passportCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).build();
    public static final String CAM_PASSPORT = "cam_passport";
    public static final int PASSPORT_OK = 1;
    public static final int PASSPORT_EMPTY = 0;
    public static final int PASSPORT_EXPIRED = -1;
    public static final String GATEWAY_HEADER = "Cognos-Gateway";
    private static final Set<String> ALLOWEDMETHODS = Stream.of("OPTIONS", "HEAD").collect(Collectors.toCollection(HashSet::new));
    private RESTClientFactory rcFactory;
    private ConfigurationPropertyFactory configurationPropertyFactory;

    public PassportValidator(RESTClientFactory restClientFactory, ConfigurationPropertyFactory configurationPropertyFactory) {
        this.rcFactory = restClientFactory;
        this.configurationPropertyFactory = configurationPropertyFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkPassportValidity(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MutableLong passportValidTime;
        if (request.getHeader(GATEWAY_HEADER) != null) {
            return 1;
        }
        if (ALLOWEDMETHODS.contains(request.getMethod())) {
            return 1;
        }
        String camPassport = this.getPassportCookie(request);
        if (camPassport == null) {
            LOGGER.debug("checkForPassportValidity: no passport");
            return 0;
        }
        final Long currentTime = System.currentTimeMillis() / 1000L;
        try {
            passportValidTime = (MutableLong)passportCache.get((Object)camPassport, (Callable)new Callable<MutableLong>(){

                @Override
                public MutableLong call() {
                    return new MutableLong((Number)currentTime);
                }
            });
        }
        catch (ExecutionException e1) {
            passportValidTime = new MutableLong((Number)currentTime);
        }
        if (passportValidTime.longValue() - currentTime <= 0L) {
            MutableLong mutableLong = passportValidTime;
            synchronized (mutableLong) {
                if (passportValidTime.longValue() - currentTime <= 0L) {
                    Long passportValidUntil = currentTime;
                    try {
                        StringBuilder passportValidResp = new StringBuilder();
                        int status = this.remoteValidatePassport(request, passportValidResp);
                        if (status == 200) {
                            passportValidUntil = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).parse(passportValidResp.toString()).getTime() / 1000L;
                        } else {
                            LOGGER.debug("checkForPassportValidity: remote passport validation failed with status {}", (Object)status);
                        }
                    }
                    catch (IOException | ParseException e) {
                        LOGGER.error("checkForPassportValidity: remote passport validation Exception {}", (Object)e.getMessage());
                    }
                    passportValidTime.setValue((Object)passportValidUntil);
                }
            }
        }
        if (passportValidTime.longValue() - currentTime <= 0L) {
            LOGGER.debug("checkForPassportValidity: passport expired {}", (Object)camPassport);
            return -1;
        }
        return 1;
    }

    private String getPassportCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String passport = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(CAM_PASSPORT)) continue;
                passport = cookie.getValue();
                break;
            }
        }
        return passport;
    }

    private int remoteValidatePassport(HttpServletRequest request, StringBuilder validUntilDate) throws IOException, ServletException {
        int status = 200;
        String defaultCmUrl = String.format("%s://localhost:%d/p2pd/servlet", request.getScheme(), request.getLocalPort());
        String cmUrl = this.configurationPropertyFactory.getStringProperty("contentManager").get();
        if (!StringUtils.startsWith((String)cmUrl, (String)"http")) {
            LOGGER.error("Invalid CM URL from config-api: {}", (Object)cmUrl);
            cmUrl = defaultCmUrl;
        }
        cmUrl = cmUrl + "/dispatch/sacam";
        try (RESTClient restClient = this.rcFactory.getClient(request);){
            restClient.setRequestHeader("Cache-Control", "no-cache");
            status = restClient.getResource(cmUrl);
            if (status == 200) {
                JsonObject resp = restClient.getResponseAsJsonObject();
                validUntilDate.append(resp.getString("expires"));
            } else if (status == 500) {
                JsonObject resp = restClient.getResponseAsJsonObject();
                StringBuilder errorMessage = new StringBuilder();
                JsonArray errors = resp.getArray("errors");
                for (Object anError : errors) {
                    errorMessage.append(((JsonObject)anError).getString("message"));
                    errorMessage.append(": ");
                }
                throw new ServletException(errorMessage.toString());
            }
        }
        return status;
    }
}

