/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringProperty;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BICookie
extends Cookie {
    private static final Logger LOGGER = LoggerFactory.getLogger(BICookie.class);
    private static final long serialVersionUID = -8234341801510520231L;
    private final transient HttpServletRequest request;
    private transient DynamicStringProperty pathProp = null;
    private transient DynamicStringProperty domainProp = null;
    private transient DynamicBooleanProperty secureProp = null;
    private transient DynamicBooleanProperty camHttpOnly = null;
    private transient DynamicStringProperty sameSite = null;
    public static final String AUTOMATIC_COOKIE_DOMAIN = "automatic";
    private static final String STRICT = "Strict";
    private static final String LAX = "Lax";
    private static final String NONE = "None";
    private static final Set<String> validSameSite = new HashSet<String>(Arrays.asList("Strict", "Lax", "None"));

    public BICookie(HttpCookie httpCookie, HttpServletRequest request) {
        super(httpCookie.getName(), httpCookie.getValue());
        this.request = request;
        this.initialize((int)httpCookie.getMaxAge());
    }

    public BICookie(Cookie cookie, HttpServletRequest request) {
        super(cookie.getName(), cookie.getValue());
        this.request = request;
        this.initialize(cookie.getMaxAge());
    }

    public BICookie(HttpCookie cookie, HttpServletRequest request, DynamicStringProperty pathProp, DynamicStringProperty domainProp, DynamicBooleanProperty secureProp, DynamicBooleanProperty camHttpOnly, DynamicStringProperty sameSite) {
        super(cookie.getName(), cookie.getValue());
        this.request = request;
        this.pathProp = pathProp;
        this.domainProp = domainProp;
        this.secureProp = secureProp;
        this.camHttpOnly = camHttpOnly;
        this.sameSite = sameSite;
        this.initialize((int)cookie.getMaxAge());
    }

    private void initialize(int maxAge) {
        if (this.pathProp == null) {
            this.pathProp = ConfigurationPropertyFactory.getInstance().getStringProperty("cookiePath", "");
            this.domainProp = ConfigurationPropertyFactory.getInstance().getStringProperty("cookieDomain", "");
            this.secureProp = ConfigurationPropertyFactory.getInstance().getBooleanProperty("cookieSecure", false);
            this.camHttpOnly = ConfigurationPropertyFactory.getInstance().getBooleanProperty("cookieCAMPassportHttpOnly", true);
            this.sameSite = ConfigurationPropertyFactory.getInstance().getStringProperty("Configuration.cookieSameSite", "");
        }
        this.setPath(this.getCookiePath());
        String domain = this.getCookieDomain();
        if (domain != null) {
            this.setDomain(domain);
        }
        this.setMaxAge(maxAge);
        this.setSecure(this.getCookieSecure());
        this.setHttpOnly(this.getIsHttpOnly());
    }

    public boolean getIsHttpOnly() {
        if (this.getName().equals("cam_passport")) {
            return this.camHttpOnly.get();
        }
        return false;
    }

    private String getCookieDomain() {
        Object domain = this.domainProp.get();
        if (StringUtils.isNotEmpty((String)domain) && AUTOMATIC_COOKIE_DOMAIN.equals(domain)) {
            String host = this.determineHost();
            domain = !this.isIPAddress(host) ? this.getRfc2109CompatableDomain(host) : (this.isLocalHost(host) ? null : host);
        }
        return domain;
    }

    private boolean isLocalHost(String host) {
        return "127.0.0.1".equals(host) || "::1".equals(host);
    }

    private String determineHost() {
        String host = this.request.getHeader("X-Forwarded-Host");
        if (host == null) {
            host = this.request.getServerName();
        }
        return host;
    }

    private boolean isIPAddress(String host) {
        return this.isIPV6(host) || this.isIPV4(host);
    }

    private boolean isIPV4(String host) {
        String[] parts = host.split("\\.");
        if (parts.length == 4) {
            for (String part : parts) {
                if (part.matches("\\d+")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isIPV6(String host) {
        return host.split(":").length >= 3;
    }

    private String getRfc2109CompatableDomain(String http_host) {
        if (!http_host.contains(".")) {
            return null;
        }
        int dotIndex = http_host.indexOf(".");
        String domain = http_host.substring(dotIndex);
        if (BICookie.containsTwoDots(domain)) {
            return domain;
        }
        return null;
    }

    private static boolean containsTwoDots(String domain) {
        return domain.substring(1).contains(".");
    }

    private String getCookiePath() {
        String path = this.pathProp.get();
        if (path == null || path.length() == 0) {
            String original = this.getOriginalPath();
            if (original != null) {
                path = original;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append(this.request.getContextPath());
                buf.append(this.request.getServletPath());
                path = buf.toString();
            }
            String cookieName = this.getName();
            path = this.pathUpOneLevel(cookieName, path);
        }
        return path;
    }

    private String getOriginalPath() {
        String path = (String)this.request.getAttribute("X-Original-URI");
        if (StringUtils.isEmpty((String)path)) {
            path = this.request.getHeader("X-BI-PATH");
        }
        return path;
    }

    private boolean getCookieSecure() {
        return this.secureProp.get();
    }

    private String pathUpOneLevel(String cookieName, String path) {
        String newPath = path;
        if (cookieName.equals("usersessionid") || cookieName.equals("XSRF-TOKEN") || cookieName.equals("cam_passport") || cookieName.equals("up")) {
            newPath = path.substring(0, path.lastIndexOf("/"));
        }
        return newPath;
    }

    public String asSetCookieHeader() {
        String sameSiteS;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("=").append(this.getValue());
        if (this.getMaxAge() >= 0) {
            sb.append("; ").append("Max-Age=").append(this.getMaxAge());
        }
        if (StringUtils.isNotBlank((String)this.getDomain())) {
            sb.append("; ").append("Domain=").append(this.getDomain());
        }
        sb.append("; ").append("Path=").append(this.getPath());
        if (this.getSecure()) {
            sb.append("; ").append("Secure");
        }
        if (this.getIsHttpOnly()) {
            sb.append("; ").append("HttpOnly");
        }
        if (StringUtils.isNotBlank((String)(sameSiteS = this.sameSite.get()))) {
            if (validSameSite.contains(sameSiteS)) {
                sb.append("; ").append("SameSite=").append(sameSiteS);
                if (StringUtils.equals((String)NONE, (String)sameSiteS) && !this.getSecure() && !this.getSecure()) {
                    sb.append("; Secure");
                    LOGGER.warn("Adding 'Secure' flag since SameSite=None is set.");
                }
            } else {
                LOGGER.error("Invalid SameSite option {}. Valid settings are 'Strict', 'Lax', or 'None'", (Object)sameSiteS);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting cookie: {}", (Object)sb.toString());
        }
        return sb.toString();
    }
}

