/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.commons.web.filters.MessageKeys;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BIProxyBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIProxyBase.class);
    private static final String ROOT_PATH = "BIServiceProxy.rootPath";
    private static RESTClientFactory clientFactory = null;
    private static final String BI_PROXY = "bi-proxy";
    private static final DynamicStringProperty sdkDispatcher = ConfigurationPropertyFactory.getInstance().getStringProperty("sdk");
    private static final DynamicStringProperty gatewayURI = ConfigurationPropertyFactory.getInstance().getStringProperty("gateway");

    protected abstract Logger getLogger();

    protected abstract String getTargetServiceName(HttpServletRequest var1);

    protected void setRESTClientFactory(RESTClientFactory factory) {
        clientFactory = factory;
    }

    private RESTClientFactory getRESTClientFactory() {
        if (clientFactory == null) {
            clientFactory = this.makeFactory();
        }
        return clientFactory;
    }

    private RESTClientFactory makeFactory() {
        RESTClientFactory factory = new RESTClientFactory();
        factory.shutdown();
        factory.startup(BI_PROXY, false);
        return factory;
    }

    protected void remote(HttpServletRequest request, HttpServletResponse response, String endPoint) throws IOException {
        String proxyUrl = this.buildProxyUrl(request, endPoint);
        RESTClientConfig proxyClientConfig = this.createProxyClientConfig(request);
        String contentType = proxyClientConfig.getRequestHeader("Content-Type").getValue();
        this.getLogger().debug("Proxying: {}", (Object)proxyUrl);
        try (RESTClient client = this.getRESTClientFactory().getClient(proxyClientConfig);){
            String trustedService = request.getParameter("trust");
            if (StringUtils.isNotEmpty((String)trustedService)) {
                client.makeTrusted(trustedService);
            }
            switch (request.getMethod()) {
                case "GET": {
                    client.getResource(proxyUrl);
                    break;
                }
                case "PUT": {
                    client.updateResource(proxyUrl, contentType, -1L, (InputStream)request.getInputStream());
                    break;
                }
                case "POST": {
                    client.createResource(proxyUrl, contentType, -1L, (InputStream)request.getInputStream());
                    break;
                }
                case "DELETE": {
                    client.deleteResource(proxyUrl, null);
                }
            }
            this.respond(client, response);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String msg = e.getMessage();
            if (StringUtils.isEmpty((String)msg) && cause != null) {
                msg = cause.getMessage();
            }
            if (!response.isCommitted()) {
                String clientMsg = new Message(MessageKeys.PROXY_CONNECTION_FAILURE, (Object)this.getTargetServiceName(request)).toString();
                response.sendError(this.getStatus(e, cause), clientMsg);
            }
            this.getLogger().error("Error sending request to {}, from '{}'. Reason: {}", new Object[]{StringUtils.substringBefore((String)proxyUrl, (String)"?"), proxyClientConfig.getRequestHeader("X-BI-Forwarded-For").getValue(), msg});
        }
    }

    int getStatus(Exception e, Throwable cause) {
        if (e instanceof InterruptedIOException || cause instanceof InterruptedIOException) {
            return 408;
        }
        if (e instanceof SocketException || cause instanceof SocketException) {
            return 503;
        }
        return 500;
    }

    String buildProxyUrl(HttpServletRequest request, String endPoint) {
        String rootPath = (String)request.getAttribute(ROOT_PATH);
        StringBuilder url = new StringBuilder(endPoint);
        url.append(StringUtils.isNotEmpty((String)rootPath) ? StringUtils.substringBefore((String)rootPath, (String)"/bi/v1") : "");
        String requestURI = request.getRequestURI();
        url.append(StringUtils.contains((String)requestURI, (String)"/proxy") ? StringUtils.substringAfter((String)requestURI, (String)"/proxy") : requestURI);
        url.append(HttpUtils.buildQueryString((HttpServletRequest)request));
        return url.toString();
    }

    RESTClientConfig createProxyClientConfig(HttpServletRequest request) {
        RESTClientConfig config = this.newConfig(BI_PROXY);
        Enumeration names = request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (HttpUtils.hopByHopHeaders.containsHeader(name) || "Content-Length".equalsIgnoreCase(name) || "Host".equalsIgnoreCase(name)) continue;
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    config.setRequestHeader(name, (String)values.nextElement());
                }
            }
        }
        config.setRequestHeader("X-CA-Proxy", "1");
        config.setRequestHeader("X-CA-Server", HttpUtils.getServerName());
        config.setRequestHeader("X-CA-SDKSERVER", this.getSHP(this.getConfigSdkDispatcher()));
        config.setRequestHeader("X-CA-Gateway", this.getSHP(this.getConfigGatewayURI()));
        if (config.getRequestHeader("Content-Type") == null) {
            config.setRequestHeader("Content-Type", "application/octet-stream");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("config headers: {}", (Object)config.getRequestHeaders());
        }
        return config;
    }

    String getSHP(String url) {
        try {
            URI uri = new URI(url);
            return uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
        }
        catch (URISyntaxException e) {
            this.getLogger().error("invalid url: {}", (Object)url);
            return HttpUtils.getServerName();
        }
    }

    RESTClientConfig newConfig(String context) {
        return new RESTClientConfig(context);
    }

    String getConfigGatewayURI() {
        return gatewayURI.get();
    }

    String getConfigSdkDispatcher() {
        return sdkDispatcher.get();
    }

    void respond(RESTClient client, HttpServletResponse response) throws IOException {
        response.setStatus(client.getResponseCode());
        HttpUtils.copyResponseHeaders((RESTClient)client, (HttpServletResponse)response);
        InputStream in = client.getResponseStream();
        if (in != null) {
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
    }

    protected void local(HttpServletRequest request, HttpServletResponse response, String context) throws IOException {
        String forwardUrl = request.getRequestURI().replaceAll(".*/proxy/" + context, "") + HttpUtils.buildQueryString((HttpServletRequest)request);
        this.getLogger().debug("Fowarding: [{}] {}", (Object)context, (Object)forwardUrl);
        ServletContext sourceContext = request.getServletContext();
        ServletContext targetContext = sourceContext.getContext("/" + context);
        if (targetContext != null) {
            RequestDispatcher rq = targetContext.getRequestDispatcher(forwardUrl);
            try {
                rq.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                response.setStatus(503);
            }
        } else {
            response.setStatus(503);
        }
    }
}

