/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.google.common.net.HostAndPort;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.logging.glug.support.BITransactionHeader;
import com.ibm.bi.platform.commons.http.util.CAHttpMethods;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.netflix.config.DynamicStringProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER;
    private static final String HTTP_IF_NONE_MATCH = "If-None-Match";
    private static final String HTTP_IF_MATCH = "If-Match";
    private static String ENCODING_PATTERN;
    private static DynamicStringProperty configLoginParameters;
    private static final String M_PASSPORT_PARAMETER = "m_passportID";
    private boolean mPassportParameterAllowed = false;
    private static String[] dispatcherHeaders;
    private static HeaderGroup specialHeaders;
    private final BITransactionHeader transactionHeader;

    BIRequestWrapper(HttpServletRequest request, boolean mPassportParameterAllowed, BITransactionHeader transactionHeader) {
        super(request);
        this.mPassportParameterAllowed = mPassportParameterAllowed || this.isPassportParameterAllowed(request);
        this.transactionHeader = transactionHeader;
    }

    public BIRequestWrapper(HttpServletRequest request) {
        super(request);
        this.mPassportParameterAllowed = this.isPassportParameterAllowed(request);
        this.transactionHeader = this.createTransactionHeader();
    }

    private boolean isPassportParameterAllowed(HttpServletRequest request) {
        if (StringUtils.contains((String)configLoginParameters.get(), (String)M_PASSPORT_PARAMETER)) {
            return true;
        }
        return StringUtils.endsWith((String)request.getRequestURI(), (String)"/metadataUIService");
    }

    protected BITransactionHeader createTransactionHeader() {
        LOGGER.debug("X-BI-Forwarded-For: {}, pathInfo: {}", (Object)super.getHeader("X-BI-Forwarded-For"), (Object)super.getPathInfo());
        String currentHeader = super.getHeader("X-CA-Transaction");
        if (StringUtils.isEmpty((String)currentHeader)) {
            currentHeader = this.getCookieValue("CATransaction");
            if (StringUtils.isNotEmpty((String)currentHeader)) {
                try {
                    currentHeader = URLDecoder.decode(currentHeader, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                LOGGER.debug("got Transaction header from cookie: {}", (Object)currentHeader);
            }
        } else {
            LOGGER.debug("got Transaction header from header: {}", (Object)currentHeader);
        }
        return new BITransactionHeader(currentHeader);
    }

    public String getCookieValue(String cookieName) {
        String cookieValue = null;
        Cookie[] cookies = super.getCookies();
        if (cookies != null) {
            for (Cookie aCookie : cookies) {
                if (!aCookie.getName().equalsIgnoreCase(cookieName)) continue;
                cookieValue = aCookie.getValue();
                break;
            }
        }
        return cookieValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList nameList = Collections.list(super.getHeaderNames());
        nameList.add("X-CA-Transaction");
        nameList.addAll(Arrays.asList(dispatcherHeaders));
        return Collections.enumeration(nameList);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        if (header != null && (HTTP_IF_NONE_MATCH.equalsIgnoreCase(name) || HTTP_IF_MATCH.equalsIgnoreCase(name))) {
            return this.fixEtag(header);
        }
        if ("Original-Script-Name".equalsIgnoreCase(name)) {
            header = this.getDispatcherPath();
        } else if ("Original-Host".equalsIgnoreCase(name)) {
            header = this.getOriginalServerName();
        } else if ("Original-Server_Port".equalsIgnoreCase(name)) {
            header = Integer.toString(this.getOriginalServerPort());
        } else if ("Original-https".equalsIgnoreCase(name)) {
            header = this.getOriginalSSL();
        } else if ("Original-Remote-Addr".equalsIgnoreCase(name) && header == null) {
            header = this.getForwardedFor();
        } else if ("X-WebContentRoot".equalsIgnoreCase(name) && header == null) {
            header = "../..";
            String xBIPath = (String)this.getAttribute("X-Original-URI");
            if (xBIPath != null) {
                if (xBIPath.contains("/bi/")) {
                    header = xBIPath.substring(0, xBIPath.lastIndexOf("/bi/"));
                    if ("".equals(header) && StringUtils.equals((String)"/mobileService/user/home2.json", (String)this.getPathInfo())) {
                        header = "/";
                    }
                } else if (this.getHeader("Cognos-Gateway") != null) {
                    header = "";
                }
            }
        } else if ("X-Forwarded-Host".equalsIgnoreCase(name) && header == null) {
            header = super.getHeader("Original-Host");
        } else if ("X-CA-Transaction".equalsIgnoreCase(name)) {
            header = this.transactionHeader.getValue();
        }
        LOGGER.trace("Header {} : {}", (Object)name, (Object)header);
        return header;
    }

    private String getDispatcherPath() {
        String path = (String)this.getAttribute("X-Original-URI");
        if (path == null) {
            path = ".";
        }
        return path + "/disp";
    }

    public Enumeration<String> getHeaders(String name) {
        if (specialHeaders.containsHeader(name)) {
            return Collections.enumeration(Arrays.asList(this.getHeader(name)));
        }
        return super.getHeaders(name);
    }

    public String getOriginalServerName() {
        String host = this.getForwardedHost();
        if (host != null && host.length() > 0) {
            if (host.contains(":")) {
                host = host.substring(0, host.indexOf(":"));
            }
            return host;
        }
        return super.getServerName();
    }

    public int getOriginalServerPort() {
        String host = this.getForwardedHost();
        if (host != null && host.length() > 0) {
            if (host.contains(":")) {
                String port = host.substring(host.indexOf(":") + 1);
                try {
                    return Integer.parseInt(port);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 80;
        }
        return super.getServerPort();
    }

    private String getOriginalSSL() {
        String ssl = this.getForwardedProto();
        if (ssl == null) {
            ssl = super.getScheme();
        }
        if (ssl != null && ssl.trim().equalsIgnoreCase("https")) {
            return "on";
        }
        return null;
    }

    private String getForwardedProto() {
        String xForwardedProto = super.getHeader("X-Forwarded-Proto");
        if (xForwardedProto != null) {
            return xForwardedProto;
        }
        return null;
    }

    private String getForwardedFor() {
        String origXForwardedFor = super.getHeader("X-Forwarded-For");
        if (origXForwardedFor != null) {
            String xForwardedFor = origXForwardedFor.split(",")[0];
            try {
                HostAndPort hp = HostAndPort.fromString((String)xForwardedFor);
                return hp.getHostText();
            }
            catch (Exception e) {
                LOGGER.debug("Error parsing X-Forwarded-For header: {}", (Object)origXForwardedFor);
                return xForwardedFor;
            }
        }
        return null;
    }

    private String getForwardedHost() {
        String xForwardedHost = super.getHeader("X-Forwarded-Host");
        if (xForwardedHost != null) {
            return xForwardedHost.split(",")[0];
        }
        return null;
    }

    private String fixEtag(String header) {
        return header.replaceAll(ENCODING_PATTERN, "");
    }

    public Locale getLocale() {
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("up")) continue;
                UserPreferences up = new UserPreferences(cookie.getValue());
                return this.decodeLocale(up);
            }
        }
        return super.getLocale();
    }

    protected Locale decodeLocale(UserPreferences up) {
        String productLocale;
        if (up != null && (productLocale = up.getProductLocale()) != null) {
            return new Locale(productLocale);
        }
        return super.getLocale();
    }

    public BITransactionHeader getTransactionHeader() {
        return this.transactionHeader;
    }

    public String getMethod() {
        String methodOverride = this.getHeader("X-Http-Method-Override");
        if (StringUtils.isNotBlank((String)methodOverride)) {
            if (CAHttpMethods.isValid((String)methodOverride)) {
                return methodOverride;
            }
            LOGGER.error("Unsupported X-Http-Method-Override value: {}", (Object)methodOverride);
        }
        return super.getMethod();
    }

    public String getQueryString() {
        String qs = super.getQueryString();
        if (StringUtils.isNotBlank((String)qs) && !this.mPassportParameterAllowed) {
            return qs.replaceAll("(\\?|&)?m_passportID=[^&]+(&)?", "$1");
        }
        return qs;
    }

    public String getParameter(String name) {
        if (!this.mPassportParameterAllowed && StringUtils.equals((String)name, (String)M_PASSPORT_PARAMETER)) {
            return null;
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.mPassportParameterAllowed) {
            Set entries = super.getParameterMap().entrySet();
            HashMap mapCopy = (HashMap)entries.stream().filter(e -> !StringUtils.equals((String)M_PASSPORT_PARAMETER, (String)((String)e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Collections.unmodifiableMap(mapCopy);
        }
        return super.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        if (!this.mPassportParameterAllowed) {
            return Collections.enumeration(Collections.list(super.getParameterNames()).stream().filter(s -> !StringUtils.equals((String)M_PASSPORT_PARAMETER, (String)s)).collect(Collectors.toList()));
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.mPassportParameterAllowed && StringUtils.equals((String)name, (String)M_PASSPORT_PARAMETER)) {
            return null;
        }
        return super.getParameterValues(name);
    }

    static {
        String[] headers;
        LOGGER = LoggerFactory.getLogger(BIRequestWrapper.class);
        ENCODING_PATTERN = "-gzip$";
        configLoginParameters = ConfigurationPropertyFactory.getInstance().getStringProperty("Glass.urlLoginParameters", "");
        dispatcherHeaders = new String[]{"Original-Script-Name", "Original-Host", "Original-Server_Port", "Original-https", "X-WebContentRoot"};
        specialHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"HTTP_IF_NONE_MATCH", "HTTP_IF_MATCH"}) {
            specialHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        for (String header : dispatcherHeaders) {
            specialHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        specialHeaders.addHeader((Header)new BasicHeader("X-CA-Transaction", null));
    }
}

