/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.logging.glug.support.BITransactionHeader;
import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import com.ibm.bi.platform.commons.web.BICookie;
import com.ibm.bi.platform.commons.web.BIRequestWrapper;
import com.ibm.icu.util.Calendar;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicFloatProperty;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIResponseWrapper.class);
    private static final int dayInSeconds = 86400;
    private final BIRequestWrapper request;
    private static DynamicBooleanProperty caServerHeader = ConfigurationPropertyFactory.getInstance().getBooleanProperty("CAServerHeader", false);
    private static DynamicFloatProperty staticExpires = ConfigurationPropertyFactory.getInstance().getFloatProperty("BIResponseWrapper.staticExpiresDays", 0.0f);
    private static final String[] overrideHeaders = new String[]{"Expires", "Cache-Control"};
    protected static final HeaderGroup overrideResponseHeaders = new HeaderGroup();
    private Pattern dynamicResourcePattern = Pattern.compile(".*((/v1/.*)|(bi(/)?$)|(.jsp$))");
    static final Set<Integer> cacheableStatuses;

    public BIResponseWrapper(BIRequestWrapper request, HttpServletResponse response) {
        super(response);
        this.request = request;
        this.initialize();
    }

    protected void initialize() {
        if (this.isDynamicContent(this.request.getRequestURI())) {
            this.setDynamicCacheResponseHeaders();
        } else {
            this.setStaticCacheResponseHeaders();
        }
        this.setHTTPStrictTransportSecurityHeader();
        this.setCAServerHeader();
        this.setTransactionResponseHeader();
    }

    void setTransactionResponseHeader() {
        BITransactionHeader trHeader = this.getTransactionHeader();
        if (trHeader != null) {
            this.setHeader(trHeader.getName(), trHeader.getRootID());
        }
    }

    BITransactionHeader getTransactionHeader() {
        return this.request.getTransactionHeader();
    }

    boolean isDynamicContent(String uri) {
        return this.dynamicResourcePattern.matcher(uri).matches();
    }

    private void setDynamicCacheResponseHeaders() {
        if ("GET".equals(this.request.getMethod())) {
            super.setHeader("Cache-Control", "must-revalidate");
        } else {
            super.setHeader("Cache-Control", "no-cache");
        }
        super.addDateHeader("Expires", 0L);
    }

    private void setStaticCacheResponseHeaders() {
        if ("GET".equals(this.request.getMethod())) {
            super.setDateHeader("Expires", this.getStaticExpiresDate().getTime());
            super.setHeader("Cache-Control", "max-age=" + this.getStaticExpiresSeconds());
        }
    }

    float getConfigDays() {
        return staticExpires.get();
    }

    private float getMultiplier() {
        float multiplier = this.getConfigDays();
        return multiplier <= 365.0f ? multiplier : 365.0f;
    }

    private int getStaticExpiresSeconds() {
        return Math.round(86400.0f * this.getMultiplier());
    }

    private Date getStaticExpiresDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(13, this.getStaticExpiresSeconds());
        return cal.getTime();
    }

    private void setCAServerHeader() {
        if (caServerHeader.get() && this.getHeader("X-CA-Server") == null) {
            super.setHeader("X-CA-Server", LocalAddresses.getHostName() + ":" + this.request.getLocalPort());
        }
    }

    void setHTTPStrictTransportSecurityHeader() {
        int maxAge;
        if ("https".equalsIgnoreCase(this.request.getScheme()) && (maxAge = this.getHstsMaxAge()) >= 0) {
            this.setHeader("Strict-Transport-Security", "max-age=" + Integer.toString(maxAge));
        }
    }

    int getHstsMaxAge() {
        return ConfigurationPropertyFactory.getInstance().getIntProperty("BIFilter.hstsMaxAge", -1).get();
    }

    public void setStatus(int sc) {
        int code = sc;
        if (code == 401) {
            code = this.handleAuthFailure();
        } else {
            this.logErrorCode(sc);
        }
        this.fixCacheHeader(sc);
        super.setStatus(code);
    }

    public void sendError(int sc, String msg) throws IOException {
        int code = sc;
        if (code == 401) {
            code = this.handleAuthFailure();
        } else {
            this.logErrorCode(sc);
        }
        this.fixCacheHeader(sc);
        this.setContentType("text/plain");
        this.setStatus(code);
        this.getWriter().write(msg);
    }

    public void sendError(int sc) throws IOException {
        int code = sc;
        if (code == 401) {
            code = this.handleAuthFailure();
        } else {
            this.logErrorCode(sc);
        }
        this.fixCacheHeader(sc);
        this.setContentType("text/plain");
        this.setStatus(code);
    }

    private void fixCacheHeader(int code) {
        if (304 != code && !cacheableStatuses.contains(code)) {
            super.setHeader("Cache-Control", "no-cache, no-store");
        }
    }

    private void logErrorCode(int code) {
        if (code >= 400) {
            if (code == 404) {
                return;
            }
            if (code == 441) {
                String forwardedFor = this.request.getHeader("X-BI-Forwarded-For");
                if (StringUtils.isNotEmpty((String)forwardedFor)) {
                    LOGGER.warn("HttpServletResponseCode for {} is in error: {}, caller: {}", new Object[]{this.request.getRequestURI(), code, forwardedFor});
                }
                return;
            }
            LOGGER.error("HttpServletResponseCode for {} is in error: {}", (Object)this.request.getRequestURI(), (Object)code);
        }
    }

    public void addHeader(String name, String value) {
        if (name.startsWith("Set-Cookie")) {
            this.addCookieList(HttpCookie.parse(value));
        } else if (overrideResponseHeaders.containsHeader(name)) {
            super.setHeader(name, value);
        } else {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (name.startsWith("Set-Cookie")) {
            this.addCookieList(HttpCookie.parse(value));
        } else {
            super.setHeader(name, value);
        }
    }

    private void addCookieList(List<HttpCookie> httpCookies) {
        for (HttpCookie cookie : httpCookies) {
            this.addCookie(new BICookie(cookie, (HttpServletRequest)this.request));
        }
    }

    public void addCookie(Cookie cookie) {
        BICookie biCookie = cookie instanceof BICookie ? (BICookie)cookie : new BICookie(cookie, (HttpServletRequest)this.request);
        super.addHeader("Set-Cookie", biCookie.asSetCookieHeader());
    }

    protected int handleAuthFailure() {
        if (this.getHeader("WWW-Authenticate") == null) {
            this.setHeader("WWW-Authenticate", "CAM realm=\"default\"");
        }
        if (this.getHeader("X-CAM-Location") == null) {
            this.setHeader("X-CAM-Location", this.getRequestPath() + "/login");
        }
        LOGGER.debug("HttpServletResponseCode is UNAUTHORIZED {}", (Object)this.request.getRequestURI());
        return this.handleSSO();
    }

    int handleSSO() {
        String xCASSO = this.request.getHeader("X-CA-SSO");
        int status = 441;
        if (xCASSO != null) {
            try {
                status = Integer.parseInt(xCASSO);
            }
            catch (NumberFormatException e) {
                status = 441;
            }
        }
        return status;
    }

    String getRequestPath() {
        String path;
        String original = (String)this.request.getAttribute("X-Original-URI");
        if (original != null) {
            path = original;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(this.request.getContextPath());
            buf.append(this.request.getServletPath());
            path = buf.toString();
            LOGGER.debug("Cookie path defaulting to: {}", (Object)path);
        }
        return path;
    }

    static {
        for (String header : overrideHeaders) {
            overrideResponseHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        cacheableStatuses = new HashSet<Integer>(Arrays.asList(200, 203, 300, 301));
    }
}

