/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.platform.commons.web.BIProxyBase;
import com.ibm.bi.platform.commons.web.LocalServiceRegistry;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIServiceProxy
extends BIProxyBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIServiceProxy.class);
    private static final String CONTEXT = "BIServiceProxy.context";
    private LocalServiceRegistry registry = null;

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getTargetServiceName(HttpServletRequest request) {
        return (String)request.getAttribute(CONTEXT);
    }

    protected void setServiceRegistry(LocalServiceRegistry registry) {
        this.registry = registry;
    }

    public void proxyRequest2(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.proxyRequest((HttpServletRequest)new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                String uri = super.getRequestURI();
                if (StringUtils.contains((String)uri, (String)"/bi/v1")) {
                    return StringUtils.substringAfter((String)uri, (String)"/bi/v1");
                }
                return uri;
            }
        }, response);
    }

    public void proxyRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String context = (String)request.getAttribute(CONTEXT);
        String endPoint = this.getEndpoint(context, request);
        if (StringUtils.isNotEmpty((String)endPoint)) {
            this.remote(request, response, endPoint);
        } else if (StringUtils.isNotEmpty((String)context)) {
            this.local(request, response, context);
        } else {
            response.setStatus(503);
        }
    }

    String getEndpoint(String context, HttpServletRequest request) {
        URL caEndpoint = HttpUtils.getCAEndpoint((HttpServletRequest)request);
        if (caEndpoint != null) {
            return caEndpoint.toString();
        }
        if (StringUtils.isNotEmpty((String)context)) {
            return this.registry.getServiceAddress(context);
        }
        return this.registry.getAddress(request.getPathInfo());
    }

    public void init(ServletConfig config) {
        this.registry = LocalServiceRegistry.getInstance();
    }
}

