/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.platform.commons.web.CompressedServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CompressedServletResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream cos = null;
    private PrintWriter writer = null;
    private boolean isAlreadyCompressed = false;

    public CompressedServletResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.cos != null) {
            this.cos.close();
            this.cos = null;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.cos != null) {
            this.cos.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("Could not create ServletOutputStream because PrintWriter was already created");
        }
        if (this.cos == null) {
            if (!this.isAlreadyCompressed) {
                this.setHeader("Content-Encoding", "gzip");
                this.setHeader("X-Compressed-By", "BICompressionFilter");
                this.cos = new CompressedServletOutputStream((OutputStream)this.getResponse().getOutputStream());
            } else {
                this.cos = this.getResponse().getOutputStream();
            }
        }
        return this.cos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null && this.cos != null) {
            throw new IllegalStateException("Could not create PrintWriter because ServletOutputStream was already created");
        }
        if (this.writer == null) {
            this.cos = this.getOutputStream();
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.cos, this.getResponse().getCharacterEncoding()));
        }
        return this.writer;
    }

    public void setContentLength(int len) {
    }

    public void addHeader(String name, String value) {
        if ("Content-Encoding".equals(name)) {
            this.isAlreadyCompressed = true;
        } else if ("Content-Length".equals(name)) {
            return;
        }
        super.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if ("Content-Encoding".equals(name)) {
            this.isAlreadyCompressed = true;
        } else if ("Content-Length".equals(name)) {
            return;
        }
        super.setHeader(name, value);
    }
}

