/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.netflix.config.DynamicStringProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServiceRegistry {
    private final Logger LOGGER = LoggerFactory.getLogger(LocalServiceRegistry.class);
    private static final LocalServiceRegistry instance = new LocalServiceRegistry();
    private final String SERVER_DIR = System.getProperty("server.config.dir") + "../";
    private final String BOOTSTRAP_PROPERTIES = "/bootstrap.properties";
    private final Set<String> skipDirs = new HashSet<String>(Arrays.asList("cognosserver", "javasharedresources", ".classCache", ".logs"));
    private final DynamicStringProperty configServices = ConfigurationPropertyFactory.getInstance().getStringProperty("BIProxy.services", "");
    protected Map<String, String> serviceAddresses = null;
    private boolean enableApiDocs = Boolean.getBoolean("api-docs");
    boolean doReload = false;

    private LocalServiceRegistry() {
        this.configServices.addCallback(new Runnable(){

            @Override
            public void run() {
                LocalServiceRegistry.this.loadFromConfig(LocalServiceRegistry.this.configServices.get());
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.serviceAddresses = new HashMap<String, String>();
        File directory = new File(this.SERVER_DIR);
        File propertyFile = new File(directory.getPath() + "/services.properties");
        if (propertyFile.exists()) {
            this.loadFromPropertiesFile(propertyFile);
        }
        this.loadFromDirectories(directory);
        this.loadFromConfig(this.configServices.get());
    }

    private void loadFromPropertiesFile(File propertyFile) {
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(propertyFile);){
            props.load(input);
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                this.LOGGER.info("Adding service {}", (Object)((String)value));
                this.serviceAddresses.put((String)key, (String)value);
            }));
        }
        catch (IOException e) {
            this.LOGGER.error(e.getLocalizedMessage());
        }
    }

    private void loadFromDirectories(File directory) {
        String[] services = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return !LocalServiceRegistry.this.skipDirs.contains(name) && new File(current, name).isDirectory();
            }
        });
        Arrays.asList(services).forEach(name -> {
            Properties prop = new Properties();
            try (FileInputStream input = new FileInputStream(this.SERVER_DIR + name + "/bootstrap.properties");){
                prop.load(input);
                String port = prop.getProperty("http.port");
                if (StringUtils.isEmpty((String)port) || "0".equals(port)) {
                    this.LOGGER.warn("No http.port configured in {}/bootstrap.properties, {} may not be available yet.", name, name);
                    this.doReload = true;
                } else {
                    this.serviceAddresses.put((String)name, this.serviceFromDispatcherURL(HttpUtils.getDefaultAddress(), (String)name, port));
                }
            }
            catch (IOException e) {
                this.LOGGER.error(e.getLocalizedMessage());
            }
        });
    }

    String serviceFromDispatcherURL(String defaultAddress, String name, String port) {
        try {
            URI internalDispatcherURL = new URI(defaultAddress);
            StringBuilder sb = new StringBuilder(internalDispatcherURL.getScheme());
            sb.append("://").append(internalDispatcherURL.getHost()).append(":").append(port);
            this.LOGGER.info("Adding service {}{}", (Object)(sb.toString() + "/"), (Object)name);
            return sb.toString();
        }
        catch (Exception ge) {
            this.LOGGER.warn(ge.getLocalizedMessage(), (Throwable)ge);
            this.LOGGER.info("Adding service {}{}{}{}", new Object[]{"http://localhost:", port, "/", name});
            return "http://localhost:" + port;
        }
    }

    void loadFromConfig(String cf) {
        if (StringUtils.isNotEmpty((String)cf)) {
            try {
                JsonObject services = JsonObject.parseString((String)cf, (boolean)true);
                services.forEach((key, value) -> {
                    if (StringUtils.isNotEmpty((String)((String)value))) {
                        this.LOGGER.info("Adding service {}", (Object)((String)value));
                        this.serviceAddresses.put((String)key, (String)value);
                    } else {
                        this.LOGGER.info("Removing service {}", key);
                        this.serviceAddresses.remove(key);
                    }
                });
            }
            catch (IOException e) {
                this.LOGGER.error("bad configuration setting for BIProxy.services: {}", (Object)cf);
            }
        }
    }

    public static LocalServiceRegistry getInstance() {
        return instance;
    }

    String getAddress(String urlPath) {
        if (this.doReload) {
            this.reload();
        }
        if (null == urlPath) {
            throw new IllegalArgumentException("urlPath cannot be null");
        }
        String serviceName = this.getServiceName(urlPath);
        if (StringUtils.isNotEmpty((String)serviceName) && this.serviceAddresses.containsKey(serviceName)) {
            return this.serviceAddresses.get(serviceName);
        }
        if (this.enableApiDocs && urlPath.contains("/api-docs/")) {
            return HttpUtils.getDefaultAddress();
        }
        return null;
    }

    String getServiceName(String urlPath) {
        if (StringUtils.isEmpty((String)urlPath)) {
            return null;
        }
        String[] parts = urlPath.split("/");
        return parts.length >= 4 ? parts[3] : null;
    }

    public void reload() {
        this.doReload = false;
        this.initialize();
    }

    public boolean isEmpty() {
        return this.serviceAddresses.isEmpty();
    }

    public void clear() {
        this.serviceAddresses.clear();
    }

    public String getServiceAddress(String service) {
        return this.serviceAddresses.get(service);
    }
}

