/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.caf;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.web.caf.CAFRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAFFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CAFFilter.class);
    private boolean enabled = Boolean.parseBoolean(ConfigurationPropertyFactory.getInstance().getStringProperty("CAF.caf_tpXSSCheckingUsed", "false").get());

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("CAFFilter initialized: {}", (Object)(this.enabled ? "enabled" : "disabled"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object httpRequest = (HttpServletRequest)request;
        if (this.isEnabled((HttpServletRequest)httpRequest) && StringUtils.equals((String)"GET", (String)httpRequest.getMethod())) {
            httpRequest.setCharacterEncoding("UTF-8");
            httpRequest = this.wrapRequest((HttpServletRequest)httpRequest);
            if (((CAFRequestWrapper)((Object)httpRequest)).getError()) {
                ((HttpServletResponse)response).sendError(400, ((CAFRequestWrapper)((Object)httpRequest)).getErrorMessage());
                return;
            }
        }
        chain.doFilter((ServletRequest)httpRequest, response);
    }

    CAFRequestWrapper wrapRequest(HttpServletRequest httpRequest) {
        return new CAFRequestWrapper(httpRequest);
    }

    private boolean isEnabled(HttpServletRequest httpRequest) {
        if (this.enabled) {
            if (httpRequest.getHeader("X-CA-XSSEncoded") != null) {
                return true;
            }
            String qs = httpRequest.getQueryString();
            if (StringUtils.contains((String)qs, (String)"XSSSTART") && !StringUtils.startsWith((String)httpRequest.getPathInfo(), (String)"/v1/disp")) {
                return true;
            }
        }
        return false;
    }

    public void destroy() {
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

