/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.caf;

import com.cognos.caf.CAFProtector;
import com.cognos.caf.common.CAFException;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAFRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CAFRequestWrapper.class);
    private final HttpServletRequest request;
    private String queryString = null;
    private Map<String, String[]> parameterMap = null;
    private StringBuilder errorMessage = new StringBuilder("Invalid query parameter(s): ");
    private boolean error = false;

    public CAFRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.decodeParameterMap();
    }

    private void decodeParameterMap() {
        this.parameterMap = this.request.getParameterMap();
        this.decodeParameterValues();
    }

    public String getQueryString() {
        if (this.queryString == null && this.parameterMap != null) {
            StringBuilder sb = new StringBuilder();
            this.parameterMap.forEach((key, values) -> {
                if (values != null) {
                    for (String value : values) {
                        sb.append((String)key).append("=").append(HttpUtils.urlEncode((String)value)).append("&");
                    }
                }
            });
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                this.queryString = sb.toString();
            }
        }
        return this.queryString;
    }

    String wrap(String val) {
        return "XSSSTART" + val + "XSSEND";
    }

    public String getParameter(String name) {
        String[] vals = this.parameterMap.get(name);
        if (vals != null && vals.length > 0) {
            return vals[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameterMap.keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    void decodeParameterValues() {
        boolean legacyUrl = this.isLegacyUrl();
        if (this.parameterMap != null) {
            this.parameterMap.forEach((key, values) -> {
                if (values != null && ((String[])values).length > 0) {
                    for (int i = 0; i < ((String[])values).length; ++i) {
                        if (legacyUrl) {
                            if (!StringUtils.startsWith((String)values[i], (String)"XSSSTART") || !StringUtils.endsWith((String)values[i], (String)"XSSEND")) continue;
                            values[i] = this.decodeParameterValue(values[i]);
                            continue;
                        }
                        values[i] = this.decodeParameterValue(this.wrap(values[i]));
                    }
                }
            });
        }
    }

    private boolean isLegacyUrl() {
        return !Boolean.parseBoolean(this.request.getHeader("X-CA-XSSEncoded"));
    }

    String decodeParameterValue(String value) {
        StringBuffer sb = new StringBuffer(value.length());
        try {
            if (this.deCaf(value, sb)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} decoded {} to {}", new Object[]{this.request.getPathInfo(), value, sb.toString()});
                }
                return sb.toString();
            }
        }
        catch (CAFException e) {
            LOGGER.error("CAFException", (Throwable)e);
            this.error = true;
            this.errorMessage.append(value).append(",");
        }
        return value;
    }

    boolean deCaf(String value, StringBuffer buf) throws CAFException {
        return CAFProtector.parseAndDecodeXSSChars((String)value, (StringBuffer)buf);
    }

    public boolean getError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }
}

