/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        final AsyncContext asyncCtx = this.getAsyncContext(servletRequest, servletResponse);
        asyncCtx.start(new Runnable(){

            @Override
            public void run() {
                HttpServletRequest req = (HttpServletRequest)asyncCtx.getRequest();
                HttpServletResponse resp = (HttpServletResponse)asyncCtx.getResponse();
                try {
                    LOGGER.trace("API Call: {} {}", (Object)req.getMethod(), (Object)req.getRequestURI());
                    chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
                catch (IOException | ServletException e) {
                    LOGGER.error(e.getLocalizedMessage());
                }
                asyncCtx.complete();
            }
        });
    }

    private AsyncContext getAsyncContext(HttpServletRequest req, HttpServletResponse resp) {
        if (req.isAsyncStarted()) {
            return req.getAsyncContext();
        }
        AsyncContext ctx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        ctx.setTimeout(0L);
        return ctx;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        LOGGER.info("AsyncFilter initialized");
    }
}

