/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ebaysf.web.cors.CORSFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BICORSFilter
implements Filter,
FilterConfig,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BICORSFilter.class);
    private CORSFilter theActualFilter;
    private FilterConfig config;
    private String[] parameterNames = new String[]{"cors.allowed.origins", "cors.allowed.headers", "cors.allowed.methods", "cors.exposed.headers", "cors.logging.enabled", "cors.preflight.maxage", "cors.request.decorate", "cors.support.credentials"};
    private final DynamicStringProperty allowedOrigins;
    private final DynamicStringProperty allowedHeaders;
    private final DynamicStringProperty allowedMethods;
    private final DynamicStringProperty exposedHeaders;
    private final DynamicStringProperty corsLoggingEnabled;
    private final DynamicStringProperty preFlightMaxAge;
    private final DynamicStringProperty corsRequestDecorate;
    private final DynamicStringProperty corsSupportCredentials;
    private final DynamicBooleanProperty enabled;

    public BICORSFilter() {
        this.theActualFilter = new CORSFilter();
        ConfigurationPropertyFactory cpf = this.getConfigurationPropertyFactory();
        this.enabled = cpf.getBooleanProperty("CORSFilter.enable", false);
        this.enabled.addCallback((Runnable)this);
        this.allowedOrigins = cpf.getStringProperty("cors.allowed.origins", "*");
        this.allowedOrigins.addCallback((Runnable)this);
        this.allowedHeaders = cpf.getStringProperty("cors.allowed.headers", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers");
        this.allowedHeaders.addCallback((Runnable)this);
        this.allowedMethods = cpf.getStringProperty("cors.allowed.methods", "GET,POST,PUT,DELETE,HEAD,OPTIONS");
        this.allowedMethods.addCallback((Runnable)this);
        this.exposedHeaders = cpf.getStringProperty("cors.exposed.headers", "");
        this.exposedHeaders.addCallback((Runnable)this);
        this.corsLoggingEnabled = cpf.getStringProperty("cors.logging.enabled", "false");
        this.corsLoggingEnabled.addCallback((Runnable)this);
        this.preFlightMaxAge = cpf.getStringProperty("cors.preflight.maxage", "1800");
        this.preFlightMaxAge.addCallback((Runnable)this);
        this.corsRequestDecorate = cpf.getStringProperty("cors.request.decorate", "true");
        this.corsRequestDecorate.addCallback((Runnable)this);
        this.corsSupportCredentials = cpf.getStringProperty("cors.support.credentials", "true");
        this.corsSupportCredentials.addCallback((Runnable)this);
    }

    public void destroy() {
        if (this.enabled.get()) {
            this.theActualFilter.destroy();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled.get()) {
            this.theActualFilter.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.theActualFilter.init((FilterConfig)this);
        LOGGER.info("BICORSFilter initialized");
    }

    public String getFilterName() {
        return "BICORSFilter";
    }

    public String getInitParameter(String name) {
        if ("cors.allowed.origins".equals(name)) {
            return this.allowedOrigins.get();
        }
        if ("cors.allowed.headers".equals(name)) {
            return this.allowedHeaders.get();
        }
        if ("cors.allowed.methods".equals(name)) {
            return this.allowedMethods.get();
        }
        if ("cors.exposed.headers".equals(name)) {
            return this.exposedHeaders.get();
        }
        if ("cors.logging.enabled".equals(name)) {
            return this.corsLoggingEnabled.get();
        }
        if ("cors.preflight.maxage".equals(name)) {
            return this.preFlightMaxAge.get();
        }
        if ("cors.request.decorate".equals(name)) {
            return this.corsRequestDecorate.get();
        }
        if ("cors.support.credentials".equals(name)) {
            return this.corsSupportCredentials.get();
        }
        return this.getConfigurationPropertyFactory().getStringProperty(name, "").get();
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(Arrays.asList(this.parameterNames));
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    @Override
    public void run() {
        try {
            this.theActualFilter.init((FilterConfig)this);
        }
        catch (ServletException e) {
            LOGGER.warn("Failed to update configuration");
        }
    }

    ConfigurationPropertyFactory getConfigurationPropertyFactory() {
        return ConfigurationPropertyFactory.getInstance();
    }
}

