/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.logging.glug.support.BITransactionHeader;
import com.ibm.bi.logging.glug.support.LoggingHint;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import com.ibm.bi.platform.commons.web.APIResponseWrapper;
import com.ibm.bi.platform.commons.web.BIRequestWrapper;
import com.ibm.bi.platform.commons.web.BIResponseWrapper;
import com.ibm.bi.platform.commons.web.filters.MessageKeys;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class BIFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIFilter.class);
    public static final String XBIPATH = "X-BI-PATH";
    public static final String XORIGURI = "X-Original-URI";
    public static final String SERVER = "CA-SERVER";
    private static DynamicStringProperty configPath = ConfigurationPropertyFactory.getInstance().getStringProperty("BIFilter.XBIPATH", "");
    private boolean dispatcherReady = false;
    private boolean enableApiDocs = Boolean.getBoolean("api-docs");
    private static boolean caProxyEnabled = Boolean.getBoolean("ca-proxy-enabled");
    private static int caProxyPort = Integer.getInteger("ca-proxy-port", -1);

    public BIFilter() {
    }

    public BIFilter(DynamicStringProperty configPath) {
        BIFilter.configPath = configPath;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        BIResponseWrapper resp;
        long startTime_ = 0L;
        long endTime_ = 0L;
        startTime_ = System.currentTimeMillis();
        this.setRequestAttributes((HttpServletRequest)request);
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        BIRequestWrapper req = new BIRequestWrapper((HttpServletRequest)request);
        BIResponseWrapper bIResponseWrapper = resp = StringUtils.contains((String)pathInfo, (String)"/api/") ? new APIResponseWrapper(req, (HttpServletResponse)response) : new BIResponseWrapper(req, (HttpServletResponse)response);
        if (!this.dispatcherReady && !req.getRequestURI().contains("rewrite-config")) {
            BIFilter bIFilter = this;
            synchronized (bIFilter) {
                if (!this.pingLocalDispatcher((HttpServletRequest)req, (HttpServletResponse)resp)) {
                    return;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)pathInfo) && pathInfo.startsWith("/v1")) {
            this.setIsInternalRequestAttribute((HttpServletRequest)req);
        }
        try {
            MDC.clear();
            this.addTransactionHeaderToMDC(req);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            MDC.clear();
        }
        endTime_ = System.currentTimeMillis();
        if (LOGGER.isTraceEnabled()) {
            this.logPerf(startTime_, endTime_, req, (HttpServletResponse)response);
        }
    }

    private void addTransactionHeaderToMDC(BIRequestWrapper req) {
        BITransactionHeader header = req.getTransactionHeader();
        for (HeaderElement element : header.getElements()) {
            MDC.put((String)element.getName(), (String)element.getValue());
        }
    }

    private void logPerf(long startTime_, long endTime_, BIRequestWrapper request, HttpServletResponse response) {
        BITransactionHeader transactionHeader = request.getTransactionHeader();
        String method = request.getMethod();
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction != null) {
            if (soapAction.length() > 7) {
                soapAction = soapAction.substring(soapAction.indexOf("cognos/") + 7);
            }
        } else {
            soapAction = "null";
        }
        String uri = request.getPathInfo();
        String qs = request.getQueryString();
        if (qs != null) {
            uri = uri + "?" + qs;
        }
        LOGGER.trace("{},{},\"{}\",{},{},{},\"{}\",{}", new Object[]{transactionHeader.getValue(), method, uri, startTime_, endTime_, endTime_ - startTime_, soapAction, response.getStatus()});
    }

    void setRequestAttributes(HttpServletRequest request) {
        request.setAttribute(XORIGURI, this.getOriginalURI(request));
        if (this.enableApiDocs) {
            request.setAttribute("api-docs", (Object)1);
        }
        request.setAttribute(SERVER, (Object)HttpUtils.getDefaultAddress());
    }

    void setIsInternalRequestAttribute(HttpServletRequest request) {
        if (request.getAttribute("Internal") == null) {
            String remoteAddr = request.getRemoteAddr();
            if (remoteAddr == null || !LocalAddresses.isLocal((String)remoteAddr)) {
                return;
            }
            if (!caProxyEnabled && this.isProxiedRequest(request)) {
                return;
            }
            request.setAttribute("Internal", (Object)"true");
        }
    }

    private Object getOriginalURI(HttpServletRequest request) {
        String origURI = null;
        String xBIPath = request.getHeader(XBIPATH);
        if (!StringUtils.isEmpty((String)xBIPath)) {
            origURI = xBIPath;
        } else {
            String sConfigPath = configPath.get();
            if (!StringUtils.isEmpty((String)sConfigPath)) {
                origURI = sConfigPath;
            } else {
                String propPath = System.getProperty(XBIPATH);
                if (!StringUtils.isEmpty((String)propPath)) {
                    origURI = propPath;
                }
            }
        }
        if (origURI == null) {
            origURI = request.getContextPath() + "/v1";
        }
        return origURI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean pingLocalDispatcher(HttpServletRequest req, HttpServletResponse resp) {
        if (this.dispatcherReady) return true;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(req);){
            String pingUrl = this.getPingURL(req);
            int status = client.getResource(pingUrl);
            if (status == 200) {
                client.getResource(this.getConfigUrl(req));
                LoggingHint.thatReadyToProcessRequests();
                this.dispatcherReady = true;
                boolean bl2 = true;
                return bl2;
            }
            resp.setStatus(503);
            resp.getWriter().write(MessageKeys.DISPATCHER_NOTREADY.buildMessage().getLocalizedMessage());
            LOGGER.debug("Dispatcher not ready. Request URI: {}", (Object)req.getRequestURI());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Dispatcher not ready. Request URI: {}", (Object)req.getRequestURI(), (Object)e);
            return false;
        }
    }

    String getRealLocalName(HttpServletRequest request) {
        String ln = request.getLocalName();
        if (StringUtils.contains((String)ln, (String)":")) {
            ln = "[" + ln + "]";
        }
        return ln;
    }

    String getPingURL(HttpServletRequest request) {
        int proxyPort = BIFilter.extractProxyPort((ServletRequest)request);
        int port = proxyPort > 0 ? proxyPort : request.getLocalPort();
        return String.format("%s://%s:%d/p2pd/servlet/ping", request.getScheme(), this.getRealLocalName(request), port);
    }

    String getConfigUrl(HttpServletRequest request) {
        return String.format("%s://%s:%d/bi/%s", request.getScheme(), this.getRealLocalName(request), request.getLocalPort(), "rewrite-config");
    }

    public void init(FilterConfig fConfig) throws ServletException {
        String cp = fConfig.getServletContext().getContextPath();
        RESTClientFactory.getInstance().startup(StringUtils.isNotEmpty((String)cp) ? cp.substring(1) : null);
        LOGGER.info("BIFilter initialized.");
    }

    boolean isProxiedRequest(HttpServletRequest request) {
        return request.getHeader("Forwarded") != null || request.getHeader("X-Forwarded-For") != null || request.getHeader("X-BI-Forwarded-For") != null;
    }

    static int extractProxyPort(ServletRequest req) {
        if (!caProxyEnabled) {
            return -1;
        }
        if (caProxyPort != -1) {
            LOGGER.debug("ca proxy port set to {} by system property", (Object)caProxyPort);
            return caProxyPort;
        }
        String caProxy = ((HttpServletRequest)req).getHeader("X-CA-Proxy");
        if (StringUtils.isEmpty((String)caProxy)) {
            LOGGER.debug("did not receive X-CA-Proxy header!");
            return -1;
        }
        int colon = caProxy.indexOf(58);
        if (colon == -1 || colon == caProxy.length() - 1) {
            return -1;
        }
        int proxyPort = NumberUtils.toInt((String)caProxy.substring(colon + 1), (int)-1);
        LOGGER.error("detected port {} from X-CA-Proxy header", (Object)proxyPort);
        return proxyPort;
    }
}

