/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIHeaderFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIHeaderFilter.class);
    private DynamicStringProperty headers = null;
    protected JsonArray headersToSet = new JsonArray();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.headersToSet.isEmpty()) {
            response = new BIHeaderResponseWrapper((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.headers = ConfigurationPropertyFactory.getInstance().getStringProperty("BIHeaderFilter.responseHeaders", "[]");
        this.headers.addCallback(new Runnable(){

            @Override
            public void run() {
                BIHeaderFilter.this.setSetHeaders();
            }
        });
        this.setSetHeaders();
    }

    String getCurrentConfigurationValue() {
        return this.headers.get();
    }

    void setSetHeaders() {
        JsonArray newHeadersToSet = new JsonArray();
        try {
            newHeadersToSet = (JsonArray)new JsonParser().parse((Reader)new StringReader(StringUtils.defaultIfBlank((String)this.getCurrentConfigurationValue(), (String)"[]")));
            LOGGER.debug("Initialized BIHeaderFilter with {}", (Object)this.headersToSet.toString());
        }
        catch (IOException e) {
            LOGGER.error("Invalid headers configuration (should be [{\"name\":\"header name\",\"value\":\"header value\"}...])");
        }
        this.headersToSet = newHeadersToSet;
    }

    public class BIHeaderResponseWrapper
    extends HttpServletResponseWrapper {
        private final HttpServletRequest request;

        public BIHeaderResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.request = request;
            this.setResponseHeaders();
        }

        void setResponseHeaders() {
            for (int i = 0; i < BIHeaderFilter.this.headersToSet.size(); ++i) {
                JsonObject header = BIHeaderFilter.this.headersToSet.getObject(i);
                this.setResponseHeader(header);
            }
        }

        private void setResponseHeader(JsonObject header) {
            if (header.containsKey((Object)"name") && header.containsKey((Object)"value")) {
                String name;
                switch (name = header.getString("name")) {
                    case "Access-Control-Allow-Origin": {
                        boolean allowed = false;
                        String value = header.getString("value");
                        String origin = this.request.getHeader("Origin");
                        if (StringUtils.equals((String)value, (String)"*")) {
                            this.setHeader(name, value);
                            allowed = true;
                            break;
                        }
                        List<String> origins = Arrays.asList(value.split(","));
                        for (String orig : origins) {
                            if (!orig.trim().equals(origin)) continue;
                            this.setHeader(name, orig.trim());
                            allowed = true;
                            break;
                        }
                        if (allowed) break;
                        this.setHeader(name, "null");
                        break;
                    }
                    default: {
                        this.setHeader(name, header.getString("value"));
                    }
                }
                LOGGER.debug("Added header: {}={}", (Object)header.getString("name"), (Object)header.getString("value"));
            }
        }
    }
}

