/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import com.ibm.bi.platform.commons.web.BIProxyBase;
import com.ibm.bi.platform.commons.web.filters.BIFilter;
import com.netflix.config.DynamicStringProperty;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIProxy
extends BIProxyBase
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(BIProxy.class);
    private static final String LOCAL = "__LOCAL__";
    private static final String UNKNOWN = "__UNKNOWN__";
    private URI cmUri;
    private String activeCMEndpoint;

    synchronized void updateCMUrl(String cmUrl) {
        this.cmUri = null;
        this.activeCMEndpoint = null;
        if (StringUtils.isBlank((String)cmUrl)) {
            LOGGER.warn("active CM is unknown");
            return;
        }
        try {
            if (cmUrl.contains("/p2pd")) {
                LOGGER.debug("processing update to CM URL: {}", (Object)cmUrl);
                this.cmUri = new URI(cmUrl);
                this.activeCMEndpoint = StringUtils.substringBefore((String)cmUrl, (String)"/p2pd");
            } else {
                LOGGER.error("CM URL not recognized (expected http[s]://server[:port]/p2pd/servlet): {}", (Object)cmUrl);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("URL invalid.", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        final DynamicStringProperty cmProp = ConfigurationPropertyFactory.getInstance().getStringProperty("contentManager");
        String cmUrl = cmProp.get();
        LOGGER.debug("initializing BIProxy for url {}", (Object)cmUrl);
        this.updateCMUrl(cmUrl);
        cmProp.addCallback(new Runnable(){

            @Override
            public void run() {
                BIProxy.this.updateCMUrl(cmProp.get());
            }
        });
        LOGGER.info("BIProxy initialized.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String cmEndpoint = this.getCMEndpoint(servletRequest);
        if (this.isEndpointUnknown(cmEndpoint)) {
            LOGGER.error("active CM is unknown, fail the request");
            ((HttpServletResponse)servletResponse).sendError(503, "active CM is unknown");
        }
        if (this.isLocalEndpoint(cmEndpoint)) {
            LOGGER.trace("process request for {} locally", (Object)request.getRequestURI());
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            LOGGER.trace("forward request for {} to CM install {}", (Object)request.getRequestURI(), (Object)cmEndpoint);
            this.remote(request, (HttpServletResponse)servletResponse, cmEndpoint);
        }
    }

    private synchronized String getCMEndpoint(ServletRequest req) {
        if (this.cmUri == null) {
            return UNKNOWN;
        }
        try {
            return this.isLocalCM(req) ? LOCAL : this.activeCMEndpoint;
        }
        catch (UnknownHostException e) {
            LOGGER.error("CM host is unknown.", (Throwable)e);
            return UNKNOWN;
        }
    }

    private boolean isLocalCM(ServletRequest req) throws UnknownHostException {
        if (!LocalAddresses.isLocal((String)InetAddress.getByName(this.cmUri.getHost()).getHostAddress())) {
            return false;
        }
        if (this.cmUri.getPort() == req.getLocalPort()) {
            return true;
        }
        if (this.cmUri.getPort() == BIFilter.extractProxyPort(req)) {
            LOGGER.trace("isLocalCM returns true because proxy port matches");
            return true;
        }
        return false;
    }

    private boolean isLocalEndpoint(String endpoint) {
        return LOCAL.equals(endpoint);
    }

    private boolean isEndpointUnknown(String endpoint) {
        return UNKNOWN.equals(endpoint);
    }

    public void destroy() {
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getTargetServiceName(HttpServletRequest request) {
        return request.getRequestURI().replaceAll(".*/proxy", "");
    }

    URI getCmUri() {
        return this.cmUri;
    }

    String getActiveCMEndpoint() {
        return this.activeCMEndpoint;
    }
}

