/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.platform.commons.web.filters.rewrite.DelegatingFilterConfig;
import com.ibm.bi.platform.commons.web.filters.rewrite.DelegatingServletContext;
import com.ibm.bi.platform.commons.web.filters.rewrite.LazyLoadNamedServletContext;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;

public class BIRewriteFilter
extends UrlRewriteFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BIRewriteFilter.class);
    public static final String RELOAD_CONFIG = "rewrite-config";
    private static final int MAX_RETRY_COUNT = 50;
    private int retryCount = 0;
    private boolean debug = Boolean.getBoolean("service-debug");
    private long lastChecked;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init((FilterConfig)new FilterConfigWrapper(filterConfig));
        LOGGER.info("BIRewriteFilter initialized.");
    }

    protected UrlRewriter getUrlRewriter(ServletRequest request, ServletResponse response, FilterChain chain) {
        UrlRewriter rewriter;
        if (this.debug && this.reloadNow()) {
            this.reloadConfig();
        }
        if ((rewriter = super.getUrlRewriter(request, response, chain)) == null) {
            if (this.retryCount <= 50) {
                this.reloadConfig();
            } else {
                ++this.retryCount;
            }
        }
        return rewriter;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String queryString = ((HttpServletRequest)request).getQueryString();
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (StringUtils.isNotEmpty((String)queryString) && queryString.contains(RELOAD_CONFIG) || StringUtils.isNotEmpty((String)requestURI) && requestURI.contains(RELOAD_CONFIG)) {
            this.reloadConfig();
            ((HttpServletResponse)response).setStatus(200);
            return;
        }
        super.doFilter(request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfig() {
        BIRewriteFilter bIRewriteFilter = this;
        synchronized (bIRewriteFilter) {
            try {
                LOGGER.debug("reloading config");
                this.loadUrlRewriter(null);
            }
            catch (ServletException e) {
                LOGGER.error("Error re-loading urlRewriter", (Throwable)e);
            }
        }
    }

    private boolean reloadNow() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked > 5000L) {
            this.lastChecked = now;
            this.retryCount = 0;
            return true;
        }
        return false;
    }

    private static class ServletContextWrapper
    extends DelegatingServletContext {
        ServletContext sc;

        ServletContextWrapper(ServletContext sc) {
            super(sc);
            this.sc = sc;
        }

        @Override
        public ServletContext getContext(String contextName) {
            ServletContext namedContext = super.getContext(contextName);
            if (namedContext != null) {
                LOGGER.debug("context name \"{}\" was found.", (Object)contextName);
                return namedContext;
            }
            LOGGER.warn("context name \"{}\" does not exist or has not been loaded, returning a LazyLoadServletContext.", (Object)contextName);
            return new LazyLoadNamedServletContext(this.sc, contextName);
        }
    }

    private static class FilterConfigWrapper
    extends DelegatingFilterConfig {
        ServletContextWrapper scWrapper;

        FilterConfigWrapper(FilterConfig config) {
            super(config);
            this.scWrapper = new ServletContextWrapper(config.getServletContext());
        }

        @Override
        public ServletContext getServletContext() {
            return this.scWrapper;
        }
    }
}

