/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.http.util.HttpUtils;
import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import com.ibm.bi.platform.commons.security.PassportValidator;
import com.ibm.bi.platform.commons.web.BIRequestWrapper;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BISecurityFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(BISecurityFilter.class);
    private String ignorePassportCheckURLPattern;
    private String ignoreXSRFCheckURLPattern;
    private String ignoreXSRFCheckOnGetURLPattern;
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String INIT_PARAM_IGNORE_URL_PATTERN = "ignoreURLPattern";
    private static final String INIT_PARAM_IGNORE_XSRF_CHECK = "ignoreXSRFCheck";
    private static final String INIT_PARAM_IGNORE_XSRF_CHECK_ON_GET = "ignoreXSRFCheckOnGet";
    static final String UNAUTHORIZED = "Unauthorized - Authentication required.";
    private static boolean api_docs = Boolean.getBoolean("api-docs");
    private static boolean disableXsrfCheck = Boolean.getBoolean("disableXSRFCheck");
    private static boolean disableXsrfForLocal = Boolean.getBoolean("disableXsrfForLocal");
    private static boolean disableBiSecurityFilter = Boolean.getBoolean("disable-bisecurityfilter");
    private final Set<String> allowedMethods = new HashSet<String>();
    private RESTClientFactory rcFactory;
    private PassportValidator passportValidator;

    public BISecurityFilter() {
        this.allowedMethods.addAll(Arrays.asList("OPTIONS", "HEAD"));
    }

    public void init(FilterConfig fConfig) throws ServletException {
        this.rcFactory = RESTClientFactory.getInstance();
        String cp = fConfig.getServletContext().getContextPath();
        this.rcFactory.startup(StringUtils.isNotEmpty((String)cp) ? cp.substring(1) : null);
        this.ignorePassportCheckURLPattern = fConfig.getInitParameter(INIT_PARAM_IGNORE_URL_PATTERN);
        this.ignoreXSRFCheckURLPattern = fConfig.getInitParameter(INIT_PARAM_IGNORE_XSRF_CHECK);
        this.ignoreXSRFCheckOnGetURLPattern = fConfig.getInitParameter(INIT_PARAM_IGNORE_XSRF_CHECK_ON_GET);
        this.passportValidator = new PassportValidator(this.rcFactory, ConfigurationPropertyFactory.getInstance());
        LOGGER.info("BISecurityFilter initialized.");
    }

    public void destroy() {
    }

    void setIgnorePassportCheckURLPattern(String theIgnorePassportCheckURLPattern) {
        this.ignorePassportCheckURLPattern = theIgnorePassportCheckURLPattern;
    }

    void setIgnoreXSRFCheckURLPattern(String theIgnoreXSRFCheckURLPattern) {
        this.ignoreXSRFCheckURLPattern = theIgnoreXSRFCheckURLPattern;
    }

    void setIgnoreXSRFCheckOnGetURLPattern(String theIgnoreXSRFCheckOnGetURLPattern) {
        this.ignoreXSRFCheckOnGetURLPattern = theIgnoreXSRFCheckOnGetURLPattern;
    }

    static void setApiDocs(boolean api_docs) {
        BISecurityFilter.api_docs = api_docs;
    }

    static void setDisableXsrfCheck(boolean disableXsrfCheck) {
        BISecurityFilter.disableXsrfCheck = disableXsrfCheck;
    }

    void setDisableBiSecurityFilter(boolean disableBisecurityfilter) {
        disableBiSecurityFilter = disableBisecurityfilter;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!this.isBiSecurityFilterDisabled() && !this.isRequestTrusted(req)) {
            if (!this.doAuthValidation(req, resp)) {
                return;
            }
            if (!this.isXsrfCheckDisabled(req) && !this.doXSRFValidation(req, resp)) {
                return;
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    PassportValidator getPassportValidator() {
        return this.passportValidator;
    }

    boolean isBiSecurityFilterDisabled() {
        return disableBiSecurityFilter;
    }

    boolean isXsrfCheckDisabled(HttpServletRequest req) {
        if (disableXsrfCheck) {
            return true;
        }
        if (api_docs && this.isSwaggerRequest(req)) {
            return true;
        }
        return disableXsrfForLocal && req.getHeader("Referer") == null && LocalAddresses.isLocal((String)req.getRemoteAddr());
    }

    boolean isRequestTrusted(HttpServletRequest req) {
        String trustToken = req.getHeader("X-CA-Authorization");
        if (StringUtils.isNotBlank((String)trustToken)) {
            try {
                return JCAMCrypto.createTrustedRequestSession().verifyToken(trustToken);
            }
            catch (CAMCryptoException e) {
                LOGGER.error("exception at verifying trust token: {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    boolean isSwaggerRequest(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        String referer = req.getHeader("Referer");
        return StringUtils.isNotEmpty((String)referer) && referer.contains("/api-docs/") || StringUtils.isNotEmpty((String)pathInfo) && pathInfo.contains("/api-docs");
    }

    boolean doAuthValidation(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        int status = this.checkForPassportValidity(req, resp);
        switch (status) {
            case 0: {
                LOGGER.trace("auth validation: Not received passport.");
                resp.sendError(441, UNAUTHORIZED);
                return false;
            }
            case 1: {
                LOGGER.trace("auth validation: Validated passport.");
                return true;
            }
            case -1: {
                LOGGER.warn("auth validation: Received passport, passport is expired.");
                resp.sendError(441, UNAUTHORIZED);
                return false;
            }
        }
        LOGGER.warn("auth validation: Received passport, failed at validating passport.");
        resp.sendError(status);
        return false;
    }

    boolean doXSRFValidation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StringBuffer request = req.getRequestURL();
        String xsrfToken = ((BIRequestWrapper)req).getCookieValue("XSRF-TOKEN");
        String requestURI = req.getRequestURI();
        if (this.checkURLMatch(this.ignoreXSRFCheckURLPattern, requestURI)) {
            if (xsrfToken == null) {
                xsrfToken = HttpUtils.generateNewXSRFToken();
                resp.addCookie(new Cookie("XSRF-TOKEN", xsrfToken));
            }
            return true;
        }
        String httpMethod = req.getMethod();
        if (xsrfToken == null) {
            return this.processMissingXSRFCookie(req, resp, request, requestURI, httpMethod);
        }
        return this.processXSRFCookie(req, resp, request, requestURI, xsrfToken, httpMethod);
    }

    private boolean processMissingXSRFCookie(HttpServletRequest req, HttpServletResponse resp, StringBuffer request, String requestURI, String httpMethod) throws IOException {
        if (httpMethod.equalsIgnoreCase("GET")) {
            String camPassport = ((BIRequestWrapper)req).getCookieValue(CAM_PASSPORT);
            if (camPassport == null) {
                String xsrfToken = HttpUtils.generateNewXSRFToken();
                resp.addCookie(new Cookie("XSRF-TOKEN", xsrfToken));
                return true;
            }
            if (this.checkURLMatch(this.ignoreXSRFCheckOnGetURLPattern, requestURI)) {
                return true;
            }
            LOGGER.error("XSRF: XSRF-Token does not exist for GET request and cam_passport is not null");
            LOGGER.error("   requestURL: " + request.toString());
            return this.rejectRequest(resp);
        }
        LOGGER.error("XSRF: XSRF-Token does not exist for method " + httpMethod);
        LOGGER.error("   requestURL: " + request.toString());
        return this.rejectRequest(resp);
    }

    private boolean processXSRFCookie(HttpServletRequest req, HttpServletResponse resp, StringBuffer request, String requestURI, String xsrfToken, String httpMethod) throws IOException {
        Enumeration xsrfHeaders = req.getHeaders("X-XSRF-TOKEN");
        try {
            String xsrfHeader = (String)xsrfHeaders.nextElement();
            if (!xsrfHeader.equals(xsrfToken)) {
                LOGGER.error("XSRF: Cookie and header exist but are different");
                LOGGER.error("   requestURL: " + request.toString());
                return this.rejectRequest(resp);
            }
            return true;
        }
        catch (NoSuchElementException e) {
            if (httpMethod.equalsIgnoreCase("GET") && this.checkURLMatch(this.ignoreXSRFCheckOnGetURLPattern, requestURI)) {
                return true;
            }
            LOGGER.error("XSRF: Cookie exists but header does not");
            LOGGER.error("   requestURL: " + request.toString());
            return this.rejectRequest(resp);
        }
    }

    private boolean rejectRequest(HttpServletResponse resp) throws IOException {
        resp.setStatus(403);
        resp.addHeader("X-BI-XSRF", "Rejected");
        resp.getWriter().write("Forbidden");
        return false;
    }

    private boolean checkURLMatch(String regEx, String url) {
        return regEx != null && url != null && url.matches(regEx);
    }

    private boolean isURLIgnored(String url) {
        return this.ignorePassportCheckURLPattern != null && url != null && url.matches(this.ignorePassportCheckURLPattern);
    }

    private int checkForPassportValidity(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String requestURI = req.getRequestURI();
        int result = -1;
        result = this.isURLIgnored(requestURI) ? 1 : this.getPassportValidator().checkPassportValidity(req, resp);
        return result;
    }
}

