/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.platform.commons.web.CompressedServletResponseWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(CompressionFilter.class);
    private String ignoreURLPatternString;
    private Pattern ignoreURLPattern = null;
    private static final String INIT_PARAM_IGNORE_URL_PATTERN = "ignoreURLPattern";
    public static final String GZIP = "gzip";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static String off = System.getProperty("compression-filter");

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("CompressionFilter initialized.");
        this.ignoreURLPatternString = filterConfig.getInitParameter(INIT_PARAM_IGNORE_URL_PATTERN);
        if (StringUtils.isNotBlank((String)this.ignoreURLPatternString)) {
            this.ignoreURLPattern = Pattern.compile(this.ignoreURLPatternString);
        }
        LOGGER.debug("CompressionFilter ignoreURLPattern {}", (Object)this.ignoreURLPatternString);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Object httpResponse = (HttpServletResponse)response;
        CompressedServletResponseWrapper compressedResponse = null;
        if (this.isURLIgnored(httpRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        if (this.acceptsCompressedResponse(httpRequest)) {
            compressedResponse = new CompressedServletResponseWrapper((HttpServletResponse)httpResponse);
            httpResponse = compressedResponse;
        }
        try {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            if (compressedResponse != null) {
                compressedResponse.close();
            }
        }
    }

    boolean isURLIgnored(String url) {
        if (StringUtils.equals((String)off, (String)"off")) {
            return true;
        }
        if (this.ignoreURLPattern != null && this.ignoreURLPattern.matcher(url).matches()) {
            LOGGER.debug("ignoring {}", (Object)url);
            return true;
        }
        return false;
    }

    private boolean acceptsCompressedResponse(HttpServletRequest httpRequest) {
        String acceptedEncoding = httpRequest.getHeader(ACCEPT_ENCODING);
        return acceptedEncoding != null && acceptedEncoding.indexOf(GZIP) != -1;
    }

    void setIgnoreURLPattern(Pattern ignoreURLPattern) {
        this.ignoreURLPattern = ignoreURLPattern;
    }
}

