/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import com.ibm.bi.logging.glug.support.web.GlugLoggingContext;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.platform.commons.web.BIRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class LoggingContextFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingContextFilter.class);
    public static final String MDC_LOGIN_ID = "userName";
    private static final String CLEARED_IN_MDC = "{} cleared in MDC";
    static final String UNKNOWN_USER = "_unknown_";
    UserPreferencesFactory userPreferencesFactory = new UserPreferencesFactory(){

        @Override
        public UserPreferences make(String cookieValue) {
            return new UserPreferences(cookieValue);
        }
    };

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        MDCAdapter mdc = MDC.getMDCAdapter();
        this.setupContext(req, mdc);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        this.clearUserMDCVariables(mdc);
        GlugLoggingContext.clearContext((MDCAdapter)mdc);
    }

    void setupContext(HttpServletRequest req, MDCAdapter mdc) {
        try {
            GlugLoggingContext.setupContext((HttpServletRequest)req, (MDCAdapter)mdc);
            this.setupUserPrefs(mdc, req);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("unable to set logging MDC properties {}", (Throwable)e);
        }
    }

    String setupUserPrefs(MDCAdapter mdc, HttpServletRequest req) {
        String currentUser = String.format("LoginUser%s", Integer.toString(UNKNOWN_USER.hashCode()));
        String cookieValue = ((BIRequestWrapper)req).getCookieValue("up");
        if (cookieValue != null) {
            String user = this.userPreferencesFactory.make(cookieValue).getUserName();
            if (!StringUtils.isEmpty((String)user)) {
                currentUser = String.format("LoginUser%s", Integer.toString(user.hashCode()));
            }
        } else {
            LOGGER.debug("unable to get UserPreferences cookie value.");
        }
        mdc.put(MDC_LOGIN_ID, currentUser);
        return currentUser;
    }

    void clearUserMDCVariables(MDCAdapter mdc) {
        mdc.remove(MDC_LOGIN_ID);
        LOGGER.debug(CLEARED_IN_MDC, (Object)MDC_LOGIN_ID);
    }

    public void init(FilterConfig fConfig) throws ServletException {
        LOGGER.info("LoggingContextFilter initialized");
    }

    static interface UserPreferencesFactory {
        public UserPreferences make(String var1);
    }
}

