/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(RedirectFilter.class);
    private static String pathRegex = "^/(ags|alp|camcrypto|cchl|ccl|ccs|common|cps4|cr1|documentation|dojo16|dojo17|drill|dtds|explore|flex|fmmd|fragments|hal|icd|iwidget|mdsrv|migration|mod|onebox|ppwb|prompting|ps|qfw|qs|queryservice|relmd|reportstyles|rv|schemas|skins|tm1|uipe|viscoach)/(.*)$";
    private static Pattern pathPattern = Pattern.compile(pathRegex);
    private static String fileRegex = "^/[a-zA-Z0-9]+\\.(html?|xsl|js|xml|config)$";
    private static Pattern filePattern = Pattern.compile(fileRegex);
    private static String notRegex = "^/(default|index)\\.html?";
    private static Pattern notPattern = Pattern.compile(notRegex);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo;
        String referer;
        if (request instanceof HttpServletRequest && ((referer = ((HttpServletRequest)request).getHeader("Referer")) == null || referer.matches("^.*/v1/disp.*$")) && (pathInfo = ((HttpServletRequest)request).getPathInfo()) != null) {
            Matcher pathMatcher = pathPattern.matcher(pathInfo);
            Matcher fileMatcher = filePattern.matcher(pathInfo);
            Matcher notMatcher = notPattern.matcher(pathInfo);
            if ((pathMatcher.find() || fileMatcher.find()) && !notMatcher.find()) {
                ((HttpServletResponse)response).setStatus(301);
                String location = this.buildLocation((HttpServletRequest)request, pathInfo);
                ((HttpServletResponse)response).setHeader("Location", location);
                LOGGER.trace("redirecting: {} to {}", (Object)pathInfo, (Object)location);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    String buildLocation(HttpServletRequest req, String pathInfo) {
        String pathRoot = req.getHeader("X-WebContentRoot");
        if (pathRoot == null) {
            pathRoot = req.getHeader("X-BI-PATH");
            pathRoot = pathRoot != null && pathRoot.contains("/bi") ? pathRoot.substring(0, pathRoot.indexOf("/bi")) : "";
        }
        StringBuilder location = new StringBuilder();
        location.append(pathRoot).append(pathInfo);
        location.append(this.buildQueryString(req));
        return location.toString();
    }

    private String buildQueryString(HttpServletRequest request) {
        String qs = request.getQueryString();
        if (StringUtils.isNotEmpty((String)qs)) {
            return "?" + qs;
        }
        return "";
    }

    public void init(FilterConfig fConfig) throws ServletException {
        LOGGER.info("RedirectFilter initialized.");
    }
}

